/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import jakarta.ejb.ObjectNotFoundException;
import org.apache.openejb.test.entity.cmp.ComplexCmpBeanPk;
import org.apache.openejb.test.entity.cmp.ComplexCmpHome;
import org.apache.openejb.test.entity.cmp.ComplexCmpTestClient;

public class ComplexEjbObjectTests
extends ComplexCmpTestClient {
    public ComplexEjbObjectTests() {
        super("EJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp/ComplexCmpHome");
        this.ejbHome = (ComplexCmpHome)obj;
        this.ejbObject = this.ejbHome.createObject("Third Bean");
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.ejbObject != null) {
            this.ejbObject.remove();
        }
        super.tearDown();
    }

    public void test01_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            ComplexEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            ComplexEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getPrimaryKey() {
        try {
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
            ComplexEjbObjectTests.assertNotNull((String)"The primary key is null", (Object)this.ejbPrimaryKey);
            ComplexEjbObjectTests.assertTrue((String)("Expected (ejbPrimaryKey instanceof ComplexCmpBeanPk) but was instanceof " + this.ejbPrimaryKey.getClass().getName()), (boolean)(this.ejbPrimaryKey instanceof ComplexCmpBeanPk));
        }
        catch (Exception e) {
            e.printStackTrace();
            ComplexEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical() {
        try {
            ComplexEjbObjectTests.assertTrue((String)"The EJBObjects are not equal", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            ComplexEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            ComplexEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            ComplexEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_remove() {
        try {
            this.ejbObject.remove();
            try {
                this.ejbHome.findByPrimaryKey((ComplexCmpBeanPk)this.ejbPrimaryKey);
                ComplexEjbObjectTests.fail((String)"Entity was not actually removed");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                ComplexEjbObjectTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            ComplexEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.ejbObject = null;
        }
    }
}

