/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import jakarta.ejb.EJBObject;
import org.apache.openejb.test.beans.TimerSync;
import org.apache.openejb.test.object.OperationsPolicy;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessTestClient;

public class StatelessAllowedOperationsTests
extends BasicStatelessTestClient {
    protected TimerSync timerSync;

    public StatelessAllowedOperationsTests() {
        super("AllowedOperations.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)obj;
        this.ejbObject = this.ejbHome.createObject();
        this.ejbHandle = this.ejbObject.getHandle();
        this.timerSync = (TimerSync)this.initialContext.lookup("TimerSyncBeanBusinessRemote");
        this.ejbObject.businessMethod("activate me please");
    }

    private void setUp_ejbActivate_Passivate() throws Exception {
        EJBObject[] ejbObjects = new EJBObject[10];
        for (int i = 0; i < ejbObjects.length; ++i) {
            ejbObjects[i] = this.ejbHome.createObject();
        }
        this.ejbObject.businessMethod("activate me please");
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.ejbObject.remove();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setSessionContext");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(4);
            policy.allow(2);
            policy.allow(6);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void _test05_ejbTimeout() {
        try {
            this.ejbObject.scheduleTimer("StatelessAllowedOperationsTests");
            this.timerSync.waitFor("StatelessAllowedOperationsTests");
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(4);
            policy.allow(2);
            policy.allow(6);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbTimeout");
            StatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            StatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

