/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import jakarta.ejb.EJBMetaData;
import jakarta.ejb.Handle;
import jakarta.ejb.HomeHandle;
import jakarta.transaction.RollbackException;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.openejb.test.NamedTestCase;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.object.Account;
import org.apache.openejb.test.object.Transaction;
import org.apache.openejb.test.singleton.BeanTxSingletonHome;
import org.apache.openejb.test.singleton.BeanTxSingletonObject;

public class SingletonBeanTxTests
extends NamedTestCase {
    public static final String jndiEJBHomeEntry = "client/tests/singleton/BeanManagedTransactionTests/EJBHome";
    protected BeanTxSingletonHome ejbHome;
    protected BeanTxSingletonObject ejbObject;
    protected EJBMetaData ejbMetaData;
    protected HomeHandle ejbHomeHandle;
    protected Handle ejbHandle;
    protected Integer ejbPrimaryKey;
    protected InitialContext initialContext;

    public SingletonBeanTxTests() {
        super("Singleton.BeanManagedTransaction.");
    }

    @Override
    protected void setUp() throws Exception {
        Properties properties = TestManager.getServer().getContextEnvironment();
        this.initialContext = new InitialContext(properties);
        Object obj = this.initialContext.lookup(jndiEJBHomeEntry);
        this.ejbHome = (BeanTxSingletonHome)obj;
        this.ejbObject = this.ejbHome.create();
        TestManager.getDatabase().createAccountTable();
    }

    @Override
    protected void tearDown() throws Exception {
        TestManager.getDatabase().dropAccountTable();
    }

    public void test01_EJBContext_getUserTransaction() {
        try {
            Transaction t = this.ejbObject.getUserTransaction();
            SingletonBeanTxTests.assertNotNull((String)"UserTransaction is null.", (Object)t);
        }
        catch (Exception e) {
            SingletonBeanTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_java_comp_UserTransaction() {
        try {
            Transaction t = this.ejbObject.jndiUserTransaction();
            SingletonBeanTxTests.assertNotNull((String)"UserTransaction is null. Could not retreive a UserTransaction from the bean's JNDI namespace.", (Object)t);
        }
        catch (Exception e) {
            SingletonBeanTxTests.fail((String)("Could not retreive a UserTransaction from the bean's JNDI namespace. Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_EJBContext_setRollbackOnly() {
    }

    public void TODO_test04_EJBContext_getRollbackOnly() {
    }

    public void test05_singleTransactionCommit() {
        try {
            Account expected = new Account("123-45-6789", "Joe", "Cool", 40000);
            Account actual = new Account();
            this.ejbObject.openAccount(expected, Boolean.FALSE);
            actual = this.ejbObject.retreiveAccount(expected.getSsn());
            SingletonBeanTxTests.assertNotNull((String)"The transaction was not commited.  The record is null", (Object)actual);
            SingletonBeanTxTests.assertEquals((String)"The transaction was not commited cleanly.", (Object)expected, (Object)actual);
        }
        catch (RollbackException re) {
            SingletonBeanTxTests.fail((String)("Transaction was rolledback.  Received Exception " + String.valueOf(((Object)((Object)re)).getClass()) + " : " + re.getMessage()));
        }
        catch (Exception e) {
            SingletonBeanTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void BUG_test06_singleTransactionRollback() {
        Account expected = new Account("234-56-7890", "Charlie", "Brown", 20000);
        Account actual = new Account();
        try {
            this.ejbObject.openAccount(expected, Boolean.TRUE);
            SingletonBeanTxTests.fail((String)"A jakarta.transaction.RollbackException should have been thrown.");
        }
        catch (RollbackException rollbackException) {
        }
        catch (Exception e) {
            SingletonBeanTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void TODO_test07_serialTransactions() {
    }

    public void TODO_test08_nestedTransactions() {
    }

    public void TODO_test09_beginWithNoCommit() {
    }

    public void TODO_test10_scenario1_NoneNone() {
    }

    public void TODO_test11_scenario2_T1None() {
    }
}

