/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.openejb.test.TestClient;
import org.apache.openejb.test.TestManager;

public abstract class ServletTestClient
extends TestClient {
    protected URL serverUrl;
    private final String servletName;

    public ServletTestClient(String servletName) {
        super("Servlet." + servletName + ".");
        this.servletName = servletName;
        String serverUri = System.getProperty("openejb.server.uri", "http://127.0.0.1:8080/tomee/ejb");
        try {
            this.serverUrl = new URL(serverUri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Authenticator.setDefault(new StaticAuthenticator());
    }

    @Override
    protected void setUp() throws Exception {
        Properties properties = TestManager.getServer().getContextEnvironment();
        this.initialContext = new InitialContext(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(String methodName) {
        InputStream in = null;
        try {
            URL url = new URL(this.serverUrl, "/itests/" + this.servletName + "?method=" + methodName);
            URLConnection connection = url.openConnection();
            connection.connect();
            in = connection.getInputStream();
            String response = ServletTestClient.readAll(in);
            if (response.startsWith("FAILED")) {
                response = response.substring("FAILED".length()).trim();
                ServletTestClient.fail((String)response);
            }
        }
        catch (Exception e) {
            ServletTestClient.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static String readAll(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = in.read();
        while (i != -1) {
            sb.append((char)i);
            i = in.read();
        }
        return sb.toString();
    }

    protected <T> T newServletProxy(Class<T> clazz) {
        Object proxy = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ServletInvocationHandler());
        return (T)proxy;
    }

    private static class StaticAuthenticator
    extends Authenticator {
        private StaticAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication("user", "user".toCharArray());
        }
    }

    private class ServletInvocationHandler
    implements InvocationHandler {
        private ServletInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getParameterTypes().length != 0) {
                throw new IllegalArgumentException("ServletProxy only supports no-argument methods: " + String.valueOf(method));
            }
            String methodName = method.getName();
            return ServletTestClient.this.invoke(methodName);
        }
    }
}

