/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmr;

import jakarta.ejb.CreateException;
import jakarta.ejb.FinderException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.openejb.test.entity.cmr.AbstractCMRTest;
import org.apache.openejb.test.entity.cmr.onetomany.ArtistLocal;
import org.apache.openejb.test.entity.cmr.onetomany.ArtistLocalHome;
import org.apache.openejb.test.entity.cmr.onetomany.SongLocal;
import org.apache.openejb.test.entity.cmr.onetomany.SongLocalHome;

public class OneToManyTests
extends AbstractCMRTest {
    private ArtistLocalHome artistLocalHome;
    private SongLocalHome songLocalHome;

    public OneToManyTests() {
        super("OneToMany.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.artistLocalHome = (ArtistLocalHome)this.initialContext.lookup("client/tests/entity/cmr/oneToMany/ArtistLocal");
        this.songLocalHome = (SongLocalHome)this.initialContext.lookup("client/tests/entity/cmr/oneToMany/SongLocal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test00_AGetBExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            Set bSet = artist.getPerformed();
            OneToManyTests.assertEquals((long)2L, (long)bSet.size());
            for (Object value : bSet) {
                SongLocal song = (SongLocal)value;
                if (song.getId().equals(11)) {
                    OneToManyTests.assertEquals((Object)"value11", (Object)song.getName());
                    continue;
                }
                if (song.getId().equals(22)) {
                    OneToManyTests.assertEquals((Object)"value22", (Object)song.getName());
                    continue;
                }
                OneToManyTests.fail();
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    public void test01_BGetAExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            ArtistLocal artist = song.getPerformer();
            OneToManyTests.assertNotNull((Object)artist);
            OneToManyTests.assertEquals((Object)new Integer(1), (Object)artist.getId());
            OneToManyTests.assertEquals((Object)"value1", (Object)artist.getName());
            song = this.findSong(22);
            artist = song.getPerformer();
            OneToManyTests.assertNotNull((Object)artist);
            OneToManyTests.assertEquals((Object)new Integer(1), (Object)artist.getId());
            OneToManyTests.assertEquals((Object)"value1", (Object)artist.getName());
        }
        finally {
            this.completeTransaction();
        }
    }

    public void test02_ASetBDropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            artist.setPerformed(new HashSet());
        }
        finally {
            this.completeTransaction();
        }
        this.assertUnlinked(1);
    }

    public void test03_BSetADropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            song.setPerformer(null);
            song = this.findSong(22);
            song.setPerformer(null);
        }
        finally {
            this.completeTransaction();
        }
        this.assertUnlinked(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test04_ASetBNewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(2);
            SongLocal song = this.findSong(22);
            HashSet<SongLocal> songSets = new HashSet<SongLocal>();
            songSets.add(song);
            artist.setPerformed(songSets);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 22);
    }

    public void test05_BSetANewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(2);
            SongLocal song = this.findSong(22);
            song.setPerformer(artist);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 22);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test06_ASetBExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(2);
            SongLocal song = this.findSong(11);
            Set songSets = artist.getPerformed();
            songSets.add(song);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 11);
    }

    public void test07_BSetAExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(2);
            SongLocal song = this.findSong(11);
            song.setPerformer(artist);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test08_ASetBExistingANewB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            SongLocal song = this.createSong(33);
            Set songSets = artist.getPerformed();
            songSets.add(song);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 11, 22, 33);
    }

    public void test09_BSetAExistingANewB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            SongLocal song = this.createSong(33);
            song.setPerformer(artist);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 11, 22, 33);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test10_RemoveRelationships() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            ArtistLocal artist = song.getPerformer();
            Set songs = artist.getPerformed();
            OneToManyTests.assertTrue((boolean)songs.contains(song));
            song.remove();
            OneToManyTests.assertFalse((boolean)songs.contains(song));
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 22);
        this.assertUnlinked(2);
    }

    public void TODO_testCMPMappedToForeignKeyColumn() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            Integer field3 = song.getBpm();
            OneToManyTests.assertEquals((Object)song.getPerformer().getPrimaryKey(), (Object)field3);
        }
        finally {
            this.completeTransaction();
        }
    }

    public void TODO_testSetCMPMappedToForeignKeyColumn() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            song.setBpm(Integer.valueOf(2));
            ArtistLocal artist = song.getPerformer();
            OneToManyTests.assertEquals((Object)new Integer(2), (Object)artist.getId());
            OneToManyTests.assertEquals((Object)"value2", (Object)artist.getName());
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test11_Delete() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            artist.setPerformed(new HashSet());
            Set songs = artist.getComposed();
            HashSet bsCopies = new HashSet(songs);
            OneToManyTests.assertSame((Object)songs, (Object)artist.getComposed());
            artist.remove();
            OneToManyTests.assertTrue((String)("CMR collection is not empty " + System.identityHashCode(songs)), (boolean)songs.isEmpty());
            for (SongLocal songLocal : bsCopies) {
                OneToManyTests.assertNull((Object)songLocal.getComposer());
            }
        }
        finally {
            this.completeTransaction();
        }
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM Song");
        OneToManyTests.assertTrue((boolean)rs.next());
        OneToManyTests.assertEquals((long)2L, (long)rs.getInt(1));
        rs.close();
        s.close();
        c.close();
    }

    public void test12_CascadeDelete() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            Set songs = artist.getPerformed();
            OneToManyTests.assertFalse((boolean)songs.isEmpty());
            artist.remove();
            OneToManyTests.assertTrue((boolean)songs.isEmpty());
        }
        finally {
            this.completeTransaction();
        }
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM Song");
        OneToManyTests.assertTrue((boolean)rs.next());
        OneToManyTests.assertEquals((long)0L, (long)rs.getInt(1));
        rs.close();
        s.close();
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIllegalCmrCollectionArgument() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            Set songs = artist.getComposed();
            try {
                songs.add(new Object());
                OneToManyTests.fail((String)"expected games.add(new Object()) to throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                songs.addAll(Arrays.asList(new Object()));
                OneToManyTests.fail((String)"expected games.addAll(Arrays.asList(new Object())) to throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyCmrCollectionOusideTx() throws Exception {
        Set songs;
        SongLocal newSong;
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            newSong = this.createSong(new Integer(33));
            songs = artist.getComposed();
        }
        finally {
            this.completeTransaction();
        }
        OneToManyTests.assertFalse((boolean)songs.isEmpty());
        OneToManyTests.assertEquals((long)2L, (long)songs.size());
        for (SongLocal song : songs) {
            if (song.getId().equals(new Integer(11))) {
                OneToManyTests.assertEquals((Object)"value11", (Object)song.getName());
                continue;
            }
            if (song.getId().equals(new Integer(22))) {
                OneToManyTests.assertEquals((Object)"value22", (Object)song.getName());
                continue;
            }
            OneToManyTests.fail();
        }
        try {
            songs.add(newSong);
            OneToManyTests.fail((String)"expected songs.add(newSong) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            songs.addAll(Arrays.asList(newSong));
            OneToManyTests.fail((String)"expected songs.addAll(Arrays.asList(newSong)) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            songs.remove(newSong);
            OneToManyTests.fail((String)"expected songs.remove(newSong) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            songs.removeAll(Arrays.asList(newSong));
            OneToManyTests.fail((String)"expected songs.removeAll(Arrays.asList(newSong)) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        Iterator iterator = songs.iterator();
        try {
            iterator.remove();
            OneToManyTests.fail((String)"expected iterator.remove() to throw an ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyCmrCollectionInNewTx() throws Exception {
        Set songs;
        SongLocal newSong;
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            newSong = this.createSong(new Integer(33));
            songs = artist.getComposed();
        }
        finally {
            this.completeTransaction();
        }
        this.beginTransaction();
        try {
            OneToManyTests.assertFalse((boolean)songs.isEmpty());
            OneToManyTests.assertEquals((long)2L, (long)songs.size());
            for (SongLocal song : songs) {
                if (song.getId().equals(new Integer(11))) {
                    OneToManyTests.assertEquals((Object)"value11", (Object)song.getName());
                    continue;
                }
                if (song.getId().equals(new Integer(22))) {
                    OneToManyTests.assertEquals((Object)"value22", (Object)song.getName());
                    continue;
                }
                OneToManyTests.fail();
            }
            try {
                songs.add(newSong);
                OneToManyTests.fail((String)"expected songs.add(newSong) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                songs.addAll(Arrays.asList(newSong));
                OneToManyTests.fail((String)"expected songs.addAll(Arrays.asList(newSong)) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                songs.remove(newSong);
                OneToManyTests.fail((String)"expected songs.remove(newSong) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                songs.removeAll(Arrays.asList(newSong));
                OneToManyTests.fail((String)"expected songs.removeAll(Arrays.asList(newSong)) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            Iterator iterator = songs.iterator();
            try {
                iterator.remove();
                OneToManyTests.fail((String)"expected iterator.remove() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorConcurrentModification() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            SongLocal song = this.findSong(new Integer(11));
            Set songs = artist.getComposed();
            OneToManyTests.assertFalse((boolean)songs.isEmpty());
            OneToManyTests.assertEquals((long)2L, (long)songs.size());
            Iterator iterator = songs.iterator();
            songs.remove(song);
            OneToManyTests.assertEquals((long)1L, (long)songs.size());
            try {
                iterator.next();
                OneToManyTests.fail((String)"expected iterator.next() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorAndRemove() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            SongLocal song = this.findSong(new Integer(11));
            Set games = artist.getComposed();
            OneToManyTests.assertFalse((boolean)games.isEmpty());
            OneToManyTests.assertEquals((long)2L, (long)games.size());
            Iterator iterator = games.iterator();
            OneToManyTests.assertTrue((boolean)games.contains(song));
            artist.remove();
            OneToManyTests.assertFalse((boolean)games.contains(song));
            OneToManyTests.assertEquals((long)0L, (long)games.size());
            try {
                iterator.next();
                OneToManyTests.fail((String)"expected iterator.next() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    private ArtistLocal createArtist(int songId) throws CreateException {
        ArtistLocal artist = this.artistLocalHome.create(Integer.valueOf(songId));
        artist.setName("value" + songId);
        return artist;
    }

    private ArtistLocal findArtist(int artistId) throws FinderException {
        return this.artistLocalHome.findByPrimaryKey(Integer.valueOf(artistId));
    }

    private SongLocal createSong(int songId) throws CreateException {
        SongLocal song = this.songLocalHome.create(Integer.valueOf(songId));
        song.setName("value" + songId);
        return song;
    }

    private SongLocal findSong(int songId) throws FinderException {
        return this.songLocalHome.findByPrimaryKey(Integer.valueOf(songId));
    }

    private void assertLinked(int artistId, int ... songIds) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT name FROM Artist WHERE id = " + artistId);
        OneToManyTests.assertTrue((boolean)rs.next());
        OneToManyTests.assertEquals((Object)("value" + artistId), (Object)rs.getString("name"));
        OneToManyTests.close(rs);
        rs = s.executeQuery("SELECT COUNT(*) FROM Song WHERE performer_id = 1");
        OneToManyTests.assertTrue((boolean)rs.next());
        OneToManyTests.assertEquals((long)songIds.length, (long)rs.getInt(1));
        rs.close();
        for (int songId : songIds) {
            rs = s.executeQuery("SELECT name, performer_id FROM Song WHERE id = " + songId);
            OneToManyTests.assertTrue((boolean)rs.next());
            OneToManyTests.assertEquals((Object)("value" + songId), (Object)rs.getString("name"));
            OneToManyTests.assertEquals((long)artistId, (long)rs.getInt("performer_id"));
            OneToManyTests.close(rs);
        }
        OneToManyTests.close(s);
        OneToManyTests.close(c);
    }

    private void assertUnlinked(int aPk) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM Song WHERE performer_id = " + aPk);
        OneToManyTests.assertTrue((boolean)rs.next());
        OneToManyTests.assertEquals((long)0L, (long)rs.getInt(1));
        OneToManyTests.close(rs);
        OneToManyTests.close(s);
        OneToManyTests.close(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetDB() throws Exception {
        Connection connection = this.ds.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            try {
                statement.execute("DELETE FROM Artist");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.execute("DELETE FROM Song");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            OneToManyTests.close(statement);
            OneToManyTests.close(connection);
        }
        ArtistLocal artist1 = this.createArtist(1);
        this.createArtist(2);
        SongLocal song1 = this.createSong(11);
        SongLocal song2 = this.createSong(22);
        song1.setPerformer(artist1);
        song2.setPerformer(artist1);
        song1.setComposer(artist1);
        song2.setComposer(artist1);
    }

    protected void dump() throws SQLException {
        OneToManyTests.dumpTable(this.ds, "Artist");
        OneToManyTests.dumpTable(this.ds, "Song");
    }
}

