/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.stateless.BasicStatelessBusinessRemote;
import org.apache.openejb.test.stateless.StatelessTestClient;

public class StatelessRemoteBusinessIntfcTests
extends StatelessTestClient {
    private BasicStatelessBusinessRemote businessRemote;

    public StatelessRemoteBusinessIntfcTests() {
        super("RemoteBusinessIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test00_lookupBusinessInterface() throws Exception {
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessPojoHomeBusinessRemote");
        StatelessRemoteBusinessIntfcTests.assertNotNull((Object)obj);
        StatelessRemoteBusinessIntfcTests.assertTrue((String)"instance of BasicStatelessBusinessRemote", (boolean)(obj instanceof BasicStatelessBusinessRemote));
        this.businessRemote = (BasicStatelessBusinessRemote)obj;
    }

    public void test01_businessMethod() {
        Object actual;
        Object expected;
        try {
            expected = "Success";
            actual = this.businessRemote.businessMethod("sseccuS");
            StatelessRemoteBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            StatelessRemoteBusinessIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        try {
            expected = new Integer(42);
            actual = this.businessRemote.echo(expected);
            StatelessRemoteBusinessIntfcTests.assertEquals((Object)expected, (Object)actual);
            StatelessRemoteBusinessIntfcTests.assertNotSame((String)"pass by value", (Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRemoteBusinessIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.businessRemote.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatelessRemoteBusinessIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        StatelessRemoteBusinessIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.businessRemote.businessMethod("sseccuS");
            StatelessRemoteBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            StatelessRemoteBusinessIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void _test04_throwSystemException() {
        try {
            this.businessRemote.throwSystemException_NullPointer();
        }
        catch (Exception e) {
            Throwable n = e.getCause();
            StatelessRemoteBusinessIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            StatelessRemoteBusinessIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatelessRemoteBusinessIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        StatelessRemoteBusinessIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
    }

    public void test06_testRemove() {
        Object obj = this.businessRemote.remove();
        StatelessRemoteBusinessIntfcTests.assertNotNull((Object)obj);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

