/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.stateful.PersistenceContextStatefulHome;
import org.apache.openejb.test.stateful.PersistenceContextStatefulObject;
import org.apache.openejb.test.stateful.StatefulTestClient;

public class StatefulPersistenceContextTests
extends StatefulTestClient {
    protected PersistenceContextStatefulObject ejbObject;
    protected PersistenceContextStatefulHome ejbHome;

    public StatefulPersistenceContextTests() {
        super("PERSISTENCE_CONTEXT.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ejbHome = (PersistenceContextStatefulHome)this.initialContext.lookup("client/tests/stateful/PersistenceContextStatefulBean");
        this.ejbObject = this.ejbHome.create();
        TestManager.getDatabase().createEntityTable();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            TestManager.getDatabase().dropEntityTable();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_persistenceContext() {
        try {
            this.ejbObject.testPersistenceContext();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulPersistenceContextTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_extendedPersistenceContext() {
        try {
            this.ejbObject.testExtendedPersistenceContext();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulPersistenceContextTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test03_propagatedPersistenceContext() {
        try {
            this.ejbObject.testPropagatedPersistenceContext();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulPersistenceContextTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_propogation() {
        try {
            this.ejbObject.testPropgation();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            StatefulPersistenceContextTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

