/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import jakarta.ejb.EJBMetaData;
import jakarta.ejb.ObjectNotFoundException;
import org.apache.openejb.test.entity.cmp.UnknownCmpHome;
import org.apache.openejb.test.entity.cmp.UnknownCmpTestClient;

public class UnknownEjbHomeTests
extends UnknownCmpTestClient {
    public UnknownEjbHomeTests() {
        super("EJBHome.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp/UnknownCmpHome");
        this.ejbHome = (UnknownCmpHome)obj;
        this.ejbObject = this.ejbHome.createObject("Second Bean");
        this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
    }

    public void test01_getEJBMetaData() {
        try {
            EJBMetaData ejbMetaData = this.ejbHome.getEJBMetaData();
            UnknownEjbHomeTests.assertNotNull((String)"The EJBMetaData is null", (Object)ejbMetaData);
        }
        catch (Exception e) {
            UnknownEjbHomeTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_getHomeHandle() {
        try {
            this.ejbHomeHandle = this.ejbHome.getHomeHandle();
            UnknownEjbHomeTests.assertNotNull((String)"The HomeHandle is null", (Object)this.ejbHomeHandle);
        }
        catch (Exception e) {
            UnknownEjbHomeTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test03_removeByPrimaryKey() {
        try {
            this.ejbHome.remove(this.ejbPrimaryKey);
            try {
                this.ejbHome.findByPrimaryKey(this.ejbPrimaryKey);
                UnknownEjbHomeTests.fail((String)"Entity was not actually removed");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                UnknownEjbHomeTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ejbObject = this.ejbHome.createObject("Second Bean");
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
        }
        catch (Exception e) {
            UnknownEjbHomeTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_removeByPrimaryHandle() {
        try {
            this.ejbHome.remove(this.ejbObject.getHandle());
            try {
                this.ejbHome.findByPrimaryKey(this.ejbPrimaryKey);
                UnknownEjbHomeTests.fail((String)"Entity was not actually removed");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                UnknownEjbHomeTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ejbObject = this.ejbHome.createObject("Second Bean");
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
        }
        catch (Exception e) {
            e.printStackTrace();
            UnknownEjbHomeTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test05_ejbHomeMethod() {
        try {
            UnknownEjbHomeTests.assertEquals((long)17L, (long)this.ejbHome.sum(8, 9));
        }
        catch (Throwable e) {
            e.printStackTrace();
            UnknownEjbHomeTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

