/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.openejb.test.TestDatabase;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.beans.Database;
import org.apache.openejb.test.beans.DatabaseHome;

public class PostgreSqlTestDatabase
implements TestDatabase {
    protected Database database;
    protected InitialContext initialContext;
    private static String _createAccount = "CREATE TABLE account ( ssn CHAR(11), first_name CHAR(20), last_name CHAR(20), balance INT, Constraint \"account_pkey\" Primary Key (\"ssn\"))";
    private static String _dropAccount = "DROP TABLE account";
    private static String _createEntity = "CREATE TABLE entity ( id INT DEFAULT nextval('entity_id_seq') , first_name CHAR(20), last_name CHAR(20), Constraint \"entity_pkey\" Primary Key (\"id\") )";
    private static String _dropEntity = "DROP TABLE entity";

    @Override
    public void createEntityTable() throws SQLException {
        try {
            this.database.execute("DROP SEQUENCE entity_id_seq");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.database.execute(_dropEntity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.database.execute("CREATE SEQUENCE entity_id_seq");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.database.execute(_createEntity);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot create entity table: " + re.getMessage(), _createEntity);
        }
    }

    @Override
    public void dropEntityTable() throws SQLException {
        try {
            this.database.execute("DROP SEQUENCE entity_id_seq");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.database.execute(_dropEntity);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Unable to drop entity table: " + re.getMessage(), _dropEntity);
        }
    }

    @Override
    public void createAccountTable() throws SQLException {
        try {
            this.database.execute("DROP SEQUENCE account_id_seq");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.database.execute("DROP TABLE account");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.database.execute("CREATE SEQUENCE account_id_seq");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.database.execute(_createAccount);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot create account table: " + re.getMessage(), _createAccount);
        }
    }

    @Override
    public void dropAccountTable() throws SQLException {
        try {
            try {
                this.database.execute("DROP SEQUENCE account_id_seq");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.database.execute(_dropAccount);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot drop account table: " + re.getMessage(), _dropAccount);
        }
    }

    @Override
    public void start() throws IllegalStateException {
        try {
            Properties properties = TestManager.getServer().getContextEnvironment();
            this.initialContext = new InitialContext(properties);
            Object obj = this.initialContext.lookup("client/tools/DatabaseHome");
            DatabaseHome databaseHome = (DatabaseHome)obj;
            this.database = databaseHome.create();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot start database: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    @Override
    public void stop() throws IllegalStateException {
    }

    @Override
    public void init(Properties props) throws IllegalStateException {
    }

    public static void main(String[] args) {
        PreparedStatement pstmt;
        System.out.println("Checking if driver is registered with DriverManager.");
        try {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            Class.forName("org.postgresql.Driver", true, cl);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Couldn't find the driver!");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Registered the driver, so let's make a connection.");
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:postgresql://localhost/openejbtest", "openejbuser", "javaone");
        }
        catch (SQLException e) {
            System.out.println("Couldn't connect.");
            e.printStackTrace();
            System.exit(1);
        }
        if (conn == null) {
            System.out.println("No connection!");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
        }
        catch (SQLException e) {
            System.out.println("Couldn't create a statement.");
            e.printStackTrace();
            System.exit(1);
        }
        Object rs = null;
        try {
            stmt.execute("DROP TABLE entity");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.out.println("Creating entity table.");
        try {
            stmt.execute(_createEntity);
        }
        catch (SQLException e) {
            System.out.println("Couldn't create the entity table");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Inserting record.");
        try {
            pstmt = conn.prepareStatement("insert into entity (id, first_name, last_name) values (?,?,?)");
            pstmt.setInt(1, 101);
            pstmt.setString(2, "Bunson");
            pstmt.setString(3, "Honeydew");
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("Couldn't create the entity table");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Selecting the record.");
        try {
            pstmt = conn.prepareStatement("select id from entity where first_name = ? AND last_name = ?");
            pstmt.setString(1, "Bunson");
            pstmt.setString(2, "Honeydew");
            ResultSet resultSet = pstmt.executeQuery();
        }
        catch (SQLException e) {
            System.out.println("Couldn't select the entry");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Dropping the entity table.");
        try {
            stmt.execute(_dropEntity);
        }
        catch (SQLException e) {
            System.out.println("Couldn't drop the entity table");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            System.out.println("Couldn't create the sequense");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

