/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.TimedObject;
import jakarta.ejb.Timer;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.beans.TimerSync;
import org.apache.openejb.test.object.OperationsPolicy;

public class BasicSingletonBean
implements SessionBean,
TimedObject {
    private String name;
    private SessionContext ejbContext;
    private static Hashtable allowedOperationsTable = new Hashtable();

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void scheduleTimer(String name) {
        this.ejbContext.getTimerService().createTimer(1L, (Serializable)((Object)name));
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Testing ability to throw Application Exceptions");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Testing ability to throw System Exceptions");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return (OperationsPolicy)allowedOperationsTable.get(methodName);
    }

    public String remove(String str) {
        return str;
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
        this.testAllowedOperations("setSessionContext");
    }

    public void ejbCreateObject() throws CreateException {
        this.testAllowedOperations("ejbCreate");
        this.name = "nameless automaton";
    }

    public void ejbRemove() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbRemove");
    }

    public void ejbActivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbPassivate");
    }

    public void ejbTimeout(Timer timer) {
        this.testAllowedOperations("ejbTimeout");
        try {
            String name = (String)((Object)timer.getInfo());
            TimerSync timerSync = (TimerSync)this.ejbContext.lookup("TimerSyncBeanBusinessRemote");
            timerSync.countDown(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void testAllowedOperations(String methodName) {
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("TheMan");
            policy.allow(2);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.setRollbackOnly();
            policy.allow(4);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            InitialContext jndiContext = new InitialContext();
            String actual = (String)jndiContext.lookup("java:comp/env/singleton/references/JNDI_access_to_java_comp_env");
            policy.allow(8);
        }
        catch (IllegalStateException | NamingException exception) {
            // empty catch block
        }
        try {
            this.ejbContext.lookup("singleton/references/JNDI_access_to_java_comp_env");
            policy.allow(11);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ejbContext.getTimerService();
            policy.allow(12);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        allowedOperationsTable.put(methodName, policy);
    }
}

