/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.ActivationConfigProperty;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptors;
import jakarta.interceptor.InvocationContext;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Session;
import junit.framework.AssertionFailedError;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.mdb.MdbInterceptor;
import org.apache.openejb.test.mdb.MdbInvoker;
import org.junit.Assert;

@Interceptors(value={MdbInterceptor.class})
@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="jakarta.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="InterceptorMdbBean")})
public class InterceptorMdbBean
implements MessageListener,
MessageDrivenBean {
    private boolean classLevelBusinessMethodInterception = false;
    private boolean methodLevelBusinessMethodInterception = false;
    protected static boolean classLevelCreateMethodInterception = false;
    private boolean methodLevelCreateMethodInterception = false;
    private MessageDrivenContext mdbContext;
    private Session session;
    private Connection connection;
    protected MdbInvoker mdbInvoker;
    @Resource(name="jms", type=QueueConnectionFactory.class)
    private ConnectionFactory connectionFactory;

    public void onMessage(Message msg) {
        try {
            this.classLevelBusinessMethodInterception = msg.getBooleanProperty("ClassLevelBusinessMethodInterception");
            this.methodLevelBusinessMethodInterception = msg.getBooleanProperty("MethodLevelBusinessMethodInterception");
            try {
                msg.acknowledge();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            this.mdbInvoker.onMessage(msg);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        Object[] objArr = ctx.getParameters();
        Message msg = (Message)objArr[0];
        msg.setBooleanProperty("MethodLevelBusinessMethodInterception", true);
        ctx.setParameters(objArr);
        return ctx.proceed();
    }

    @PostConstruct
    public void ejbCreate() throws EJBException {
        this.methodLevelCreateMethodInterception = true;
    }

    public void checkMethodLevelBusinessMethodInterception() throws TestFailureException {
        try {
            Assert.assertTrue((String)"Method Level Business Method Interception failed for Mdb", (boolean)this.methodLevelBusinessMethodInterception);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void checkMethodLevelCreateMethodInterception() throws TestFailureException {
        try {
            Assert.assertTrue((String)"Method Level Business Method Interception failed for Mdb", (boolean)this.methodLevelCreateMethodInterception);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void checkClassLevelBusinessMethodInterception() throws TestFailureException {
        try {
            Assert.assertTrue((String)"Class Level Business Method Interception failed for Mdb", (boolean)this.classLevelBusinessMethodInterception);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void checkClassLevelCreateMethodInterception() throws TestFailureException {
        try {
            Assert.assertTrue((String)"Class Level Business Method Interception failed for Mdb", (boolean)classLevelCreateMethodInterception);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void ejbRemove() throws EJBException {
        if (null != this.mdbInvoker) {
            this.mdbInvoker.destroy();
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
        this.mdbContext = ctx;
        try {
            this.mdbInvoker = new MdbInvoker(this.connectionFactory, this);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }
}

