/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.ActivationConfigProperty;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceUnit;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.entity.bmp.BasicBmpHome;
import org.apache.openejb.test.mdb.MdbInvoker;
import org.apache.openejb.test.stateful.BasicStatefulBusinessLocal;
import org.apache.openejb.test.stateful.BasicStatefulBusinessRemote;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateless.BasicStatelessBusinessLocal;
import org.apache.openejb.test.stateless.BasicStatelessBusinessRemote;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.junit.Assert;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="jakarta.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="AnnotatedFieldInjectionMdb")})
public class AnnotatedFieldInjectionMdbBean
implements MessageListener {
    @Resource
    private MessageDrivenContext mdbContext;
    @EJB(beanName="BasicBmpBean")
    private BasicBmpHome bmpHome;
    @EJB(beanName="BasicStatefulBean")
    private BasicStatefulHome statefulHome;
    @EJB(beanName="BasicStatelessBean")
    private BasicStatelessHome statelessHome;
    @Resource
    private String striing = "1";
    @Resource
    private Double doouble = 1.0;
    @Resource
    private Long loong = 1L;
    @Resource
    private Float flooat = Float.valueOf(1.0f);
    @Resource
    private Integer inteeger = 1;
    @Resource
    private Short shoort = 1;
    @Resource
    private Boolean booolean = true;
    @Resource
    private Byte byyte = 1;
    @Resource
    private Character chaaracter = Character.valueOf('D');
    @Resource
    private DataSource daataSource;
    @Resource
    private ConnectionFactory coonnectionFactory;
    @Resource
    private QueueConnectionFactory queueCoonnectionFactory;
    @Resource
    private TopicConnectionFactory topicCoonnectionFactory;
    @PersistenceUnit(unitName="openjpa-test-unit")
    private EntityManagerFactory emf;
    @PersistenceContext(unitName="openjpa-test-unit")
    private EntityManager em;
    @EJB
    private BasicStatelessBusinessLocal statelessBusinessLocal;
    @EJB
    private BasicStatelessBusinessRemote statelessBusinessRemote;
    @EJB
    private BasicStatefulBusinessLocal statefulBusinessLocal;
    @EJB
    private BasicStatefulBusinessRemote statefulBusinessRemote;
    private MdbInvoker mdbInvoker;

    @PostConstruct
    public void start() {
        try {
            this.mdbInvoker = new MdbInvoker(this.coonnectionFactory, this);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    @PreDestroy
    public void preDestroy() {
        if (null != this.mdbInvoker) {
            try {
                this.mdbInvoker.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void onMessage(Message message) {
        try {
            try {
                message.acknowledge();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            this.mdbInvoker.onMessage(message);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void lookupEntityBean() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EJBObject is null", (Object)this.bmpHome);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBean() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EJBObject is null", (Object)this.statefulHome);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBean() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EJBObject is null", (Object)this.statelessHome);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBusinessLocal() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)this.statelessBusinessLocal);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBusinessRemote() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)this.statelessBusinessRemote);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessLocal() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)this.statefulBusinessLocal);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessRemote() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)this.statefulBusinessRemote);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStringEntry() throws TestFailureException {
        try {
            String expected = "1";
            Assert.assertNotNull((String)"The String looked up is null", (Object)this.striing);
            Assert.assertEquals((Object)"1", (Object)this.striing);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupDoubleEntry() throws TestFailureException {
        try {
            Double expected = 1.0;
            Assert.assertNotNull((String)"The Double looked up is null", (Object)this.doouble);
            Assert.assertEquals((Object)expected, (Object)this.doouble);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupLongEntry() throws TestFailureException {
        try {
            Long expected = 1L;
            Assert.assertNotNull((String)"The Long looked up is null", (Object)this.loong);
            Assert.assertEquals((Object)expected, (Object)this.loong);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupFloatEntry() throws TestFailureException {
        try {
            Float expected = Float.valueOf(1.0f);
            Assert.assertNotNull((String)"The Float looked up is null", (Object)this.flooat);
            Assert.assertEquals((Object)expected, (Object)this.flooat);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupIntegerEntry() throws TestFailureException {
        try {
            Integer expected = 1;
            Assert.assertNotNull((String)"The Integer looked up is null", (Object)this.inteeger);
            Assert.assertEquals((Object)expected, (Object)this.inteeger);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupShortEntry() throws TestFailureException {
        try {
            Short expected = 1;
            Assert.assertNotNull((String)"The Short looked up is null", (Object)this.shoort);
            Assert.assertEquals((Object)expected, (Object)this.shoort);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupBooleanEntry() throws TestFailureException {
        try {
            Boolean expected = true;
            Assert.assertNotNull((String)"The Boolean looked up is null", (Object)this.booolean);
            Assert.assertEquals((Object)expected, (Object)this.booolean);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupByteEntry() throws TestFailureException {
        try {
            Byte expected = 1;
            Assert.assertNotNull((String)"The Byte looked up is null", (Object)this.byyte);
            Assert.assertEquals((Object)expected, (Object)this.byyte);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupCharacterEntry() throws TestFailureException {
        try {
            Character expected = Character.valueOf('D');
            Assert.assertNotNull((String)"The Character looked up is null", (Object)this.chaaracter);
            Assert.assertEquals((Object)expected, (Object)this.chaaracter);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupResource() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The DataSource is null", (Object)this.daataSource);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupJMSConnectionFactory() throws TestFailureException {
        try {
            try {
                this.testJmsConnection(this.coonnectionFactory.createConnection());
                this.testJmsConnection(this.queueCoonnectionFactory.createConnection());
                this.testJmsConnection(this.topicCoonnectionFactory.createConnection());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    private void testJmsConnection(Connection connection) throws JMSException {
        Session session = connection.createSession(false, 3);
        Topic topic = session.createTopic("test");
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.send(session.createMessage());
        producer.close();
        session.close();
        connection.close();
    }

    public void lookupPersistenceUnit() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EntityManagerFactory is null", (Object)this.emf);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupPersistenceContext() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The EntityManager is null", (Object)this.em);
            try {
                this.em.getFlushMode();
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupMessageDrivenContext() throws TestFailureException {
        try {
            Assert.assertNotNull((String)"The MessageDrivenContext is null", (Object)this.mdbContext);
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }
}

