/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import jakarta.ejb.CreateException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.object.OperationsPolicy;

public abstract class AllowedOperationsCmp2Bean
implements EntityBean {
    private static int nextId;
    public EntityContext ejbContext;
    public static final Map<String, OperationsPolicy> allowedOperationsTable;

    public abstract Integer getId();

    public abstract void setId(Integer var1);

    public abstract String getFirstName();

    public abstract void setFirstName(String var1);

    public abstract String getLastName();

    public abstract void setLastName(String var1);

    public abstract int getNumber();

    public abstract void setNumber(int var1);

    public int ejbHomeSum(int x, int y) {
        this.testAllowedOperations("ejbHome");
        return x + y;
    }

    public void ejbHomeVoidSelect() {
    }

    public Integer ejbCreateObject(String name) throws CreateException {
        this.setId(nextId++);
        this.testAllowedOperations("ejbCreate");
        StringTokenizer st = new StringTokenizer(name, " ");
        this.setFirstName(st.nextToken());
        this.setLastName(st.nextToken());
        return null;
    }

    public void ejbPostCreateObject(String name) {
        this.testAllowedOperations("ejbPostCreate");
    }

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        this.setNumber(this.getNumber() + 1);
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Don't Panic");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Panic");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return allowedOperationsTable.get(methodName);
    }

    public void ejbLoad() {
        this.testAllowedOperations("ejbLoad");
    }

    public void setEntityContext(EntityContext ctx) {
        this.ejbContext = ctx;
        this.testAllowedOperations("setEntityContext");
    }

    public void unsetEntityContext() {
        this.testAllowedOperations("unsetEntityContext");
    }

    public void ejbStore() {
        this.testAllowedOperations("ejbStore");
    }

    public void ejbRemove() {
        this.testAllowedOperations("ejbRemove");
    }

    public void ejbActivate() {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("TheMan");
            policy.allow(2);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getPrimaryKey();
            policy.allow(7);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            InitialContext jndiContext = new InitialContext();
            jndiContext.lookup("java:comp/env/stateless/references/JNDI_access_to_java_comp_env");
            policy.allow(8);
        }
        catch (IllegalStateException | NamingException exception) {
            // empty catch block
        }
        allowedOperationsTable.put(methodName, policy);
    }

    static {
        allowedOperationsTable = new TreeMap<String, OperationsPolicy>();
    }
}

