/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import jakarta.ejb.EJBContext;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionContext;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.entity.bmp.BasicBmpHome;
import org.apache.openejb.test.entity.bmp.BasicBmpObject;
import org.apache.openejb.test.singleton.BasicSingletonBusinessLocal;
import org.apache.openejb.test.singleton.BasicSingletonBusinessRemote;
import org.apache.openejb.test.singleton.BasicSingletonHome;
import org.apache.openejb.test.singleton.BasicSingletonObject;
import org.apache.openejb.test.singleton.BasicSingletonPojoBean;
import org.apache.openejb.test.stateful.BasicStatefulBusinessLocal;
import org.apache.openejb.test.stateful.BasicStatefulBusinessRemote;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulObject;
import org.apache.openejb.test.stateful.BasicStatefulPojoBean;
import org.junit.Assert;

public class ContextLookupSingletonPojoBean {
    public void lookupEntityBean() throws TestFailureException {
        try {
            try {
                BasicBmpHome home = (BasicBmpHome)this.getSessionContext().lookup("singleton/beanReferences/bmp_entity");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicBmpObject object = home.createObject("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBean() throws TestFailureException {
        try {
            try {
                BasicStatefulHome home = (BasicStatefulHome)this.getSessionContext().lookup("singleton/beanReferences/stateful");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatefulObject object = home.createObject("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupSingletonBean() throws TestFailureException {
        try {
            try {
                BasicSingletonHome home = (BasicSingletonHome)this.getSessionContext().lookup("singleton/beanReferences/singleton");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicSingletonObject object = home.createObject();
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupSingletonBusinessLocal() throws TestFailureException {
        try {
            try {
                BasicSingletonBusinessLocal object = (BasicSingletonBusinessLocal)this.getSessionContext().lookup("singleton/beanReferences/singleton-business-local");
                Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupSingletonBusinessLocalBean() throws TestFailureException {
        try {
            try {
                BasicSingletonPojoBean object = (BasicSingletonPojoBean)this.getSessionContext().lookup("singleton/beanReferences/singleton-business-localbean");
                Assert.assertNotNull((String)"The EJB BusinessLocalBean is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupSingletonBusinessRemote() throws TestFailureException {
        try {
            try {
                BasicSingletonBusinessRemote object = (BasicSingletonBusinessRemote)this.getSessionContext().lookup("singleton/beanReferences/singleton-business-remote");
                Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessLocal() throws TestFailureException {
        try {
            try {
                BasicStatefulBusinessLocal object = (BasicStatefulBusinessLocal)this.getSessionContext().lookup("singleton/beanReferences/stateful-business-local");
                Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessLocalBean() throws TestFailureException {
        try {
            try {
                BasicStatefulPojoBean object = (BasicStatefulPojoBean)this.getSessionContext().lookup("singleton/beanReferences/stateful-business-localbean");
                Assert.assertNotNull((String)"The EJB BusinessLocalBean is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessRemote() throws TestFailureException {
        try {
            try {
                BasicStatefulBusinessRemote object = (BasicStatefulBusinessRemote)this.getSessionContext().lookup("singleton/beanReferences/stateful-business-remote");
                Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStringEntry() throws TestFailureException {
        try {
            try {
                String expected = new String("1");
                String actual = (String)this.getSessionContext().lookup("singleton/references/String");
                Assert.assertNotNull((String)"The String looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupDoubleEntry() throws TestFailureException {
        try {
            try {
                Double expected = new Double(1.0);
                Double actual = (Double)this.getSessionContext().lookup("singleton/references/Double");
                Assert.assertNotNull((String)"The Double looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupLongEntry() throws TestFailureException {
        try {
            try {
                Long expected = new Long(1L);
                Long actual = (Long)this.getSessionContext().lookup("singleton/references/Long");
                Assert.assertNotNull((String)"The Long looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupFloatEntry() throws TestFailureException {
        try {
            try {
                Float expected = new Float(1.0f);
                Float actual = (Float)this.getSessionContext().lookup("singleton/references/Float");
                Assert.assertNotNull((String)"The Float looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupIntegerEntry() throws TestFailureException {
        try {
            try {
                Integer expected = new Integer(1);
                Integer actual = (Integer)this.getSessionContext().lookup("singleton/references/Integer");
                Assert.assertNotNull((String)"The Integer looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupShortEntry() throws TestFailureException {
        try {
            try {
                Short expected = new Short(1);
                Short actual = (Short)this.getSessionContext().lookup("singleton/references/Short");
                Assert.assertNotNull((String)"The Short looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupBooleanEntry() throws TestFailureException {
        try {
            try {
                Boolean expected = Boolean.TRUE;
                Boolean actual = (Boolean)this.getSessionContext().lookup("singleton/references/Boolean");
                Assert.assertNotNull((String)"The Boolean looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupByteEntry() throws TestFailureException {
        try {
            try {
                Byte expected = new Byte(1);
                Byte actual = (Byte)this.getSessionContext().lookup("singleton/references/Byte");
                Assert.assertNotNull((String)"The Byte looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupCharacterEntry() throws TestFailureException {
        try {
            try {
                Character expected = new Character('D');
                Character actual = (Character)this.getSessionContext().lookup("singleton/references/Character");
                Assert.assertNotNull((String)"The Character looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupResource() throws TestFailureException {
        try {
            try {
                Object obj = this.getSessionContext().lookup("datasource");
                Assert.assertNotNull((String)"The DataSource is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of DataSource", (boolean)(obj instanceof DataSource));
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupPersistenceUnit() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                EntityManagerFactory emf = (EntityManagerFactory)ctx.lookup("java:comp/env/persistence/TestUnit");
                Assert.assertNotNull((String)"The EntityManagerFactory is null", (Object)emf);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupSessionContext() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                SessionContext sctx = (SessionContext)ctx.lookup("java:comp/env/sessioncontext");
                Assert.assertNotNull((String)"The SessionContext got from java:comp/env/sessioncontext is null", (Object)sctx);
                EJBContext ejbCtx = (EJBContext)ctx.lookup("java:comp/EJBContext");
                Assert.assertNotNull((String)"The SessionContext got from java:comp/EJBContext is null ", (Object)ejbCtx);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupPersistenceContext() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                EntityManager em = (EntityManager)ctx.lookup("java:comp/env/persistence/TestContext");
                Assert.assertNotNull((String)"The EntityManager is null", (Object)em);
                em.getFlushMode();
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public SessionContext getSessionContext() throws EJBException, RemoteException {
        SessionContext ejbContext = null;
        try {
            ejbContext = (SessionContext)new InitialContext().lookup("java:comp/EJBContext");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return ejbContext;
    }
}

