/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.beans;

import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class DatabaseBean
implements SessionBean {
    private static final long serialVersionUID = 1L;
    public SessionContext context;
    public InitialContext jndiContext;

    public DatabaseBean() {
        this.getClass();
    }

    public void ejbCreate() throws CreateException {
        try {
            this.jndiContext = new InitialContext();
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String statement) throws SQLException {
        try {
            DataSource ds = (DataSource)this.jndiContext.lookup("java:comp/env/database");
            try (Connection con = ds.getConnection();
                 PreparedStatement stmt = con.prepareStatement(statement);){
                stmt.executeQuery();
            }
        }
        catch (Exception e) {
            throw new EJBException("Cannot execute the statement: " + statement + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String statement) throws SQLException {
        boolean retval;
        try (Connection con = null;){
            DataSource ds = (DataSource)this.jndiContext.lookup("java:comp/env/database");
            con = ds.getConnection();
            try (Statement stmt = con.createStatement();){
                retval = stmt.execute(statement);
            }
        }
        return retval;
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext cntx) {
        this.context = cntx;
    }
}

