/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.openejb.test.mdb.MdbUtil;

public class MdbProxy {
    public static <T> T newProxyInstance(Class<T> type, ConnectionFactory connectionFactory, String requestQueueName) throws JMSException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = type.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        MdbInvocationHandler invocationHandler = new MdbInvocationHandler(connectionFactory, requestQueueName);
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{type}, (InvocationHandler)invocationHandler);
        return (T)proxy;
    }

    public static <T> T newProxyInstance(Class<T> type, ConnectionFactory connectionFactory, Destination requestQueue) throws JMSException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = type.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        MdbInvocationHandler invocationHandler = new MdbInvocationHandler(connectionFactory, requestQueue);
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{type}, (InvocationHandler)invocationHandler);
        return (T)proxy;
    }

    public static void destroyProxy(Object proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (MdbProxy.class.isInstance(handler)) {
            MdbInvocationHandler mdbInvocationHandler = (MdbInvocationHandler)handler;
            mdbInvocationHandler.destroy();
        }
    }

    private MdbProxy() {
    }

    private static class MdbInvocationHandler
    implements InvocationHandler {
        private static final int MAX_RESPONSE_WAIT = Integer.parseInt(System.getProperty("max.response.wait", "45000"));
        private Connection connection;
        private Session session;
        private MessageProducer producer;
        private final Destination requestQueue;

        public MdbInvocationHandler(ConnectionFactory connectionFactory, String requestQueueName) throws JMSException {
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.requestQueue = this.session.createQueue(requestQueueName);
            this.producer = this.session.createProducer(this.requestQueue);
            this.producer.setDeliveryMode(1);
        }

        public MdbInvocationHandler(ConnectionFactory connectionFactory, Destination requestQueue) throws JMSException {
            this.requestQueue = requestQueue;
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer(requestQueue);
            this.producer.setDeliveryMode(1);
        }

        public synchronized void destroy() {
            MdbUtil.close(this.producer);
            this.producer = null;
            MdbUtil.close(this.session);
            this.session = null;
            MdbUtil.close(this.connection);
            this.connection = null;
        }

        private synchronized Session getSession() {
            return this.session;
        }

        public synchronized MessageProducer getProducer() {
            return this.producer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Session tempSession = this.connection.createSession(false, 1);
            if (tempSession == null) {
                throw new IllegalStateException("Proxy has been destroyed");
            }
            TreeMap<String, Object> request = new TreeMap<String, Object>();
            String signature = MdbUtil.getSignature(method);
            request.put("method", signature);
            request.put("args", args);
            String correlationId = UUID.randomUUID().toString();
            Queue responseQueue = tempSession.createQueue(correlationId);
            MessageConsumer consumer = null;
            try {
                consumer = tempSession.createConsumer((Destination)responseQueue);
                ObjectMessage requestMessage = tempSession.createObjectMessage();
                requestMessage.setJMSReplyTo((Destination)responseQueue);
                requestMessage.setJMSCorrelationID(correlationId);
                requestMessage.setObject((Serializable)request);
                this.getProducer().send((Message)requestMessage);
                Message message = consumer.receive((long)MAX_RESPONSE_WAIT);
                if (message == null) {
                    throw new NullPointerException("Did not get a response within " + MAX_RESPONSE_WAIT + "ms");
                }
                if (!correlationId.equals(message.getJMSCorrelationID())) {
                    throw new IllegalStateException("Received a response message with the wrong correlation id");
                }
                if (!(message instanceof ObjectMessage)) {
                    throw new IllegalArgumentException("Expected a ObjectMessage response but got a " + message.getClass().getName());
                }
                ObjectMessage resMessage = (ObjectMessage)message;
                Serializable object = resMessage.getObject();
                if (object == null) {
                    throw new NullPointerException("object in ObjectMessage is null");
                }
                if (!(object instanceof Map) && ObjectMessage.class.isInstance(message)) {
                    throw new IllegalArgumentException("Expected a Map contained in the ObjectMessage response but got a " + object.getClass().getName());
                }
                Map response = (Map)((Object)object);
                boolean exception = response.containsKey("exception");
                Object returnValue = response.get("return");
                if (exception) {
                    throw (Throwable)returnValue;
                }
                Object v = returnValue;
                return v;
            }
            finally {
                MdbUtil.close(consumer);
                MdbUtil.close(tempSession);
            }
        }
    }
}

