/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.interceptor;

import jakarta.interceptor.InvocationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.test.SuperInterceptedBean;

public class Interceptor {
    public static Map<String, Object> profile(InvocationContext ctx, String interceptorName) {
        Map ctxData = ctx.getContextData();
        String KEY = ctx.getMethod() != null ? ctx.getMethod().getName() : ctx.getTarget().getClass().getSimpleName();
        Map<Object, Object> innerMap = (HashMap)ctxData.get(KEY);
        innerMap = Interceptor.updateInterceptorsList((Map<String, Object>)innerMap, interceptorName);
        if (ctx.getMethod() != null) {
            Object[] params = ctx.getParameters();
            innerMap.put("PARAMETERS", params);
        }
        ctxData.put(KEY, innerMap);
        return ctxData;
    }

    public static Map<String, Object> profile(SuperInterceptedBean bean, String interceptorName) {
        HashMap<String, Object> ctxData = new HashMap<String, Object>();
        String KEY = bean.getClass().getSimpleName();
        Map<Object, Object> innerMap = (HashMap)ctxData.get(KEY);
        innerMap = Interceptor.updateInterceptorsList(innerMap, interceptorName);
        ctxData.put(KEY, innerMap);
        return ctxData;
    }

    private static Map<String, Object> updateInterceptorsList(Map<String, Object> innerMap, String interceptorName) {
        ArrayList<String> interceptorsList;
        if (innerMap == null) {
            innerMap = new HashMap<String, Object>();
        }
        if ((interceptorsList = (ArrayList<String>)innerMap.get("INTERCEPTORS")) == null) {
            interceptorsList = new ArrayList<String>();
        }
        interceptorsList.add(interceptorName);
        innerMap.put("INTERCEPTORS", interceptorsList);
        return innerMap;
    }
}

