/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import java.io.File;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.cli.command.AbstractCommand;

public abstract class PathCommand
extends AbstractCommand {
    public static final String HOME = "$home";
    public static final String BASE = "$base";

    protected File resolve(String cmd) {
        if (cmd == null || cmd.trim().isEmpty()) {
            return SystemInstance.get().getBase().getDirectory();
        }
        String path = cmd.trim();
        File workingFile = new File(path);
        if (!path.startsWith(HOME) && !path.startsWith(BASE) && workingFile.getPath().equals(workingFile.getAbsolutePath()) || path.startsWith("..")) {
            throw new IllegalArgumentException("path should start with $base or $home or be relative");
        }
        if (path.startsWith(HOME)) {
            return new File(path.replace(HOME, SystemInstance.get().getHome().getDirectory().getAbsolutePath()));
        }
        if (path.startsWith(BASE)) {
            return new File(path.replace(BASE, SystemInstance.get().getBase().getDirectory().getAbsolutePath()));
        }
        return new File(SystemInstance.get().getBase().getDirectory().getAbsolutePath(), path);
    }
}

