/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.openejb.client.ClusterableRequest;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.JNDIContext;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.RequestType;
import org.apache.openejb.client.corba.Corbas;
import org.apache.openejb.client.corba.InstanceOf;
import org.apache.openejb.client.serializer.EJBDSerializer;
import org.apache.openejb.client.serializer.SerializationWrapper;

public class EJBRequest
implements ClusterableRequest {
    private static final long serialVersionUID = -2075915633178128028L;
    private transient RequestMethodCode requestMethod;
    private transient int deploymentCode = 0;
    private transient Object clientIdentity;
    private transient String deploymentId;
    private transient int serverHash;
    private transient Body body;
    private transient EJBDSerializer serializer;
    private transient ProtocolMetaData metaData;
    private final transient EJBMetaDataImpl ejbMetaData;
    public static final int SESSION_BEAN_STATELESS = 6;
    public static final int SESSION_BEAN_STATEFUL = 7;
    public static final int ENTITY_BM_PERSISTENCE = 8;
    public static final int ENTITY_CM_PERSISTENCE = 9;

    public EJBRequest() {
        this.body = new Body(null);
        this.ejbMetaData = null;
    }

    public EJBRequest(RequestMethodCode requestMethod, EJBMetaDataImpl ejb, Method method, Object[] args, Object primaryKey, EJBDSerializer serializer) {
        this.body = new Body(ejb);
        this.serializer = serializer;
        this.ejbMetaData = ejb;
        this.requestMethod = requestMethod;
        this.setDeploymentCode(ejb.deploymentCode);
        this.setDeploymentId(ejb.deploymentID);
        this.setMethodInstance(method);
        this.setMethodParameters(args);
        this.setPrimaryKey(primaryKey);
    }

    @Override
    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
        this.body.setMetaData(this.metaData);
    }

    public EJBMetaDataImpl getEjbMetaData() {
        return this.ejbMetaData;
    }

    public Class getInterfaceClass() {
        return this.body.getInterfaceClass();
    }

    public Method getMethodInstance() {
        return this.body.getMethodInstance();
    }

    public String getMethodName() {
        return this.body.getMethodName();
    }

    public Object[] getMethodParameters() {
        Object[] params = this.body.getMethodParameters();
        if (params == null || this.serializer == null) {
            return params;
        }
        Object[] unserialized = new Object[params.length];
        int i = 0;
        for (Object o : params) {
            if (SerializationWrapper.class.isInstance(o)) {
                SerializationWrapper wrapper = (SerializationWrapper)SerializationWrapper.class.cast(o);
                try {
                    unserialized[i] = this.serializer.deserialize(wrapper.getData(), this.body.getMethodInstance().getDeclaringClass().getClassLoader().loadClass(wrapper.getClassname()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else {
                unserialized[i] = o;
            }
            ++i;
        }
        return unserialized;
    }

    public Class[] getMethodParamTypes() {
        return this.body.getMethodParamTypes();
    }

    public Object getPrimaryKey() {
        return this.body.getPrimaryKey();
    }

    public void setMethodInstance(Method methodInstance) {
        this.body.setMethodInstance(methodInstance);
    }

    public void setMethodParameters(Object[] methodParameters) {
        if (this.serializer == null || methodParameters == null) {
            this.body.setMethodParameters(methodParameters);
        } else {
            Object[] params = new Object[methodParameters.length];
            int i = 0;
            for (Object o : methodParameters) {
                params[i] = o == null ? null : new SerializationWrapper(this.serializer.serialize(o), o.getClass().getName());
                ++i;
            }
            this.body.setMethodParameters(params);
        }
    }

    public void setPrimaryKey(Object primaryKey) {
        this.body.setPrimaryKey(primaryKey);
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public byte getVersion() {
        return this.body.getVersion();
    }

    public void setSerializer(EJBDSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.EJB_REQUEST;
    }

    public RequestMethodCode getRequestMethod() {
        return this.requestMethod;
    }

    public Object getClientIdentity() {
        return this.clientIdentity;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public int getDeploymentCode() {
        return this.deploymentCode;
    }

    public void setRequestMethod(RequestMethodCode requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setClientIdentity(Object clientIdentity) {
        this.clientIdentity = clientIdentity;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setDeploymentCode(int deploymentCode) {
        this.deploymentCode = deploymentCode;
    }

    @Override
    public void setServerHash(int serverHash) {
        this.serverHash = serverHash;
    }

    @Override
    public int getServerHash() {
        return this.serverHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EJBRequest{");
        sb.append("deploymentId='");
        sb.append(this.deploymentId);
        sb.append("'");
        if (this.requestMethod != null) {
            sb.append(", type=").append((Object)this.requestMethod);
        }
        if (this.body != null) {
            sb.append(", ").append(this.body.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ClassNotFoundException ex;
        block7: {
            ex = null;
            this.deploymentId = null;
            this.deploymentCode = -1;
            this.clientIdentity = null;
            byte code = in.readByte();
            try {
                this.requestMethod = RequestMethodCode.valueOf(code);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid request code " + code);
            }
            try {
                this.deploymentId = (String)in.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                ex = cnfe;
            }
            this.deploymentCode = in.readShort();
            try {
                this.clientIdentity = in.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                if (ex != null) break block7;
                ex = cnfe;
            }
        }
        this.serverHash = in.readInt();
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.requestMethod.getCode());
        if (this.deploymentCode > 0) {
            out.writeObject(null);
        } else {
            out.writeObject(this.deploymentId);
        }
        out.writeShort(this.deploymentCode);
        out.writeObject(this.clientIdentity);
        out.writeInt(this.serverHash);
        out.flush();
        this.body.setMetaData(this.metaData);
        this.body.writeExternal(out);
    }

    public static class Body
    implements Externalizable {
        private static final long serialVersionUID = -5364100745236348268L;
        private volatile transient String toString = null;
        private transient EJBMetaDataImpl ejb;
        private transient Object orb;
        private transient Method methodInstance;
        private transient Class interfaceClass;
        private transient String methodName;
        private transient Class[] methodParamTypes;
        private transient Object[] methodParameters;
        private transient Object primaryKey;
        private transient String requestId;
        private byte version = (byte)2;
        private transient JNDIContext.AuthenticationInfo authentication;
        private transient ProtocolMetaData metaData;
        static final Class[] noArgsC = new Class[0];
        static final Object[] noArgsO = new Object[0];
        private static final int INT = 0;
        private static final int BYTE = 1;
        private static final int LONG = 2;
        private static final int FLOAT = 3;
        private static final int DOUBLE = 4;
        private static final int SHORT = 5;
        private static final int CHAR = 6;
        private static final int BOOLEAN = 7;
        private static final int OBJECT = 8;

        public Body(EJBMetaDataImpl ejb) {
            this.ejb = ejb;
        }

        public Body() {
        }

        public void setMetaData(ProtocolMetaData metaData) {
            this.metaData = metaData;
        }

        public byte getVersion() {
            return this.version;
        }

        public void setAuthentication(JNDIContext.AuthenticationInfo authentication) {
            this.authentication = authentication;
        }

        public JNDIContext.AuthenticationInfo getAuthentication() {
            return this.authentication;
        }

        public Method getMethodInstance() {
            return this.methodInstance;
        }

        public Object[] getMethodParameters() {
            return this.methodParameters;
        }

        public Object getPrimaryKey() {
            return this.primaryKey;
        }

        public Class getInterfaceClass() {
            return this.interfaceClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class[] getMethodParamTypes() {
            return this.methodParamTypes;
        }

        public void setMethodInstance(Method methodInstance) {
            if (methodInstance == null) {
                throw new NullPointerException("methodInstance input parameter is null");
            }
            this.methodInstance = methodInstance;
            this.methodName = methodInstance.getName();
            this.methodParamTypes = methodInstance.getParameterTypes();
            Class<?> methodClass = methodInstance.getDeclaringClass();
            if (this.ejb.homeClass != null && methodClass.isAssignableFrom(this.ejb.homeClass)) {
                this.interfaceClass = this.ejb.homeClass;
                return;
            }
            if (this.ejb.remoteClass != null && methodClass.isAssignableFrom(this.ejb.remoteClass)) {
                this.interfaceClass = this.ejb.remoteClass;
                return;
            }
            for (Class businessClass : this.ejb.businessClasses) {
                if (!methodClass.isAssignableFrom(businessClass)) continue;
                this.interfaceClass = businessClass;
                return;
            }
        }

        public void setMethodParameters(Object[] methodParameters) {
            this.methodParameters = methodParameters;
        }

        public void setPrimaryKey(Object primaryKey) {
            this.primaryKey = primaryKey;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            ClassNotFoundException result;
            block9: {
                block8: {
                    this.version = in.readByte();
                    this.requestId = null;
                    result = null;
                    this.primaryKey = null;
                    this.methodName = null;
                    this.methodInstance = null;
                    try {
                        this.requestId = (String)in.readObject();
                        this.primaryKey = in.readObject();
                        this.interfaceClass = (Class)in.readObject();
                    }
                    catch (ClassNotFoundException cnfe) {
                        result = cnfe;
                    }
                    this.methodName = in.readUTF();
                    try {
                        this.readMethodParameters(in);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (result != null) break block8;
                        result = cnfe;
                    }
                }
                if (this.interfaceClass != null) {
                    try {
                        this.methodInstance = this.interfaceClass.getMethod(this.methodName, this.methodParamTypes);
                    }
                    catch (NoSuchMethodException nsme) {
                        if (result != null) break block9;
                        throw new ClassNotFoundException(this.interfaceClass.getSimpleName() + "#" + this.methodName + " is not valid");
                    }
                }
            }
            this.authentication = null == this.metaData || this.metaData.isAtLeast(4, 6) ? (JNDIContext.AuthenticationInfo)JNDIContext.AuthenticationInfo.class.cast(in.readObject()) : null;
            if (result != null) {
                throw result;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.version);
            out.writeObject(this.requestId);
            out.writeObject(this.primaryKey);
            out.writeObject(this.interfaceClass);
            out.writeUTF(this.methodName);
            this.writeMethodParameters(out, this.methodParamTypes, this.methodParameters);
            if (null == this.metaData || this.metaData.isAtLeast(4, 6)) {
                out.writeObject(this.authentication);
            }
            out.flush();
        }

        protected void writeMethodParameters(ObjectOutput out, Class[] types, Object[] args) throws IOException {
            out.writeByte(types.length);
            for (int i = 0; i < types.length; ++i) {
                Class clazz = types[i];
                Object obj = args[i];
                if (clazz.isPrimitive()) {
                    if (clazz == Byte.TYPE) {
                        out.write(1);
                        byte bytevalue = (Byte)obj;
                        out.writeByte(bytevalue);
                        continue;
                    }
                    if (clazz == Character.TYPE) {
                        out.write(6);
                        char charvalue = ((Character)obj).charValue();
                        out.writeChar(charvalue);
                        continue;
                    }
                    if (clazz == Integer.TYPE) {
                        out.write(0);
                        int intvalue = (Integer)obj;
                        out.writeInt(intvalue);
                        continue;
                    }
                    if (clazz == Boolean.TYPE) {
                        out.write(7);
                        boolean booleanvalue = (Boolean)obj;
                        out.writeBoolean(booleanvalue);
                        continue;
                    }
                    if (clazz == Long.TYPE) {
                        out.write(2);
                        long longvalue = (Long)obj;
                        out.writeLong(longvalue);
                        continue;
                    }
                    if (clazz == Float.TYPE) {
                        out.write(3);
                        float fvalue = ((Float)obj).floatValue();
                        out.writeFloat(fvalue);
                        continue;
                    }
                    if (clazz == Double.TYPE) {
                        out.write(4);
                        double dvalue = (Double)obj;
                        out.writeDouble(dvalue);
                        continue;
                    }
                    if (clazz == Short.TYPE) {
                        out.write(5);
                        short shortvalue = (Short)obj;
                        out.writeShort(shortvalue);
                        continue;
                    }
                    throw new IOException("Unkown primitive type: " + clazz);
                }
                if (InstanceOf.isRemote(obj)) {
                    obj = Corbas.toStub(obj);
                }
                out.write(8);
                out.writeObject(clazz);
                out.writeObject(obj);
            }
        }

        protected void readMethodParameters(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.read();
            if (length < 1) {
                this.methodParamTypes = noArgsC;
                this.methodParameters = noArgsO;
                return;
            }
            Class[] types = new Class[length];
            Object[] args = new Object[length];
            for (int i = 0; i < types.length; ++i) {
                Object obj;
                Class clazz;
                int type = in.read();
                switch (type) {
                    case 1: {
                        clazz = Byte.TYPE;
                        obj = in.readByte();
                        break;
                    }
                    case 6: {
                        clazz = Character.TYPE;
                        obj = Character.valueOf(in.readChar());
                        break;
                    }
                    case 0: {
                        clazz = Integer.TYPE;
                        obj = in.readInt();
                        break;
                    }
                    case 7: {
                        clazz = Boolean.TYPE;
                        obj = in.readBoolean();
                        break;
                    }
                    case 2: {
                        clazz = Long.TYPE;
                        obj = in.readLong();
                        break;
                    }
                    case 3: {
                        clazz = Float.TYPE;
                        obj = Float.valueOf(in.readFloat());
                        break;
                    }
                    case 4: {
                        clazz = Double.TYPE;
                        obj = in.readDouble();
                        break;
                    }
                    case 5: {
                        clazz = Short.TYPE;
                        obj = in.readShort();
                        break;
                    }
                    case 8: {
                        clazz = (Class)in.readObject();
                        Object read = in.readObject();
                        if (InstanceOf.isStub(read)) {
                            obj = Corbas.connect(read);
                            break;
                        }
                        obj = read;
                        break;
                    }
                    default: {
                        throw new IOException("Unkown data type: " + type);
                    }
                }
                types[i] = clazz;
                args[i] = obj;
            }
            this.methodParamTypes = types;
            this.methodParameters = args;
        }

        public String toString() {
            if (null == this.toString) {
                this.toString = "Body{ejb=" + this.ejb + ", orb=" + this.orb + ", methodInstance=" + this.methodInstance + ", interfaceClass=" + this.interfaceClass + ", methodName='" + this.methodName + '\'' + ", methodParamTypes=" + (this.methodParamTypes == null ? null : Arrays.asList(this.methodParamTypes)) + ", methodParameters=" + (this.methodParameters == null ? null : Arrays.asList(this.methodParameters)) + ", primaryKey=" + this.primaryKey + ", requestId='" + this.requestId + '\'' + ", version=" + this.version + '}';
            }
            return this.toString;
        }
    }
}

