/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.jarstxt;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.ProvisioningUtil;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="generate", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class JarsTxtMojo
extends AbstractMojo {
    public static final String JAR = "jar";
    @Component
    protected MavenProject project;
    @Parameter(property="outputFile", defaultValue="${project.build.directory}/${project.build.finalName}/WEB-INF/jars.txt")
    protected File outputFile;
    @Parameter(property="hash")
    protected String hashAlgo;
    @Parameter(property="useTimeStamp", defaultValue="false")
    protected boolean useTimeStamp;
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver resolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository local;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepos;
    @Parameter
    protected List<String> additionals;
    @Parameter
    protected Map<String, String> placeHolders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.outputFile.getParentFile().exists()) {
            FileUtils.mkdir((String)this.outputFile.getParentFile().getAbsolutePath());
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.outputFile));
            TreeSet<String> set = new TreeSet<String>();
            for (Object a : this.project.getArtifacts()) {
                if (!this.acceptScope(a.getScope()) || !this.acceptType(a.getType())) continue;
                a.setScope("provided");
                StringBuilder stringBuilder = new StringBuilder("mvn:").append(a.getGroupId()).append("/").append(a.getArtifactId()).append("/").append(this.version((Artifact)a));
                boolean isJar = JAR.equals(a.getType());
                if (!isJar) {
                    stringBuilder.append("/").append(a.getType());
                }
                if (a.getClassifier() != null) {
                    if (isJar) {
                        stringBuilder.append("/").append(JAR);
                    }
                    stringBuilder.append("/").append(a.getClassifier());
                }
                if (this.hashAlgo != null) {
                    Artifact artifact = this.factory.createDependencyArtifact(a.getGroupId(), a.getArtifactId(), VersionRange.createFromVersion((String)a.getVersion()), a.getType(), a.getClassifier(), a.getScope());
                    try {
                        this.resolver.resolve(artifact, this.remoteRepos, this.local);
                    }
                    catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                    File file = artifact.getFile();
                    stringBuilder.append("|").append(Files.hash((Set)Collections.singleton((Object)file.toURI().toURL()), (String)this.hashAlgo)).append("|").append(this.hashAlgo);
                }
                set.add(stringBuilder.toString());
            }
            if (this.additionals != null) {
                if (this.placeHolders == null) {
                    this.placeHolders = new HashMap<String, String>();
                }
                StrSubstitutor lookup = new StrSubstitutor(StrLookup.mapLookup(this.placeHolders));
                for (String string : this.additionals) {
                    StringBuilder builder = new StringBuilder(string);
                    if (this.hashAlgo != null) {
                        builder.append("|").append(Files.hash(this.urls(string, lookup), (String)this.hashAlgo)).append("|").append(this.hashAlgo);
                    }
                    set.add(builder.toString());
                }
            }
            for (String line : set) {
                writer.write(line);
                writer.write("\n");
            }
            writer.flush();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Set<URL> urls(String line, StrSubstitutor lookup) {
        HashSet<URL> urls = new HashSet<URL>();
        for (String location : ProvisioningUtil.realLocation((String)lookup.replace(line))) {
            try {
                urls.add(new File(location).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return urls;
    }

    private String version(Artifact a) {
        if (!this.useTimeStamp && a.getBaseVersion().endsWith("SNAPSHOT")) {
            return a.getBaseVersion();
        }
        return a.getVersion();
    }

    private boolean acceptType(String type) {
        return JAR.equals(type) || "zip".equals(type);
    }

    private boolean acceptScope(String scope) {
        return "compile".equals(scope) || "runtime".equals(scope);
    }
}

