/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.itest.util;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class Timer {
    private final long start = System.nanoTime();

    public static Timer start() {
        return new Timer();
    }

    public Time time() {
        return new Time(System.nanoTime() - this.start);
    }

    public static class Time {
        private final long time;
        private final String description;

        public Time(long timeInNanoseconds) {
            this.time = timeInNanoseconds;
            long seconds = TimeUnit.NANOSECONDS.toSeconds(this.time);
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(this.time) - TimeUnit.SECONDS.toMillis(seconds);
            long nanoseconds = this.time - TimeUnit.SECONDS.toNanos(seconds) - TimeUnit.MILLISECONDS.toNanos(milliseconds);
            this.description = String.format("%ss, %sms and %sns", seconds, milliseconds, nanoseconds);
        }

        public long getTime() {
            return this.time;
        }

        public Time assertLessThan(long time, TimeUnit unit) {
            long expected = unit.toNanos(time);
            long actual = this.time;
            Assert.assertTrue((String)("Actual time: " + this.description), (actual < expected ? 1 : 0) != 0);
            return this;
        }

        public Time assertGreaterThan(long time, TimeUnit unit) {
            long expected = unit.toNanos(time);
            long actual = this.time;
            Assert.assertTrue((String)("Actual time: " + this.description), (actual > expected ? 1 : 0) != 0);
            return this;
        }
    }
}

