/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;

public class ClassArgParser {
    private static final int TOKEN_EOF = -1;
    private static final int TOKEN_NONE = 0;
    private static final int TOKEN_PACKAGE = 1;
    private static final int TOKEN_CLASS = 2;
    private static final int TOKEN_PACKAGE_NOATTR = 3;
    private static final int TOKEN_CLASS_NOATTR = 4;
    private static final Localizer _loc = Localizer.forPackage(ClassArgParser.class);
    private ClassLoader _loader = null;
    private char[] _packageAttr = "name".toCharArray();
    private char[] _classAttr = "name".toCharArray();
    private char[][] _beginElements = new char[][]{{'p'}, {'c'}};
    private char[][] _endElements = new char[][]{"ackage".toCharArray(), "lass".toCharArray()};

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setMetaDataStructure(String packageElementName, String packageAttributeName, String[] classElementNames, String classAttributeName) {
        int i;
        char[] buf = new char[classElementNames.length + 1];
        int charIdx = 0;
        while (true) {
            for (i = 0; i < buf.length; ++i) {
                if (i == 0) {
                    if (charIdx == packageElementName.length()) {
                        throw new UnsupportedOperationException(_loc.get("cant-diff-elems").getMessage());
                    }
                    buf[i] = packageElementName.charAt(charIdx);
                    continue;
                }
                if (charIdx == classElementNames[i - 1].length()) {
                    throw new UnsupportedOperationException(_loc.get("cant-diff-elems").getMessage());
                }
                buf[i] = classElementNames[i - 1].charAt(charIdx);
            }
            if (ClassArgParser.charsUnique(buf)) break;
            ++charIdx;
        }
        this._packageAttr = packageAttributeName == null ? null : packageAttributeName.toCharArray();
        this._classAttr = classAttributeName == null ? null : classAttributeName.toCharArray();
        this._beginElements = new char[classElementNames.length + 1][];
        this._endElements = new char[classElementNames.length + 1][];
        this._beginElements[0] = packageElementName.substring(0, charIdx + 1).toCharArray();
        this._endElements[0] = packageElementName.substring(charIdx + 1).toCharArray();
        for (i = 0; i < classElementNames.length; ++i) {
            this._beginElements[i + 1] = classElementNames[i].substring(0, charIdx + 1).toCharArray();
            this._endElements[i + 1] = classElementNames[i].substring(charIdx + 1).toCharArray();
        }
    }

    private static boolean charsUnique(char[] buf) {
        for (int i = buf.length - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (buf[j] != buf[i]) continue;
                return false;
            }
        }
        return true;
    }

    public Class<?>[] parseTypes(String arg) {
        String[] names = this.parseTypeNames(arg);
        Class[] objs = new Class[names.length];
        for (int i = 0; i < names.length; ++i) {
            objs[i] = ClassUtil.toClass(names[i], this._loader);
        }
        return objs;
    }

    public Class<?>[] parseTypes(MetaDataIterator itr) {
        String[] names = this.parseTypeNames(itr);
        Class[] objs = new Class[names.length];
        for (int i = 0; i < names.length; ++i) {
            objs[i] = ClassUtil.toClass(names[i], this._loader);
        }
        return objs;
    }

    public Map<Object, Class<?>[]> mapTypes(MetaDataIterator itr) {
        Map<Object, String[]> map = this.mapTypeNames(itr);
        HashMap<Object, Class<?>[]> rval = new HashMap<Object, Class<?>[]>();
        Iterator<Map.Entry<Object, String[]>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, String[]> objectEntry;
            Map.Entry<Object, String[]> entry = objectEntry = iterator.next();
            String[] names = entry.getValue();
            Class[] objs = new Class[names.length];
            for (int j = 0; j < names.length; ++j) {
                objs[j] = ClassUtil.toClass(names[j], this._loader);
            }
            rval.put(entry.getKey(), objs);
        }
        return rval;
    }

    public String[] parseTypeNames(String arg) {
        if (arg == null) {
            return new String[0];
        }
        try {
            File file = Files.getFile(arg, this._loader);
            if (arg.endsWith(".class")) {
                return new String[]{this.getFromClassFile(file)};
            }
            if (arg.endsWith(".java")) {
                return new String[]{this.getFromJavaFile(file)};
            }
            if (AccessController.doPrivileged(J2DoPrivHelper.existsAction(file)).booleanValue()) {
                Collection<String> col = this.getFromMetaDataFile(file);
                return col.toArray(new String[col.size()]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(_loc.get("class-arg", arg).getMessage(), e);
        }
        return new String[]{arg};
    }

    public String[] parseTypeNames(MetaDataIterator itr) {
        if (itr == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        Object source = null;
        try {
            while (itr.hasNext()) {
                source = itr.next();
                this.appendTypeNames(source, itr.getInputStream(), names);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(_loc.get("class-arg", source).getMessage(), e);
        }
        return names.toArray(new String[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendTypeNames(Object source, InputStream in, List<String> names) throws IOException {
        try {
            if (source.toString().endsWith(".class")) {
                names.add(this.getNameFromClass(in));
            }
            names.addAll(this.getFromMetaData(new InputStreamReader(in)));
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Map<Object, String[]> mapTypeNames(MetaDataIterator itr) {
        if (itr == null) {
            return Collections.emptyMap();
        }
        HashMap<Object, String[]> map = new HashMap<Object, String[]>();
        Object source = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            while (itr.hasNext()) {
                source = itr.next();
                this.appendTypeNames(source, itr.getInputStream(), names);
                if (!names.isEmpty()) {
                    map.put(source, names.toArray(new String[names.size()]));
                }
                names.clear();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(_loc.get("class-arg", source).getMessage(), e);
        }
        return map;
    }

    private String getFromClassFile(File file) throws IOException {
        FileInputStream fin = null;
        try {
            fin = AccessController.doPrivileged(J2DoPrivHelper.newFileInputStreamAction(file));
            String string = this.getNameFromClass(fin);
            return string;
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getException();
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getNameFromClass(InputStream in) throws IOException {
        ClassReader cr = new ClassReader(in);
        ClassNameScanner classNameScanner = new ClassNameScanner(589824);
        cr.accept((ClassVisitor)classNameScanner, 7);
        return classNameScanner.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFromJavaFile(File file) throws IOException {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            StringBuilder pack = null;
            while ((line = in.readLine()) != null) {
                if (!(line = line.trim()).startsWith("package ")) continue;
                line = line.substring(8).trim();
                pack = new StringBuilder();
                for (int i = 0; i < line.length() && (Character.isJavaIdentifierPart(line.charAt(i)) || line.charAt(i) == '.'); ++i) {
                    pack.append(line.charAt(i));
                }
            }
            Object clsName = file.getName();
            clsName = ((String)clsName).substring(0, ((String)clsName).length() - 5);
            if (pack != null && pack.length() > 0) {
                clsName = pack + "." + (String)clsName;
            }
            String string = clsName;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getFromMetaDataFile(File file) throws IOException {
        FileReader in = null;
        try {
            in = new FileReader(file);
            Collection<String> collection = this.getFromMetaData(in);
            return collection;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Collection<String> getFromMetaData(Reader xml) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        BufferedReader in = new BufferedReader(xml);
        boolean comment = false;
        int token = 0;
        String pkg = "";
        int ch = 0;
        int last = 0;
        int last2 = 0;
        while (true) {
            if (ch != 60) {
                ch = in.read();
                if (ch == -1) return names;
            }
            if (comment && last2 == 45 && last == 45 && ch == 62) {
                comment = false;
            } else if (comment) {
                if (ch == 60 && (ch = in.read()) == -1) {
                    return names;
                }
            } else if (last2 == 60 && last == 33 && ch == 45) {
                comment = true;
            } else if (ch == 60) {
                token = 0;
                last = ch;
                ch = this.readThroughWhitespace(in);
                if (ch != 47 && ch != 33 && ch != 63) {
                    token = this.readElementToken(ch, in);
                    switch (token) {
                        case -1: {
                            return names;
                        }
                        case 1: {
                            pkg = this.readAttribute(in, this._packageAttr);
                            if (pkg != null) break;
                            return names;
                        }
                        case 3: {
                            pkg = this.readElementText(in);
                            if (pkg == null) {
                                return names;
                            }
                            ch = 60;
                            break;
                        }
                        case 2: {
                            String name = this.readAttribute(in, this._classAttr);
                            if (name == null) {
                                return names;
                            }
                            if (pkg.length() > 0 && name.indexOf(46) == -1) {
                                names.add(pkg + "." + name);
                                break;
                            }
                            names.add(name);
                            break;
                        }
                        case 4: {
                            String name = this.readElementText(in);
                            if (name == null) {
                                return names;
                            }
                            ch = 60;
                            if (pkg.length() > 0 && name.indexOf(46) == -1) {
                                names.add(pkg + "." + name);
                                break;
                            }
                            names.add(name);
                        }
                    }
                }
            }
            last2 = last;
            last = ch;
        }
    }

    private int readElementToken(int ch, Reader in) throws IOException {
        char[] match;
        int matchIdx = -1;
        int matched = 0;
        int dq = 0;
        for (int beginIdx = 0; beginIdx < this._beginElements[0].length; ++beginIdx) {
            if (beginIdx != 0) {
                ch = in.read();
            }
            if (ch == -1) {
                return -1;
            }
            matched = 0;
            for (int i = 0; i < this._beginElements.length; ++i) {
                if ((dq & 2 << i) != 0) continue;
                if (ch == this._beginElements[i][beginIdx]) {
                    matchIdx = i;
                    ++matched;
                    continue;
                }
                dq |= 2 << i;
            }
            if (matched == 0) break;
        }
        if (matched != 1) {
            return 0;
        }
        for (char c : match = this._endElements[matchIdx]) {
            ch = in.read();
            if (ch == -1) {
                return -1;
            }
            if (ch == c) continue;
            return 0;
        }
        ch = in.read();
        if (ch == -1) {
            return -1;
        }
        if (ch == 62) {
            if (matchIdx == 0 && this._packageAttr == null) {
                return 3;
            }
            if (matchIdx != 0 && this._classAttr == null) {
                return 4;
            }
        } else if (Character.isWhitespace((char)ch)) {
            if (matchIdx == 0 && this._packageAttr != null) {
                return 1;
            }
            if (matchIdx != 0 && this._classAttr != null) {
                return 2;
            }
        }
        return 0;
    }

    private String readAttribute(Reader in, char[] name) throws IOException {
        int expected = 0;
        int last = 0;
        int ch;
        while ((ch = in.read()) != -1) {
            if (ch == 62) {
                return "";
            }
            if (ch != name[expected] || expected == 0 && last != 0 && !Character.isWhitespace((char)last)) {
                expected = 0;
            } else if (++expected == name.length) {
                ch = this.readThroughWhitespace(in);
                if (ch == -1) {
                    return null;
                }
                if (ch != 61) {
                    expected = 0;
                } else {
                    this.readThroughWhitespace(in);
                    return this.readAttributeValue(in);
                }
            }
            last = ch;
        }
        return null;
    }

    private String readElementText(Reader in) throws IOException {
        StringBuilder buf = null;
        while (true) {
            int ch;
            if ((ch = in.read()) == -1) {
                return null;
            }
            if (ch == 60) break;
            if (Character.isWhitespace((char)ch)) continue;
            if (buf == null) {
                buf = new StringBuilder();
            }
            buf.append((char)ch);
        }
        return buf == null ? "" : buf.toString();
    }

    private int readThroughWhitespace(Reader in) throws IOException {
        int ch;
        while ((ch = in.read()) != -1 && Character.isWhitespace((char)ch)) {
        }
        return ch;
    }

    private String readAttributeValue(Reader in) throws IOException {
        StringBuilder buf = new StringBuilder();
        int ch;
        while ((ch = in.read()) != -1) {
            if (ch == 39 || ch == 34) {
                return buf.toString();
            }
            buf.append((char)ch);
        }
        return null;
    }

    public class ClassNameScanner
    extends ClassVisitor {
        String className;

        public ClassNameScanner(int api) {
            super(api);
            this.className = null;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name.replace("/", ".");
            super.visit(version, access, name, signature, superName, interfaces);
        }
    }
}

