/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BufferPool {
    protected static Log log = LogFactory.getLog(BufferPool.class);
    public static int DEFAULT_POOL_SIZE = 0x6400000;
    protected static BufferPool instance = null;
    protected BufferPoolAPI pool = null;

    private BufferPool(BufferPoolAPI pool) {
        this.pool = pool;
    }

    public XByteBuffer getBuffer(int minSize, boolean discard) {
        if (this.pool != null) {
            return this.pool.getBuffer(minSize, discard);
        }
        return new XByteBuffer(minSize, discard);
    }

    public void returnBuffer(XByteBuffer buffer) {
        if (this.pool != null) {
            this.pool.returnBuffer(buffer);
        }
    }

    public void clear() {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferPool getBufferPool() {
        if (instance != null) return instance;
        Class<BufferPool> clazz = BufferPool.class;
        synchronized (BufferPool.class) {
            Class<?> clazz2;
            BufferPoolAPI pool;
            block7: {
                if (instance != null) return instance;
                pool = null;
                clazz2 = null;
                try {
                    clazz2 = Class.forName("org.apache.catalina.tribes.io.BufferPool15Impl");
                    pool = (BufferPoolAPI)clazz2.newInstance();
                }
                catch (Throwable x) {
                    try {
                        clazz2 = Class.forName("org.apache.catalina.tribes.io.BufferPool14Impl");
                        pool = (BufferPoolAPI)clazz2.newInstance();
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Unable to initilize BufferPool, not pooling XByteBuffer objects:" + x.getMessage()));
                        if (!log.isDebugEnabled()) break block7;
                        log.debug((Object)"Unable to initilize BufferPool, not pooling XByteBuffer objects:", x);
                    }
                }
            }
            pool.setMaxSize(DEFAULT_POOL_SIZE);
            log.info((Object)("Created a buffer pool with max size:" + DEFAULT_POOL_SIZE + " bytes of type:" + (clazz2 != null ? clazz2.getName() : "null")));
            instance = new BufferPool(pool);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static interface BufferPoolAPI {
        public void setMaxSize(int var1);

        public XByteBuffer getBuffer(int var1, boolean var2);

        public void returnBuffer(XByteBuffer var1);

        public void clear();
    }
}

