/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat6;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tomcat.maven.common.deployer.TomcatManagerException;
import org.apache.tomcat.maven.common.deployer.TomcatManagerResponse;
import org.apache.tomcat.maven.plugin.tomcat6.AbstractDeployMojo;

public class AbstractDeployWarMojo
extends AbstractDeployMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.war", property="maven.tomcat.warFile", required=true)
    private File warFile;

    protected File getWarFile() {
        return this.warFile;
    }

    protected void validateWarFile() throws MojoExecutionException {
        if (!this.warFile.exists() || !this.warFile.isFile()) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("DeployMojo.missingWar", new Object[]{this.warFile.getPath()}));
        }
    }

    protected void deployWar() throws MojoExecutionException, TomcatManagerException, IOException {
        this.validateWarFile();
        this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractDeployMojo.deployingWar", new Object[]{this.getDeployedURL()}));
        TomcatManagerResponse tomcatResponse = this.getManager().deploy(this.getPath(), this.warFile, this.isUpdate(), this.getTag(), this.warFile.length());
        this.checkTomcatResponse(tomcatResponse);
    }
}

