/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.Info;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.commons.io.IOUtils;

public class ManifestConverter
implements Converter {
    private static final Logger logger = Logger.getLogger(ManifestConverter.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(ManifestConverter.class);

    @Override
    public boolean accepts(String filename) {
        return filename.equals("META-INF/MANIFEST.MF") || filename.endsWith("/META-INF/MANIFEST.MF");
    }

    @Override
    public boolean convert(String path, InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        byte[] srcBytes = IOUtils.toByteArray(src);
        Manifest srcManifest = new Manifest(new ByteArrayInputStream(srcBytes));
        Manifest destManifest = new Manifest(srcManifest);
        boolean converted = this.updateValues(destManifest, profile);
        this.removeSignatures(destManifest);
        if (srcManifest.equals(destManifest)) {
            IOUtils.writeChunked(srcBytes, dest);
            logger.log(Level.FINEST, sm.getString("manifestConverter.noConversion", path));
        } else {
            destManifest.write(dest);
            String key = converted ? "manifestConverter.converted" : "manifestConverter.updated";
            logger.log(Level.FINE, sm.getString(key, path));
        }
        return converted;
    }

    private void removeSignatures(Manifest manifest) {
        manifest.getMainAttributes().remove(Attributes.Name.SIGNATURE_VERSION);
        ArrayList<String> signatureEntries = new ArrayList<String>();
        Map<String, Attributes> manifestAttributeEntries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : manifestAttributeEntries.entrySet()) {
            if (!this.isCryptoSignatureEntry(entry.getValue())) continue;
            String entryName = entry.getKey();
            signatureEntries.add(entryName);
            logger.log(Level.FINE, sm.getString("manifestConverter.removeSignature", entryName));
        }
        for (String string : signatureEntries) {
            manifestAttributeEntries.remove(string);
        }
    }

    private boolean isCryptoSignatureEntry(Attributes attributes) {
        for (Object attributeKey : attributes.keySet()) {
            if (!attributeKey.toString().endsWith("-Digest")) continue;
            return true;
        }
        return false;
    }

    private boolean updateValues(Manifest manifest, EESpecProfile profile) {
        boolean converted = this.updateValues(manifest.getMainAttributes(), profile);
        for (Attributes attributes : manifest.getEntries().values()) {
            converted |= this.updateValues(attributes, profile);
        }
        return converted;
    }

    private boolean updateValues(Attributes attributes, EESpecProfile profile) {
        boolean converted = false;
        if (attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
            String newValue = attributes.get(Attributes.Name.IMPLEMENTATION_VERSION) + "-" + Info.getVersion();
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, newValue);
            logger.log(Level.FINE, sm.getString("manifestConverter.updatedVersion", newValue));
        }
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String newValue = profile.convert((String)entry.getValue());
            if (newValue == entry.getValue()) continue;
            entry.setValue(newValue);
            converted = true;
        }
        return converted;
    }
}

