/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.tomcat.jakartaee.ClassConverter;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.Info;
import org.apache.tomcat.jakartaee.PassThroughConverter;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.TextConverter;

public class Migration {
    private static final Logger logger = Logger.getLogger(Migration.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(Migration.class);
    private EESpecProfile profile = EESpecProfile.TOMCAT;
    private File source;
    private File destination;
    private final List<Converter> converters = new ArrayList<Converter>();

    public Migration() {
        this.converters.add(new TextConverter());
        this.converters.add(new ClassConverter());
        this.converters.add(new PassThroughConverter());
    }

    public void setEESpecProfile(EESpecProfile profile) {
        this.profile = profile;
    }

    public EESpecProfile getEESpecProfile() {
        return this.profile;
    }

    public void setSource(File source) {
        if (!source.canRead()) {
            throw new IllegalArgumentException(sm.getString("migration.cannotReadSource", source.getAbsolutePath()));
        }
        this.source = source;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public boolean execute() throws IOException {
        logger.log(Level.INFO, sm.getString("migration.execute", this.source.getAbsolutePath(), this.destination.getAbsolutePath(), this.profile.toString()));
        boolean result = true;
        long t1 = System.nanoTime();
        if (this.source.isDirectory()) {
            if (this.destination.exists() && this.destination.isDirectory() || this.destination.mkdirs()) {
                result = result && this.migrateDirectory(this.source, this.destination);
            } else {
                logger.log(Level.WARNING, sm.getString("migration.mkdirError", this.destination.getAbsolutePath()));
                result = false;
            }
        } else {
            File parentDestination = this.destination.getAbsoluteFile().getParentFile();
            if (parentDestination.exists() || parentDestination.mkdirs()) {
                result = result && this.migrateFile(this.source, this.destination);
            } else {
                logger.log(Level.WARNING, sm.getString("migration.mkdirError", parentDestination.getAbsolutePath()));
                result = false;
            }
        }
        logger.log(Level.INFO, sm.getString("migration.done", TimeUnit.MILLISECONDS.convert(System.nanoTime() - t1, TimeUnit.NANOSECONDS), result));
        return result;
    }

    private boolean migrateDirectory(File src, File dest) throws IOException {
        String[] files;
        boolean result = true;
        for (String file : files = src.list()) {
            File srcFile = new File(src, file);
            File destFile = new File(dest, file);
            if (srcFile.isDirectory()) {
                if (destFile.exists() && destFile.isDirectory() || destFile.mkdir()) {
                    result = result && this.migrateDirectory(srcFile, destFile);
                    continue;
                }
                logger.log(Level.WARNING, sm.getString("migration.mkdirError", destFile.getAbsolutePath()));
                result = false;
                continue;
            }
            result = result && this.migrateFile(srcFile, destFile);
        }
        return result;
    }

    private boolean migrateFile(File src, File dest) throws IOException {
        boolean result;
        block49: {
            result = false;
            boolean inplace = src.equals(dest);
            if (!inplace) {
                try (FileInputStream is = new FileInputStream(src);
                     FileOutputStream os = new FileOutputStream(dest);){
                    result = this.migrateStream(src.getName(), is, os);
                    break block49;
                }
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream((int)((double)src.length() * 1.05));
            try (FileInputStream is = new FileInputStream(src);){
                result = this.migrateStream(src.getName(), is, buffer);
            }
            var7_12 = null;
            try (FileOutputStream os = new FileOutputStream(dest);){
                ((OutputStream)os).write(buffer.toByteArray());
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
        }
        return result;
    }

    private boolean migrateArchive(InputStream src, OutputStream dest) throws IOException {
        boolean result = true;
        try (JarInputStream jarIs = new JarInputStream((InputStream)new CloseShieldInputStream(src));
             JarOutputStream jarOs = new JarOutputStream((OutputStream)new CloseShieldOutputStream(dest));){
            JarEntry jarEntry;
            Manifest manifest = jarIs.getManifest();
            if (manifest != null) {
                manifest = new Manifest(manifest);
                this.updateVersion(manifest);
                if (this.removeSignatures(manifest)) {
                    logger.log(Level.WARNING, sm.getString("migration.warnSignatureRemoval"));
                }
                JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
                jarOs.putNextEntry(manifestEntry);
                manifest.write(jarOs);
            }
            while ((jarEntry = jarIs.getNextJarEntry()) != null) {
                String sourceName = jarEntry.getName();
                logger.log(Level.FINE, sm.getString("migration.entry", sourceName));
                if (this.isSignatureFile(sourceName)) {
                    logger.log(Level.FINE, sm.getString("migration.skipSignatureFile", sourceName));
                    continue;
                }
                String destName = this.profile.convert(sourceName);
                JarEntry destEntry = new JarEntry(destName);
                jarOs.putNextEntry(destEntry);
                result = result && this.migrateStream(destEntry.getName(), jarIs, jarOs);
            }
        }
        return result;
    }

    private boolean isSignatureFile(String sourceName) {
        return sourceName.startsWith("META-INF/") && (sourceName.endsWith(".SF") || sourceName.endsWith(".RSA") || sourceName.endsWith(".DSA") || sourceName.endsWith(".EC"));
    }

    private boolean migrateStream(String name, InputStream src, OutputStream dest) throws IOException {
        if (Migration.isArchive(name)) {
            logger.log(Level.INFO, sm.getString("migration.archive", name));
            return this.migrateArchive(src, dest);
        }
        logger.log(Level.FINE, sm.getString("migration.stream", name));
        for (Converter converter : this.converters) {
            if (!converter.accepts(name)) continue;
            converter.convert(src, dest, this.profile);
            break;
        }
        return true;
    }

    private boolean removeSignatures(Manifest manifest) {
        boolean removedSignatures = manifest.getMainAttributes().remove(Attributes.Name.SIGNATURE_VERSION) != null;
        ArrayList<String> signatureEntries = new ArrayList<String>();
        Map<String, Attributes> manifestAttributeEntries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : manifestAttributeEntries.entrySet()) {
            if (!this.isCryptoSignatureEntry(entry.getValue())) continue;
            String entryName = entry.getKey();
            signatureEntries.add(entryName);
            logger.log(Level.FINE, sm.getString("migration.removeSignature", entryName));
            removedSignatures = true;
        }
        for (String string : signatureEntries) {
            manifestAttributeEntries.remove(string);
        }
        return removedSignatures;
    }

    private boolean isCryptoSignatureEntry(Attributes attributes) {
        for (Object attributeKey : attributes.keySet()) {
            if (!attributeKey.toString().endsWith("-Digest")) continue;
            return true;
        }
        return false;
    }

    private void updateVersion(Manifest manifest) {
        this.updateVersion(manifest.getMainAttributes());
        for (Attributes attributes : manifest.getEntries().values()) {
            this.updateVersion(attributes);
        }
    }

    private void updateVersion(Attributes attributes) {
        if (attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
            String newValue = attributes.get(Attributes.Name.IMPLEMENTATION_VERSION) + "-" + Info.getVersion();
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, newValue);
        }
    }

    private static boolean isArchive(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".war") || fileName.endsWith(".zip");
    }
}

