/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.EncodeException;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WrappedMessageHandler;
import org.apache.tomcat.websocket.WsSession;

public abstract class PojoMessageHandlerBase<T>
implements WrappedMessageHandler {
    private final Log log = LogFactory.getLog(PojoMessageHandlerBase.class);
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerBase.class);
    protected final Object pojo;
    protected final Method method;
    protected final Session session;
    protected final Object[] params;
    protected final int indexPayload;
    protected final boolean convert;
    protected final int indexSession;
    protected final long maxMessageSize;

    public PojoMessageHandlerBase(Object pojo, Method method, Session session, Object[] params, int indexPayload, boolean convert, int indexSession, long maxMessageSize) {
        this.pojo = pojo;
        this.method = method;
        try {
            this.method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session = session;
        this.params = params;
        this.indexPayload = indexPayload;
        this.convert = convert;
        this.indexSession = indexSession;
        this.maxMessageSize = maxMessageSize;
    }

    protected final void processResult(Object result) {
        if (result == null) {
            return;
        }
        RemoteEndpoint.Basic remoteEndpoint = this.session.getBasicRemote();
        try {
            Object object = result;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, ByteBuffer.class, byte[].class}, (Object)object2, n)) {
                case 0: {
                    String s = (String)object2;
                    remoteEndpoint.sendText(s);
                    break;
                }
                case 1: {
                    ByteBuffer byteBuffer = (ByteBuffer)object2;
                    remoteEndpoint.sendBinary(byteBuffer);
                    break;
                }
                case 2: {
                    byte[] bytes = (byte[])object2;
                    remoteEndpoint.sendBinary(ByteBuffer.wrap(bytes));
                    break;
                }
                default: {
                    remoteEndpoint.sendObject(result);
                    break;
                }
            }
        }
        catch (EncodeException | IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    @Override
    public final MessageHandler getWrappedHandler() {
        if (this.pojo instanceof MessageHandler) {
            return (MessageHandler)this.pojo;
        }
        return null;
    }

    @Override
    public final long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    protected final void handlePojoMethodInvocationTargetException(InvocationTargetException e) {
        Throwable t = ExceptionUtils.unwrapInvocationTargetException((Throwable)e);
        ExceptionUtils.handleThrowable((Throwable)t);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("pojoMessageHandlerBase.onMessageFail", new Object[]{this.pojo.getClass().getName(), this.session.getId()}), t);
        }
        ((WsSession)this.session).getLocal().onError(this.session, t);
    }
}

