/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.naming.NamingException;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.DecoderEntry;
import org.apache.tomcat.websocket.MessageHandlerResult;
import org.apache.tomcat.websocket.MessageHandlerResultType;
import org.apache.tomcat.websocket.WsExtension;
import org.apache.tomcat.websocket.WsExtensionParameter;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerPartialBinary;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBinary;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeText;

public class Util {
    private static final StringManager sm = StringManager.getManager(Util.class);
    private static final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();

    private Util() {
    }

    static boolean isControl(byte opCode) {
        return (opCode & 8) != 0;
    }

    static boolean isText(byte opCode) {
        return opCode == 1;
    }

    static boolean isContinuation(byte opCode) {
        return opCode == 0;
    }

    static CloseReason.CloseCode getCloseCode(int code) {
        if (code > 2999 && code < 5000) {
            return CloseReason.CloseCodes.getCloseCode(code);
        }
        return switch (code) {
            case 1000 -> CloseReason.CloseCodes.NORMAL_CLOSURE;
            case 1001 -> CloseReason.CloseCodes.GOING_AWAY;
            case 1002 -> CloseReason.CloseCodes.PROTOCOL_ERROR;
            case 1003 -> CloseReason.CloseCodes.CANNOT_ACCEPT;
            case 1004 -> CloseReason.CloseCodes.PROTOCOL_ERROR;
            case 1005 -> CloseReason.CloseCodes.PROTOCOL_ERROR;
            case 1006 -> CloseReason.CloseCodes.PROTOCOL_ERROR;
            case 1007 -> CloseReason.CloseCodes.NOT_CONSISTENT;
            case 1008 -> CloseReason.CloseCodes.VIOLATED_POLICY;
            case 1009 -> CloseReason.CloseCodes.TOO_BIG;
            case 1010 -> CloseReason.CloseCodes.NO_EXTENSION;
            case 1011 -> CloseReason.CloseCodes.UNEXPECTED_CONDITION;
            case 1012 -> CloseReason.CloseCodes.PROTOCOL_ERROR;
            case 1013 -> CloseReason.CloseCodes.PROTOCOL_ERROR;
            case 1015 -> CloseReason.CloseCodes.PROTOCOL_ERROR;
            default -> CloseReason.CloseCodes.PROTOCOL_ERROR;
        };
    }

    static byte[] generateMask() {
        SecureRandom sr = randoms.poll();
        if (sr == null) {
            try {
                sr = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                sr = new SecureRandom();
            }
        }
        byte[] result = new byte[4];
        sr.nextBytes(result);
        randoms.add(sr);
        return result;
    }

    static Class<?> getMessageType(MessageHandler listener) {
        return Util.getGenericType(MessageHandler.class, listener.getClass()).getClazz();
    }

    private static Class<?> getDecoderType(Class<? extends Decoder> decoder) {
        return Util.getGenericType(Decoder.class, decoder).getClazz();
    }

    static Class<?> getEncoderType(Class<? extends Encoder> encoder) {
        return Util.getGenericType(Encoder.class, encoder).getClazz();
    }

    private static <T> TypeResult getGenericType(Class<T> type, Class<? extends T> clazz) {
        Type[] interfaces;
        for (Type iface : interfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pi;
            if (!(iface instanceof ParameterizedType) || !((pi = (ParameterizedType)iface).getRawType() instanceof Class) || !type.isAssignableFrom((Class)pi.getRawType())) continue;
            return Util.getTypeParameter(clazz, pi.getActualTypeArguments()[0]);
        }
        Class<? extends T> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            throw new IllegalStateException();
        }
        TypeResult superClassTypeResult = Util.getGenericType(type, superClazz);
        int dimension = superClassTypeResult.getDimension();
        if (superClassTypeResult.getIndex() == -1 && dimension == 0) {
            return superClassTypeResult;
        }
        if (superClassTypeResult.getIndex() > -1) {
            ParameterizedType superClassType = (ParameterizedType)clazz.getGenericSuperclass();
            TypeResult result = Util.getTypeParameter(clazz, superClassType.getActualTypeArguments()[superClassTypeResult.getIndex()]);
            result.incrementDimension(superClassTypeResult.getDimension());
            if (result.getClazz() != null && result.getDimension() > 0) {
                superClassTypeResult = result;
            } else {
                return result;
            }
        }
        if (superClassTypeResult.getDimension() > 0) {
            Class<?> arrayClazz;
            StringBuilder className = new StringBuilder();
            className.append("[".repeat(Math.max(0, dimension)));
            className.append('L');
            className.append(superClassTypeResult.getClazz().getCanonicalName());
            className.append(';');
            try {
                arrayClazz = Class.forName(className.toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            return new TypeResult(arrayClazz, -1, 0);
        }
        throw new IllegalStateException();
    }

    private static TypeResult getTypeParameter(Class<?> clazz, Type argType) {
        Type type = argType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class, GenericArrayType.class}, (Object)type, n)) {
            case 0 -> {
                Class aClass = (Class)type;
                yield new TypeResult(aClass, -1, 0);
            }
            case 1 -> {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                yield new TypeResult((Class)parameterizedType.getRawType(), -1, 0);
            }
            case 2 -> {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                Type arrayElementType = genericArrayType.getGenericComponentType();
                TypeResult result = Util.getTypeParameter(clazz, arrayElementType);
                result.incrementDimension(1);
                yield result;
            }
            default -> {
                TypeVariable<Class<?>>[] tvs = clazz.getTypeParameters();
                for (int i = 0; i < tvs.length; ++i) {
                    if (!tvs[i].equals(argType)) continue;
                    yield new TypeResult(null, i, 0);
                }
                throw new IllegalStateException();
            }
        };
    }

    public static boolean isPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Character.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Short.class);
    }

    public static Object coerceToType(Class<?> type, String value) {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return Byte.valueOf(value);
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(value.charAt(0));
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.valueOf(value);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(value);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.valueOf(value);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return Short.valueOf(value);
        }
        throw new IllegalArgumentException(sm.getString("util.invalidType", new Object[]{value, type.getName()}));
    }

    public static List<DecoderEntry> getDecoders(List<Class<? extends Decoder>> decoderClazzes, InstanceManager instanceManager) throws DeploymentException {
        ArrayList<DecoderEntry> result = new ArrayList<DecoderEntry>();
        if (decoderClazzes != null) {
            for (Class<? extends Decoder> decoderClazz : decoderClazzes) {
                try {
                    if (instanceManager == null) {
                        instance = decoderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        instance = (Decoder)instanceManager.newInstance(decoderClazz);
                        instanceManager.destroyInstance((Object)instance);
                    }
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException | NamingException e) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.invalidDecoder", new Object[]{decoderClazz.getName()}), e);
                }
                DecoderEntry entry = new DecoderEntry(Util.getDecoderType(decoderClazz), decoderClazz);
                result.add(entry);
            }
        }
        return result;
    }

    static Set<MessageHandlerResult> getMessageHandlers(Class<?> target, MessageHandler listener, EndpointConfig endpointConfig, Session session) {
        HashSet<MessageHandlerResult> results = new HashSet<MessageHandlerResult>(2);
        if (String.class.isAssignableFrom(target)) {
            MessageHandlerResult result = new MessageHandlerResult(listener, MessageHandlerResultType.TEXT);
            results.add(result);
        } else if (ByteBuffer.class.isAssignableFrom(target)) {
            MessageHandlerResult result = new MessageHandlerResult(listener, MessageHandlerResultType.BINARY);
            results.add(result);
        } else if (PongMessage.class.isAssignableFrom(target)) {
            MessageHandlerResult result = new MessageHandlerResult(listener, MessageHandlerResultType.PONG);
            results.add(result);
        } else if (byte[].class.isAssignableFrom(target)) {
            boolean whole = MessageHandler.Whole.class.isAssignableFrom(listener.getClass());
            MessageHandlerResult result = new MessageHandlerResult((MessageHandler)((Object)(whole ? new PojoMessageHandlerWholeBinary(listener, Util.getOnMessageMethod(listener), session, endpointConfig, Util.matchDecoders(target, endpointConfig, true, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, false, -1L) : new PojoMessageHandlerPartialBinary(listener, Util.getOnMessagePartialMethod(listener), session, new Object[2], 0, true, 1, -1, -1L))), MessageHandlerResultType.BINARY);
            results.add(result);
        } else if (InputStream.class.isAssignableFrom(target)) {
            MessageHandlerResult result = new MessageHandlerResult(new PojoMessageHandlerWholeBinary(listener, Util.getOnMessageMethod(listener), session, endpointConfig, Util.matchDecoders(target, endpointConfig, true, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, true, -1L), MessageHandlerResultType.BINARY);
            results.add(result);
        } else if (Reader.class.isAssignableFrom(target)) {
            MessageHandlerResult result = new MessageHandlerResult(new PojoMessageHandlerWholeText(listener, Util.getOnMessageMethod(listener), session, endpointConfig, Util.matchDecoders(target, endpointConfig, false, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, -1L), MessageHandlerResultType.TEXT);
            results.add(result);
        } else {
            MessageHandlerResult result;
            DecoderMatch decoderMatch = Util.matchDecoders(target, endpointConfig, ((WsSession)session).getInstanceManager());
            Method m = Util.getOnMessageMethod(listener);
            if (!decoderMatch.getBinaryDecoders().isEmpty()) {
                result = new MessageHandlerResult(new PojoMessageHandlerWholeBinary(listener, m, session, endpointConfig, decoderMatch.getBinaryDecoders(), new Object[1], 0, false, -1, false, -1L), MessageHandlerResultType.BINARY);
                results.add(result);
            }
            if (!decoderMatch.getTextDecoders().isEmpty()) {
                result = new MessageHandlerResult(new PojoMessageHandlerWholeText(listener, m, session, endpointConfig, decoderMatch.getTextDecoders(), new Object[1], 0, false, -1, -1L), MessageHandlerResultType.TEXT);
                results.add(result);
            }
        }
        if (results.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("wsSession.unknownHandler", new Object[]{listener, target}));
        }
        return results;
    }

    private static List<Class<? extends Decoder>> matchDecoders(Class<?> target, EndpointConfig endpointConfig, boolean binary, InstanceManager instanceManager) {
        DecoderMatch decoderMatch = Util.matchDecoders(target, endpointConfig, instanceManager);
        if (binary) {
            if (!decoderMatch.getBinaryDecoders().isEmpty()) {
                return decoderMatch.getBinaryDecoders();
            }
        } else if (!decoderMatch.getTextDecoders().isEmpty()) {
            return decoderMatch.getTextDecoders();
        }
        return null;
    }

    private static DecoderMatch matchDecoders(Class<?> target, EndpointConfig endpointConfig, InstanceManager instanceManager) {
        DecoderMatch decoderMatch;
        try {
            List<Class<? extends Decoder>> decoders = endpointConfig.getDecoders();
            List<DecoderEntry> decoderEntries = Util.getDecoders(decoders, instanceManager);
            decoderMatch = new DecoderMatch(target, decoderEntries);
        }
        catch (DeploymentException e) {
            throw new IllegalArgumentException(e);
        }
        return decoderMatch;
    }

    public static void parseExtensionHeader(List<Extension> extensions, String header) {
        String[] unparsedExtensions;
        for (String unparsedExtension : unparsedExtensions = header.split(",")) {
            String[] unparsedParameters = unparsedExtension.split(";");
            WsExtension extension = new WsExtension(unparsedParameters[0].trim());
            for (int i = 1; i < unparsedParameters.length; ++i) {
                String value;
                String name;
                int equalsPos = unparsedParameters[i].indexOf(61);
                if (equalsPos == -1) {
                    name = unparsedParameters[i].trim();
                    value = null;
                } else {
                    name = unparsedParameters[i].substring(0, equalsPos).trim();
                    value = unparsedParameters[i].substring(equalsPos + 1).trim();
                    int len = value.length();
                    if (len > 1 && value.charAt(0) == '\"' && value.charAt(len - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                }
                if (Util.containsDelims(name) || Util.containsDelims(value)) {
                    throw new IllegalArgumentException(sm.getString("util.notToken", new Object[]{name, value}));
                }
                if (value != null && (value.indexOf(44) > -1 || value.indexOf(59) > -1 || value.indexOf(34) > -1 || value.indexOf(61) > -1)) {
                    throw new IllegalArgumentException(sm.getString("util.invalidValue", new Object[]{value}));
                }
                extension.addParameter(new WsExtensionParameter(name, value));
            }
            extensions.add(extension);
        }
    }

    private static boolean containsDelims(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        for (char c : input.toCharArray()) {
            switch (c) {
                case '\"': 
                case ',': 
                case ';': 
                case '=': {
                    return true;
                }
            }
        }
        return false;
    }

    private static Method getOnMessageMethod(MessageHandler listener) {
        try {
            return listener.getClass().getMethod("onMessage", Object.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(sm.getString("util.invalidMessageHandler"), e);
        }
    }

    private static Method getOnMessagePartialMethod(MessageHandler listener) {
        try {
            return listener.getClass().getMethod("onMessage", Object.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(sm.getString("util.invalidMessageHandler"), e);
        }
    }

    private static class TypeResult {
        private final Class<?> clazz;
        private final int index;
        private int dimension;

        TypeResult(Class<?> clazz, int index, int dimension) {
            this.clazz = clazz;
            this.index = index;
            this.dimension = dimension;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public int getIndex() {
            return this.index;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void incrementDimension(int inc) {
            this.dimension += inc;
        }
    }

    public static class DecoderMatch {
        private final List<Class<? extends Decoder>> textDecoders = new ArrayList<Class<? extends Decoder>>();
        private final List<Class<? extends Decoder>> binaryDecoders = new ArrayList<Class<? extends Decoder>>();
        private final Class<?> target;

        public DecoderMatch(Class<?> target, List<DecoderEntry> decoderEntries) {
            this.target = target;
            for (DecoderEntry decoderEntry : decoderEntries) {
                if (!decoderEntry.clazz().isAssignableFrom(target)) continue;
                if (Decoder.Binary.class.isAssignableFrom(decoderEntry.decoderClazz())) {
                    this.binaryDecoders.add(decoderEntry.decoderClazz());
                    continue;
                }
                if (Decoder.BinaryStream.class.isAssignableFrom(decoderEntry.decoderClazz())) {
                    this.binaryDecoders.add(decoderEntry.decoderClazz());
                    break;
                }
                if (Decoder.Text.class.isAssignableFrom(decoderEntry.decoderClazz())) {
                    this.textDecoders.add(decoderEntry.decoderClazz());
                    continue;
                }
                if (Decoder.TextStream.class.isAssignableFrom(decoderEntry.decoderClazz())) {
                    this.textDecoders.add(decoderEntry.decoderClazz());
                    break;
                }
                throw new IllegalArgumentException(sm.getString("util.unknownDecoderType"));
            }
        }

        public List<Class<? extends Decoder>> getTextDecoders() {
            return this.textDecoders;
        }

        public List<Class<? extends Decoder>> getBinaryDecoders() {
            return this.binaryDecoders;
        }

        public Class<?> getTarget() {
            return this.target;
        }

        public boolean hasMatches() {
            return !this.textDecoders.isEmpty() || !this.binaryDecoders.isEmpty();
        }
    }
}

