/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated By:JJTree: Do not edit this line. AstNegative.java */
package org.apache.el.parser;

import java.math.BigDecimal;
import java.math.BigInteger;

import jakarta.el.ELException;

import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;


/**
 * @author Jacob Hookom [jacob@hookom.net]
 */
public final class AstNegative extends SimpleNode {
    public AstNegative(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        return Number.class;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object obj = this.children[0].getValue(ctx);

        switch (obj) {
            case null -> {
                return Long.valueOf(0);
            }
            case BigDecimal bigDecimal -> {
                return bigDecimal.negate();
            }
            case BigInteger bigInteger -> {
                return bigInteger.negate();
            }
            case String s -> {
                if (ELSupport.isStringFloat(s)) {
                    return Double.valueOf(-Double.parseDouble((String) obj));
                }
                return Long.valueOf(-Long.parseLong(s));
            }
            case Long l -> {
                return Long.valueOf(-l.longValue());
            }
            case Double v -> {
                return Double.valueOf(-v.doubleValue());
            }
            case Integer i -> {
                return Integer.valueOf(-i.intValue());
            }
            case Float v -> {
                return Float.valueOf(-v.floatValue());
            }
            case Short i -> {
                return Short.valueOf((short) -i.shortValue());
            }
            case Byte b -> {
                return Byte.valueOf((byte) -b.byteValue());
            }
            default -> {
                Long num = (Long) ELSupport.coerceToNumber(ctx, obj, Long.class);
                return Long.valueOf(-num.longValue());
            }
        }
    }
}
