/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import jakarta.el.ELException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.SimpleNode;

public final class AstNegative
extends SimpleNode {
    public AstNegative(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        return Number.class;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object obj;
        Object object = obj = this.children[0].getValue(ctx);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, BigInteger.class, String.class, Long.class, Double.class, Integer.class, Float.class, Short.class, Byte.class}, (Object)object, n)) {
            case -1: {
                return 0L;
            }
            case 0: {
                BigDecimal bigDecimal = (BigDecimal)object;
                return bigDecimal.negate();
            }
            case 1: {
                BigInteger bigInteger = (BigInteger)object;
                return bigInteger.negate();
            }
            case 2: {
                String s = (String)object;
                if (ELSupport.isStringFloat(s)) {
                    return -Double.parseDouble((String)obj);
                }
                return -Long.parseLong(s);
            }
            case 3: {
                Long l = (Long)object;
                return -l.longValue();
            }
            case 4: {
                Double v = (Double)object;
                return -v.doubleValue();
            }
            case 5: {
                Integer i = (Integer)object;
                return -i.intValue();
            }
            case 6: {
                Float v = (Float)object;
                return Float.valueOf(-v.floatValue());
            }
            case 7: {
                Short i = (Short)object;
                return -i.shortValue();
            }
            case 8: {
                Byte b = (Byte)object;
                return -b.byteValue();
            }
        }
        Long num = (Long)ELSupport.coerceToNumber(ctx, obj, Long.class);
        return -num.longValue();
    }
}

