/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import scala.Tuple2;

public final class ReduceIterator<K, V, OK, OV>
implements Iterator<Tuple2<OK, OV>> {
    private final Iterator<Tuple2<K, Iterable<V>>> inputIterator;
    private final MapReduce<K, V, OK, OV, ?> mapReduce;
    private final Queue<Tuple2<OK, OV>> queue = new LinkedList<Tuple2<OK, OV>>();
    private final ReduceIteratorEmitter reduceIteratorEmitter = new ReduceIteratorEmitter();

    public ReduceIterator(MapReduce<K, V, OK, OV, ?> mapReduce, Iterator<Tuple2<K, Iterable<V>>> inputIterator) {
        this.inputIterator = inputIterator;
        this.mapReduce = mapReduce;
        this.mapReduce.workerStart(MapReduce.Stage.REDUCE);
    }

    @Override
    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (!this.inputIterator.hasNext()) {
            this.mapReduce.workerEnd(MapReduce.Stage.REDUCE);
            return false;
        }
        this.processNext();
        return this.hasNext();
    }

    @Override
    public Tuple2<OK, OV> next() {
        if (!this.queue.isEmpty()) {
            return this.queue.remove();
        }
        if (!this.inputIterator.hasNext()) {
            this.mapReduce.workerEnd(MapReduce.Stage.REDUCE);
            throw FastNoSuchElementException.instance();
        }
        this.processNext();
        return this.next();
    }

    private void processNext() {
        Tuple2<K, Iterable<V>> nextKeyValues = this.inputIterator.next();
        this.mapReduce.reduce(nextKeyValues._1(), ((Iterable)nextKeyValues._2()).iterator(), (MapReduce.ReduceEmitter)this.reduceIteratorEmitter);
    }

    private class ReduceIteratorEmitter
    implements MapReduce.ReduceEmitter<OK, OV> {
        private ReduceIteratorEmitter() {
        }

        public void emit(OK key, OV value) {
            ReduceIterator.this.queue.add(new Tuple2(key, value));
        }
    }
}

