/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer;

import org.apache.spark.AccumulatorParam;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;

public final class MemoryAccumulator<A>
implements AccumulatorParam<ObjectWritable<A>> {
    private final MemoryComputeKey<A> memoryComputeKey;

    public MemoryAccumulator(MemoryComputeKey<A> memoryComputeKey) {
        this.memoryComputeKey = memoryComputeKey;
    }

    public ObjectWritable<A> addAccumulator(ObjectWritable<A> a, ObjectWritable<A> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        return new ObjectWritable(this.memoryComputeKey.getReducer().apply(a.get(), b.get()));
    }

    public ObjectWritable<A> addInPlace(ObjectWritable<A> a, ObjectWritable<A> b) {
        return this.addAccumulator(a, b);
    }

    public ObjectWritable<A> zero(ObjectWritable<A> a) {
        return ObjectWritable.empty();
    }
}

