/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.TranslationStrategy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=GremlinProcessRunner.class)
public class TranslationStrategyProcessTest
extends AbstractGremlinProcessTest {
    private static final Logger logger = LoggerFactory.getLogger(TranslationStrategyProcessTest.class);

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotHaveAnonymousTraversalMixups() throws Exception {
        if (!this.g.getStrategies().getStrategy(TranslationStrategy.class).isPresent()) {
            logger.debug("No " + TranslationStrategy.class.getSimpleName() + " is registered and thus, skipping test.");
            return;
        }
        GraphTraversalSource a = this.g;
        GraphTraversalSource b = this.g.withoutStrategies(new Class[]{TranslationStrategy.class});
        assert (a.getStrategies().getStrategy(TranslationStrategy.class).isPresent());
        assert (!b.getStrategies().getStrategy(TranslationStrategy.class).isPresent());
        Assert.assertEquals((long)6L, (long)((Long)a.V(new Object[0]).out().count().next()));
        Assert.assertEquals((long)6L, (long)((Long)b.V(new Object[0]).out().count().next()));
        assert (a.getStrategies().getStrategy(TranslationStrategy.class).isPresent());
        assert (!b.getStrategies().getStrategy(TranslationStrategy.class).isPresent());
        Assert.assertEquals((long)2L, (long)((Long)a.V(new Object[0]).repeat((Traversal)__.out()).times(2).count().next()));
        Assert.assertEquals((long)2L, (long)((Long)b.V(new Object[0]).repeat((Traversal)__.out()).times(2).count().next()));
        assert (a.getStrategies().getStrategy(TranslationStrategy.class).isPresent());
        assert (!b.getStrategies().getStrategy(TranslationStrategy.class).isPresent());
    }
}

