/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.computer.search.path.ShortestPathTestHelper;
import org.apache.tinkerpop.gremlin.process.computer.search.path.ShortestPathVertexProgramTest;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ShortestPath;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class ShortestPathTest
extends AbstractGremlinProcessTest {
    private ShortestPathTestHelper helper;

    @Before
    public void initializeHelper() throws Exception {
        this.helper = new ShortestPathTestHelper(this, this.g);
    }

    public abstract Traversal<Vertex, Path> get_g_V_shortestPath();

    public abstract Traversal<Vertex, Path> get_g_V_both_dedup_shortestPath();

    public abstract Traversal<Vertex, Path> get_g_V_shortestPath_edgesIncluded();

    public abstract Traversal<Vertex, Path> get_g_V_shortestPath_directionXINX();

    public abstract Traversal<Vertex, Path> get_g_V_shortestPath_edgesXoutEX();

    public abstract Traversal<Vertex, Path> get_g_V_shortestPath_edgesIncluded_edgesXoutEX();

    public abstract Traversal<Vertex, Path> get_g_V_hasXname_markoX_shortestPath();

    public abstract Traversal<Vertex, Path> get_g_V_shortestPath_targetXhasXname_markoXX();

    public abstract Traversal<Vertex, Path> get_g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX();

    public abstract Traversal<Vertex, Path> get_g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX();

    public abstract Traversal<Vertex, Path> get_g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX();

    public abstract Traversal<Vertex, Path> get_g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX();

    public abstract Traversal<Vertex, Path> get_g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX();

    public abstract Traversal<Vertex, Path> get_g_V_hasXname_markoX_shortestPath_maxDistanceX1X();

    public abstract Traversal<Vertex, Path> get_g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_shortestPath() {
        Traversal<Vertex, Path> traversal = this.get_g_V_shortestPath();
        this.printTraversalForm(traversal);
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).map(this.helper::makePath).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_dedup_shortestPath() {
        Traversal<Vertex, Path> traversal = this.get_g_V_both_dedup_shortestPath();
        this.printTraversalForm(traversal);
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).map(this.helper::makePath).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_shortestPath_edgesIncluded() {
        Traversal<Vertex, Path> traversal = this.get_g_V_shortestPath_edgesIncluded();
        this.printTraversalForm(traversal);
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).map(p -> this.helper.makePath(true, (String)p)).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_shortestPath_directionXINX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_shortestPath_directionXINX();
        this.printTraversalForm(traversal);
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && ((String[])p).length == 1 || p[0].equals("vadas") && Arrays.asList("marko", "vadas").contains(p[((String[])p).length - 1]) || p[0].equals("lop") && Arrays.asList("marko", "lop", "josh", "peter").contains(p[((String[])p).length - 1]) || p[0].equals("josh") && Arrays.asList("marko", "josh").contains(p[((String[])p).length - 1]) || p[0].equals("ripple") && Arrays.asList("marko", "josh", "ripple").contains(p[((String[])p).length - 1]) || p[0].equals("peter") && ((String[])p).length == 1).map(this.helper::makePath).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_shortestPath_edgesXoutEX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_shortestPath_edgesXoutEX();
        this.printTraversalForm(traversal);
        this.checkOutDirectedPaths(false, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_shortestPath_edgesIncluded_edgesXoutEX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_shortestPath_edgesIncluded_edgesXoutEX();
        this.printTraversalForm(traversal);
        this.checkOutDirectedPaths(true, traversal);
    }

    private void checkOutDirectedPaths(boolean includeEdges, Traversal<Vertex, Path> traversal) {
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && !p[((String[])p).length - 1].equals("peter") || p[0].equals("vadas") && ((String[])p).length == 1 || p[0].equals("lop") && ((String[])p).length == 1 || p[0].equals("josh") && Arrays.asList("lop", "josh", "ripple").contains(p[((String[])p).length - 1]) || p[0].equals("ripple") && ((String[])p).length == 1 || p[0].equals("peter") && Arrays.asList("lop", "peter").contains(p[((String[])p).length - 1])).map(names -> this.helper.makePath(includeEdges, (String)names)).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_markoX_shortestPath() {
        Traversal<Vertex, Path> traversal = this.get_g_V_hasXname_markoX_shortestPath();
        this.printTraversalForm(traversal);
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko")).map(this.helper::makePath).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_shortestPath_targetXhasXname_markoXX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_shortestPath_targetXhasXname_markoXX();
        this.printTraversalForm(traversal);
        this.checkPathsToMarko(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX();
        this.printTraversalForm(traversal);
        this.checkPathsToMarko(traversal);
    }

    private void checkPathsToMarko(Traversal<Vertex, Path> traversal) {
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).filter(p -> p[((String[])p).length - 1].equals("marko")).map(this.helper::makePath).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX();
        this.printTraversalForm(traversal);
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && Arrays.asList("lop", "ripple").contains(p[((String[])p).length - 1])).map(this.helper::makePath).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((Object)this.helper.makePath("marko", "lop", "josh"), (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX();
        this.printTraversalForm(traversal);
        List<Path> expected = Arrays.asList(this.helper.makePath("daniel", "gremlin", "stephen"), this.helper.makePath("daniel", "tinkergraph", "stephen"));
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX();
        this.printTraversalForm(traversal);
        List<Path> expected = Arrays.asList(this.helper.makePath("MIGHT AS WELL", "DRUMS", "MAYBE YOU KNOW HOW I FEEL"), this.helper.makePath("MIGHT AS WELL", "SHIP OF FOOLS", "MAYBE YOU KNOW HOW I FEEL"));
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_markoX_shortestPath_maxDistanceX1X() {
        Traversal<Vertex, Path> traversal = this.get_g_V_hasXname_markoX_shortestPath_maxDistanceX1X();
        this.printTraversalForm(traversal);
        List expected = Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && ((String[])p).length <= 2).map(this.helper::makePath).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X() {
        Traversal<Vertex, Path> traversal = this.get_g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X();
        this.printTraversalForm(traversal);
        List expected = Stream.concat(Arrays.stream(ShortestPathVertexProgramTest.ALL_SHORTEST_PATHS).filter(p -> p[0].equals("vadas") && Arrays.asList("vadas", "marko", "lop", "peter").contains(p[((String[])p).length - 1])).map(this.helper::makePath), Stream.of(this.helper.makePath("vadas", "marko", "lop", "josh"))).collect(Collectors.toList());
        ShortestPathTest.checkResults(expected, traversal);
    }

    public static class Traversals
    extends ShortestPathTest {
        @Override
        public Traversal<Vertex, Path> get_g_V_shortestPath() {
            return this.g.V(new Object[0]).shortestPath();
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_both_dedup_shortestPath() {
            return this.g.V(new Object[0]).both().dedup(new String[0]).shortestPath();
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_shortestPath_edgesIncluded() {
            return this.g.V(new Object[0]).shortestPath().with(ShortestPath.includeEdges);
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_shortestPath_directionXINX() {
            return this.g.V(new Object[0]).shortestPath().with(ShortestPath.edges, (Object)Direction.IN);
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_shortestPath_edgesXoutEX() {
            return this.g.V(new Object[0]).shortestPath().with(ShortestPath.edges, (Object)__.outE());
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_shortestPath_edgesIncluded_edgesXoutEX() {
            return this.g.V(new Object[0]).shortestPath().with(ShortestPath.includeEdges).with(ShortestPath.edges, (Object)__.outE());
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_hasXname_markoX_shortestPath() {
            return this.g.V(new Object[0]).has("name", (Object)"marko").shortestPath();
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_shortestPath_targetXhasXname_markoXX() {
            return this.g.V(new Object[0]).shortestPath().with(ShortestPath.target, (Object)__.has((String)"name", (Object)"marko"));
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX() {
            return this.g.V(new Object[0]).shortestPath().with(ShortestPath.target, (Object)__.values((String[])new String[]{"name"}).is((Object)"marko"));
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX() {
            return this.g.V(new Object[0]).has("name", (Object)"marko").shortestPath().with(ShortestPath.target, (Object)__.hasLabel((String)"software", (String[])new String[0]));
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX() {
            return this.g.V(new Object[0]).has("name", (Object)"marko").shortestPath().with(ShortestPath.target, (Object)__.has((String)"name", (Object)"josh")).with(ShortestPath.distance, (Object)"weight");
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX() {
            return this.g.V(new Object[0]).has("name", (Object)"daniel").shortestPath().with(ShortestPath.target, (Object)__.has((String)"name", (Object)"stephen")).with(ShortestPath.edges, (Object)__.bothE((String[])new String[]{"uses"}));
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX() {
            return this.g.V(new Object[0]).has("song", "name", (Object)"MIGHT AS WELL").shortestPath().with(ShortestPath.target, (Object)__.has((String)"song", (String)"name", (Object)"MAYBE YOU KNOW HOW I FEEL")).with(ShortestPath.edges, (Object)__.outE((String[])new String[]{"followedBy"})).with(ShortestPath.distance, (Object)"weight");
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_hasXname_markoX_shortestPath_maxDistanceX1X() {
            return this.g.V(new Object[0]).has("name", (Object)"marko").shortestPath().with(ShortestPath.maxDistance, (Object)1);
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X() {
            return this.g.V(new Object[0]).has("name", (Object)"vadas").shortestPath().with(ShortestPath.distance, (Object)"weight").with(ShortestPath.maxDistance, (Object)1.3);
        }
    }
}

