/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.function.ArrayListSupplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class LambdaStepTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Object> get_g_V_branchXlabel_eq_person__a_bX_optionXa__ageX_optionXb__langX_optionXb__nameX();

    public abstract Traversal<Vertex, String> get_g_V_chooseXlabel_eqXpersonX__outXknowsX__inXcreatedXX_name();

    public abstract Traversal<Vertex, Vertex> get_g_V_filterXfalseX();

    public abstract Traversal<Vertex, Vertex> get_g_V_filterXtrueX();

    public abstract Traversal<Vertex, Vertex> get_g_V_filterXlang_eq_javaX();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_filterXage_gt_30X(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_filterXage_gt_30X(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_filterXname_startsWith_m_OR_name_startsWith_pX();

    public abstract Traversal<Edge, Edge> get_g_E_filterXfalseX();

    public abstract Traversal<Edge, Edge> get_g_E_filterXtrueX();

    public abstract Traversal<Vertex, String> get_g_V_valuesXnameX_flatMapXsplitXaX();

    public abstract Traversal<Vertex, Map<String, Long>> get_g_V_group_byXname_substring_1X_byXconstantX1XX();

    public abstract Traversal<Vertex, Map<String, Long>> get_g_V_groupXaX_byXname_substring_1X_byXconstantX1XX_capXaX();

    public abstract Traversal<Vertex, Path> get_g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path(Object var1);

    public abstract Traversal<Vertex, String> get_g_VX1X_mapXnameX(Object var1);

    public abstract Traversal<Vertex, Integer> get_g_VX1X_outE_label_mapXlengthX(Object var1);

    public abstract Traversal<Vertex, Integer> get_g_VX1X_out_mapXnameX_mapXlengthX(Object var1);

    public abstract Traversal<Vertex, String> get_g_withPath_V_asXaX_out_mapXa_nameX();

    public abstract Traversal<Vertex, String> get_g_withPath_V_asXaX_out_out_mapXa_name_it_nameX();

    public abstract Traversal<Vertex, String> get_g_V_hasLabelXpersonX_order_byXvalueXageX_descX_name();

    public abstract Traversal<Vertex, Map<Integer, Integer>> get_g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_descX_byXkeys_ascX(Object var1);

    public abstract Traversal<Vertex, Map<String, Long>> get_g_V_repeatXbothX_untilXname_eq_marko_or_loops_gt_1X_groupCount_byXnameX();

    public abstract Traversal<Vertex, String> get_g_VX1X_sideEffectXstore_aX_name(Object var1);

    public abstract Traversal<Vertex, String> get_g_VX1X_out_sideEffectXincr_cX_name(Object var1);

    public abstract Traversal<Vertex, String> get_g_VX1X_out_sideEffectXX_name(Object var1);

    public abstract Traversal<Vertex, Map<String, Long>> get_g_withSideEffectXa__linkedhashmapX_V_out_groupCountXaX_byXlabelX_out_out_capXaX();

    public abstract Traversal<Vertex, Map<String, Long>> get_g_withSideEffectsXa__linkedhashmapX_withSideEffectXb__arraylist__addAllX_withSideEffectXc__arrayList__addAllX_V_groupXaX_byXlabelX_byXcountX_sideEffectXb__1_2_3X_out_out_out_sideEffectXc__bob_danielX_capXaX();

    public abstract Traversal<Vertex, Integer> get_g_withSideEffectXa_0_sumX_V_out_sideEffectXsideEffectsXa_bulkXX_capXaX();

    public abstract Traversal<Vertex, Integer> get_g_withSideEffectXa_0X_V_out_sideEffectXsideEffectsXa_1XX_capXaX();

    public abstract Traversal<Vertex, String> get_g_withSideEffectXk_nameX_V_order_byXvalueMap_selectXkX_unfoldX_name();

    public abstract Traversal<Vertex, String> get_g_V_valueMap_unfold_mapXkeyX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_branchXlabel_eq_person__a_bX_optionXa__ageX_optionXb__langX_optionXb__nameX() {
        Traversal<Vertex, Object> traversal = this.get_g_V_branchXlabel_eq_person__a_bX_optionXa__ageX_optionXb__langX_optionXb__nameX();
        this.printTraversalForm(traversal);
        LambdaStepTest.checkResults(Arrays.asList("java", "java", "lop", "ripple", 29, 27, 32, 35), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_chooseXlabel_eqXpersonX__outXknowsX__inXcreatedXX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_chooseXlabel_eqXpersonX__outXknowsX__inXcreatedXX_name();
        this.printTraversalForm(traversal);
        LambdaStepTest.checkResults(Arrays.asList("josh", "vadas", "josh", "josh", "marko", "peter"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_repeatXbothX_untilXname_eq_marko_or_loops_gt_1X_groupCount_byXnameX() {
        Traversal<Vertex, Map<String, Long>> traversal = this.get_g_V_repeatXbothX_untilXname_eq_marko_or_loops_gt_1X_groupCount_byXnameX();
        this.printTraversalForm(traversal);
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)5L, (long)map.size());
        Assert.assertEquals((long)3L, (long)((Long)map.get("ripple")));
        Assert.assertEquals((long)3L, (long)((Long)map.get("vadas")));
        Assert.assertEquals((long)4L, (long)((Long)map.get("josh")));
        Assert.assertEquals((long)10L, (long)((Long)map.get("lop")));
        Assert.assertEquals((long)4L, (long)((Long)map.get("marko")));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_filterXfalseX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_filterXfalseX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_filterXtrueX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_filterXtrueX();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            vertices.add((Vertex)traversal.next());
        }
        Assert.assertEquals((long)6L, (long)counter);
        Assert.assertEquals((long)6L, (long)vertices.size());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_filterXlang_eq_javaX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_filterXlang_eq_javaX();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("ripple") || vertex.value("name").equals("lop") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertEquals((long)2L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_filterXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_filterXage_gt_30X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX2X_filterXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_filterXage_gt_30X(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((Object)32, (Object)((Vertex)traversal.next()).value("age"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_filterXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_filterXage_gt_30X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)32, (Object)((Vertex)traversal.next()).value("age"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_filterXname_startsWith_m_OR_name_startsWith_pX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_filterXname_startsWith_m_OR_name_startsWith_pX();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("marko") || vertex.value("name").equals("peter") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)counter, (long)2L);
        Assert.assertEquals((long)vertices.size(), (long)2L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_filterXfalseX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_filterXfalseX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_filterXtrueX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_filterXtrueX();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Edge> edges = new HashSet<Edge>();
        while (traversal.hasNext()) {
            ++counter;
            edges.add((Edge)traversal.next());
        }
        Assert.assertEquals((long)6L, (long)counter);
        Assert.assertEquals((long)6L, (long)edges.size());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_mapXnameX() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_mapXnameX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)traversal.next(), (Object)"marko");
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outE_label_mapXlengthX() {
        Traversal<Vertex, Integer> traversal = this.get_g_VX1X_outE_label_mapXlengthX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        List lengths = traversal.toList();
        Assert.assertTrue((boolean)lengths.contains("created".length()));
        Assert.assertTrue((boolean)lengths.contains("knows".length()));
        Assert.assertEquals((long)lengths.size(), (long)3L);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_mapXnameX_mapXlengthX() {
        Traversal<Vertex, Integer> traversal = this.get_g_VX1X_out_mapXnameX_mapXlengthX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        List lengths = traversal.toList();
        Assert.assertTrue((boolean)lengths.contains("josh".length()));
        Assert.assertTrue((boolean)lengths.contains("vadas".length()));
        Assert.assertTrue((boolean)lengths.contains("lop".length()));
        Assert.assertEquals((long)lengths.size(), (long)3L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_withPath_V_asXaX_out_mapXa_nameX() {
        int marko = 0;
        int peter = 0;
        int josh = 0;
        int other = 0;
        Traversal<Vertex, String> traversal = this.get_g_withPath_V_asXaX_out_mapXa_nameX();
        this.printTraversalForm(traversal);
        while (traversal.hasNext()) {
            String name = (String)traversal.next();
            if (name.equals("marko")) {
                ++marko;
                continue;
            }
            if (name.equals("peter")) {
                ++peter;
                continue;
            }
            if (name.equals("josh")) {
                ++josh;
                continue;
            }
            ++other;
        }
        Assert.assertEquals((long)marko, (long)3L);
        Assert.assertEquals((long)josh, (long)2L);
        Assert.assertEquals((long)peter, (long)1L);
        Assert.assertEquals((long)other, (long)0L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_withPath_V_asXaX_out_out_mapXa_name_it_nameX() {
        Traversal<Vertex, String> traversal = this.get_g_withPath_V_asXaX_out_out_mapXa_name_it_nameX();
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String doubleName = (String)traversal.next();
            Assert.assertTrue(("markoripple".equals(doubleName) || "markolop".equals(doubleName) ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_order_byXvalueXageX_descX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_hasLabelXpersonX_order_byXvalueXageX_descX_name();
        this.printTraversalForm(traversal);
        LambdaStepTest.checkOrderedResults(Arrays.asList("peter", "josh", "marko", "vadas"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_descX_byXkeys_ascX() {
        Traversal<Vertex, Map<Integer, Integer>> traversal = this.get_g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_descX_byXkeys_ascX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)4L, (long)map.size());
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = iterator.next();
        Assert.assertEquals((long)3L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((long)87L, (long)((Integer)entry.getValue()).intValue());
        entry = iterator.next();
        Assert.assertEquals((long)2L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((long)58L, (long)((Integer)entry.getValue()).intValue());
        entry = iterator.next();
        Assert.assertEquals((long)1L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((long)29L, (long)((Integer)entry.getValue()).intValue());
        entry = iterator.next();
        Assert.assertEquals((long)4L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((long)29L, (long)((Integer)entry.getValue()).intValue());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_valueMap_unfold_mapXkeyX() {
        Traversal<Vertex, String> traversal = this.get_g_V_valueMap_unfold_mapXkeyX();
        this.printTraversalForm(traversal);
        int counter = 0;
        int ageCounter = 0;
        int nameCounter = 0;
        int langCounter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String key = (String)traversal.next();
            if (key.equals("name")) {
                ++nameCounter;
                continue;
            }
            if (key.equals("age")) {
                ++ageCounter;
                continue;
            }
            if (key.equals("lang")) {
                ++langCounter;
                continue;
            }
            Assert.fail((String)("The provided key is not known: " + key));
        }
        Assert.assertEquals((long)12L, (long)counter);
        Assert.assertEquals((long)4L, (long)ageCounter);
        Assert.assertEquals((long)2L, (long)langCounter);
        Assert.assertEquals((long)6L, (long)nameCounter);
        Assert.assertEquals((long)counter, (long)(ageCounter + langCounter + nameCounter));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_group_byXname_substring_1X_byXconstantX1XX() {
        Traversal<Vertex, Map<String, Long>> traversal = this.get_g_V_group_byXname_substring_1X_byXconstantX1XX();
        this.printTraversalForm(traversal);
        LambdaStepTest.checkMap(new HashMap<String, Long>(){
            {
                this.put("m", 1L);
                this.put("v", 1L);
                this.put("p", 1L);
                this.put("l", 1L);
                this.put("r", 1L);
                this.put("j", 1L);
            }
        }, (Map)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
        LambdaStepTest.checkSideEffects(traversal.asAdmin().getSideEffects(), new Object[0]);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_groupXaX_byXname_substring_1X_byXconstantX1XX_capXaX() {
        Traversal<Vertex, Map<String, Long>> traversal = this.get_g_V_groupXaX_byXname_substring_1X_byXconstantX1XX_capXaX();
        this.printTraversalForm(traversal);
        LambdaStepTest.checkMap(new HashMap<String, Long>(){
            {
                this.put("m", 1L);
                this.put("v", 1L);
                this.put("p", 1L);
                this.put("l", 1L);
                this.put("r", 1L);
                this.put("j", 1L);
            }
        }, (Map)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
        LambdaStepTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "a", HashMap.class);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path() {
        Traversal<Vertex, Path> traversal = this.get_g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Path path = (Path)traversal.next();
            if (path.get("a").equals("daniel")) {
                Assert.assertEquals((long)2L, (long)path.size());
                Assert.assertEquals((long)6L, (long)((Integer)path.get(1)).intValue());
                continue;
            }
            Assert.assertEquals((long)4L, (long)path.size());
            Assert.assertEquals((long)((String)path.get("a")).length(), (long)((Integer)path.get(3)).intValue());
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_VX1X_sideEffectXstore_aX_name() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_sideEffectXstore_aX_name(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)traversal.next(), (Object)"marko");
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)((Vertex)((List)traversal.asAdmin().getSideEffects().get("a")).get(0)).id());
        LambdaStepTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "a", ArrayList.class);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_VX1X_out_sideEffectXincr_cX_name() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_out_sideEffectXincr_cX_name(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        this.assert_g_v1_out_sideEffectXincr_cX_valueXnameX((Iterator<String>)traversal);
        Assert.assertEquals((Object)new Integer(3), ((List)traversal.asAdmin().getSideEffects().get("c")).get(0));
        LambdaStepTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "c", ArrayList.class);
    }

    private void assert_g_v1_out_sideEffectXincr_cX_valueXnameX(Iterator<String> traversal) {
        ArrayList<String> names = new ArrayList<String>();
        while (traversal.hasNext()) {
            names.add(traversal.next());
        }
        Assert.assertEquals((long)3L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("lop"));
        Assert.assertTrue((boolean)names.contains("vadas"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_sideEffectXX_name() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_out_sideEffectXX_name(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        this.assert_g_v1_out_sideEffectXincr_cX_valueXnameX((Iterator<String>)traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSideEffectXa__linkedhashmapX_V_out_groupCountXaX_byXlabelX_out_out_capXaX() {
        Traversal<Vertex, Map<String, Long>> traversal = this.get_g_withSideEffectXa__linkedhashmapX_V_out_groupCountXaX_byXlabelX_out_out_capXaX();
        this.printTraversalForm(traversal);
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)4L, (long)((Long)map.get("software")));
        Assert.assertEquals((long)2L, (long)((Long)map.get("person")));
        TraversalSideEffects sideEffects = traversal.asAdmin().getSideEffects();
        map = (Map)sideEffects.get("a");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)4L, (long)((Long)map.get("software")));
        Assert.assertEquals((long)2L, (long)((Long)map.get("person")));
        Assert.assertEquals((long)1L, (long)sideEffects.keys().size());
        Assert.assertTrue((boolean)sideEffects.keys().contains("a"));
        Assert.assertTrue((boolean)sideEffects.exists("a"));
        Assert.assertTrue((boolean)(sideEffects.get("a") instanceof LinkedHashMap));
        LambdaStepTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "a", LinkedHashMap.class);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSideEffectsXa__linkedhashmapX_withSideEffectXb__arraylist__addAllX_withSideEffectXc__arrayList__addAllX_V_groupXaX_byXlabelX_byXcountX_sideEffectXb__1_2_3X_out_out_out_sideEffectXc__bob_danielX_capXaX() {
        Traversal<Vertex, Map<String, Long>> traversal = this.get_g_withSideEffectsXa__linkedhashmapX_withSideEffectXb__arraylist__addAllX_withSideEffectXc__arrayList__addAllX_V_groupXaX_byXlabelX_byXcountX_sideEffectXb__1_2_3X_out_out_out_sideEffectXc__bob_danielX_capXaX();
        this.printTraversalForm(traversal);
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)2L, (long)((Long)map.get("software")));
        Assert.assertEquals((long)4L, (long)((Long)map.get("person")));
        TraversalSideEffects sideEffects = traversal.asAdmin().getSideEffects();
        map = (Map)sideEffects.get("a");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)2L, (long)((Long)map.get("software")));
        Assert.assertEquals((long)4L, (long)((Long)map.get("person")));
        Assert.assertEquals((long)3L, (long)sideEffects.keys().size());
        Assert.assertTrue((boolean)sideEffects.keys().contains("a"));
        Assert.assertTrue((boolean)sideEffects.exists("a"));
        Assert.assertTrue((boolean)(sideEffects.get("a") instanceof LinkedHashMap));
        Assert.assertTrue((boolean)sideEffects.keys().contains("b"));
        Assert.assertTrue((boolean)sideEffects.exists("b"));
        Assert.assertTrue((boolean)(sideEffects.get("b") instanceof ArrayList));
        Assert.assertEquals((long)18L, (long)((List)sideEffects.get("b")).size());
        Assert.assertEquals((long)6L, (long)((List)sideEffects.get("b")).stream().filter(t -> t == 1).count());
        Assert.assertEquals((long)6L, (long)((List)sideEffects.get("b")).stream().filter(t -> t == 2).count());
        Assert.assertEquals((long)6L, (long)((List)sideEffects.get("b")).stream().filter(t -> t == 3).count());
        Assert.assertTrue((boolean)sideEffects.keys().contains("c"));
        Assert.assertTrue((boolean)sideEffects.exists("c"));
        Assert.assertTrue((boolean)(sideEffects.get("c") instanceof ArrayList));
        Assert.assertEquals((long)0L, (long)((List)sideEffects.get("c")).size());
        LambdaStepTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "a", LinkedHashMap.class, "b", ArrayList.class, "c", ArrayList.class);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSideEffectXa_0_sumX_V_out_sideEffectXsideEffectsXa_bulkXX_capXaX() {
        Traversal<Vertex, Integer> traversal = this.get_g_withSideEffectXa_0_sumX_V_out_sideEffectXsideEffectsXa_bulkXX_capXaX();
        Assert.assertEquals((long)6L, (long)((Integer)traversal.next()).intValue());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)6L, (long)((Integer)traversal.asAdmin().getSideEffects().get("a")).intValue());
        Assert.assertEquals((long)1L, (long)traversal.asAdmin().getSideEffects().keys().size());
        LambdaStepTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "a", Integer.class);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSideEffectXa_0X_V_out_sideEffectXsideEffectsXa_1XX_capXaX() {
        Traversal<Vertex, Integer> traversal = this.get_g_withSideEffectXa_0X_V_out_sideEffectXsideEffectsXa_1XX_capXaX();
        Assert.assertEquals((long)1L, (long)((Integer)traversal.next()).intValue());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)1L, (long)((Integer)traversal.asAdmin().getSideEffects().get("a")).intValue());
        Assert.assertEquals((long)1L, (long)traversal.asAdmin().getSideEffects().keys().size());
        LambdaStepTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "a", Integer.class);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_withSideEffectXk_nameX_V_order_byXvalueMap_selectXkX_unfoldX_name() {
        Traversal<Vertex, String> traversal = this.get_g_withSideEffectXk_nameX_V_order_byXvalueMap_selectXkX_unfoldX_name();
        LambdaStepTest.checkOrderedResults(Arrays.asList("josh", "lop", "marko", "peter", "ripple", "vadas"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_valuesXnameX_flatMapXsplitXaX() {
        Traversal<Vertex, String> traversal = this.get_g_V_valuesXnameX_flatMapXsplitXaX();
        LambdaStepTest.checkResults(Arrays.asList("josh", "lop", "rko", "peter", "ripple", "v", "d", "s", "m"), traversal);
    }

    public static class LinkedHashMapSupplier
    implements Supplier<LinkedHashMap> {
        @Override
        public LinkedHashMap get() {
            return new LinkedHashMap();
        }
    }

    public static class Traversals
    extends LambdaStepTest {
        @Override
        public Traversal<Vertex, Object> get_g_V_branchXlabel_eq_person__a_bX_optionXa__ageX_optionXb__langX_optionXb__nameX() {
            return this.g.V(new Object[0]).branch(v -> ((Vertex)v.get()).label().equals("person") ? "a" : "b").option((Object)"a", (Traversal)__.values((String[])new String[]{"age"})).option((Object)"b", (Traversal)__.values((String[])new String[]{"lang"})).option((Object)"b", (Traversal)__.values((String[])new String[]{"name"}));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_chooseXlabel_eqXpersonX__outXknowsX__inXcreatedXX_name() {
            return this.g.V(new Object[0]).choose(v -> v.label().equals("person"), (Traversal)__.out((String[])new String[]{"knows"}), (Traversal)__.in((String[])new String[]{"created"})).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Map<String, Long>> get_g_V_repeatXbothX_untilXname_eq_marko_or_loops_gt_1X_groupCount_byXnameX() {
            return this.g.V(new Object[0]).repeat((Traversal)__.both()).until(t -> ((Vertex)t.get()).value("name").equals("lop") || t.loops() > 1).groupCount().by("name");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXfalseX() {
            return this.g.V(new Object[0]).filter(v -> false);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXtrueX() {
            return this.g.V(new Object[0]).filter(v -> true);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXlang_eq_javaX() {
            return this.g.V(new Object[0]).filter(v -> ((String)((Vertex)v.get()).property("lang").orElse((Object)"none")).equals("java"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_filterXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).filter(v -> (Integer)((Vertex)v.get()).property("age").orElse((Object)0) > 30);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_filterXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out().filter(v -> (Integer)((Vertex)v.get()).property("age").orElse((Object)0) > 30);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXname_startsWith_m_OR_name_startsWith_pX() {
            return this.g.V(new Object[0]).filter(v -> {
                String name = (String)((Vertex)v.get()).value("name");
                return name.startsWith("m") || name.startsWith("p");
            });
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_filterXfalseX() {
            return this.g.E(new Object[0]).filter(e -> false);
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_filterXtrueX() {
            return this.g.E(new Object[0]).filter(e -> true);
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1X_mapXnameX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).map(v -> (String)((Vertex)v.get()).value("name"));
        }

        @Override
        public Traversal<Vertex, Integer> get_g_VX1X_outE_label_mapXlengthX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE().label().map(l -> ((String)l.get()).length());
        }

        @Override
        public Traversal<Vertex, Integer> get_g_VX1X_out_mapXnameX_mapXlengthX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out().map(v -> ((Vertex)v.get()).value("name")).map(n -> n.get().toString().length());
        }

        @Override
        public Traversal<Vertex, String> get_g_withPath_V_asXaX_out_mapXa_nameX() {
            return this.g.withPath().V(new Object[0]).as("a", new String[0]).out().map(v -> (String)((Vertex)v.path("a")).value("name"));
        }

        @Override
        public Traversal<Vertex, String> get_g_withPath_V_asXaX_out_out_mapXa_name_it_nameX() {
            return this.g.withPath().V(new Object[0]).as("a", new String[0]).out().out().map(v -> (String)((Vertex)v.path("a")).value("name") + (String)((Vertex)v.get()).value("name"));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_hasLabelXpersonX_order_byXvalueXageX_descX_name() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).order().by(v -> v.value("age"), (Comparator)Order.desc).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Map<Integer, Integer>> get_g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_descX_byXkeys_ascX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).hasLabel("person", new String[0]).map(v -> {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                map.put(1, (Integer)((Vertex)v.get()).value("age"));
                map.put(2, (Integer)((Vertex)v.get()).value("age") * 2);
                map.put(3, (Integer)((Vertex)v.get()).value("age") * 3);
                map.put(4, (Integer)((Vertex)v.get()).value("age"));
                return map;
            }).order(Scope.local).by((Function)Column.values, (Comparator)Order.desc).by((Function)Column.keys, (Comparator)Order.asc);
        }

        @Override
        public Traversal<Vertex, String> get_g_V_valueMap_unfold_mapXkeyX() {
            return this.g.V(new Object[0]).valueMap(new String[0]).unfold().map(m -> (String)((Map.Entry)m.get()).getKey());
        }

        @Override
        public Traversal<Vertex, Map<String, Long>> get_g_V_group_byXname_substring_1X_byXconstantX1XX() {
            return this.g.V(new Object[0]).group().by(v -> ((String)v.value("name")).substring(0, 1)).by((Traversal)__.constant((Object)1L));
        }

        @Override
        public Traversal<Vertex, Map<String, Long>> get_g_V_groupXaX_byXname_substring_1X_byXconstantX1XX_capXaX() {
            return this.g.V(new Object[0]).group("a").by(v -> ((String)v.value("name")).substring(0, 1)).by((Traversal)__.constant((Object)1L)).cap("a", new String[0]);
        }

        @Override
        public Traversal<Vertex, Path> get_g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out().values(new String[]{"name"}).inject((Object[])new String[]{"daniel"}).as("a", new String[0]).map(t -> ((String)t.get()).length()).path();
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1X_sideEffectXstore_aX_name(Object v1Id) {
            return this.g.withSideEffect("a", ArrayList::new).V(new Object[]{v1Id}).sideEffect(traverser -> {
                ((List)traverser.sideEffects("a")).clear();
                ((List)traverser.sideEffects("a")).add((Vertex)traverser.get());
            }).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1X_out_sideEffectXincr_cX_name(Object v1Id) {
            return this.g.withSideEffect("c", () -> {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(0);
                return list;
            }).V(new Object[]{v1Id}).out().sideEffect(traverser -> {
                Integer temp = (Integer)((List)traverser.sideEffects("c")).get(0);
                ((List)traverser.sideEffects("c")).clear();
                ((List)traverser.sideEffects("c")).add(temp + 1);
            }).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1X_out_sideEffectXX_name(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out().sideEffect(traverser -> {}).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Map<String, Long>> get_g_withSideEffectXa__linkedhashmapX_V_out_groupCountXaX_byXlabelX_out_out_capXaX() {
            return this.g.withSideEffect("a", (Supplier)new LinkedHashMapSupplier()).V(new Object[0]).out().groupCount("a").by(T.label).out().out().cap("a", new String[0]);
        }

        @Override
        public Traversal<Vertex, Map<String, Long>> get_g_withSideEffectsXa__linkedhashmapX_withSideEffectXb__arraylist__addAllX_withSideEffectXc__arrayList__addAllX_V_groupXaX_byXlabelX_byXcountX_sideEffectXb__1_2_3X_out_out_out_sideEffectXc__bob_danielX_capXaX() {
            return this.g.withSideEffect("a", (Supplier)new LinkedHashMapSupplier()).withSideEffect("b", (Object)ArrayListSupplier.instance(), (BinaryOperator)Operator.addAll).withSideEffect("c", (Object)ArrayListSupplier.instance(), (BinaryOperator)Operator.addAll).V(new Object[0]).group("a").by(T.label).by((Traversal)__.count()).sideEffect(t -> t.sideEffects("b", new LinkedList<Integer>(Arrays.asList(1, 2, 3)))).out().out().out().sideEffect(t -> t.sideEffects("c", new LinkedList<String>(Arrays.asList("bob", "daniel")))).cap("a", new String[0]);
        }

        @Override
        public Traversal<Vertex, Integer> get_g_withSideEffectXa_0_sumX_V_out_sideEffectXsideEffectsXa_bulkXX_capXaX() {
            return this.g.withSideEffect("a", (Object)0, (BinaryOperator)Operator.sum).V(new Object[0]).out().sideEffect(t -> t.sideEffects("a", (Object)((int)t.bulk()))).cap("a", new String[0]);
        }

        @Override
        public Traversal<Vertex, Integer> get_g_withSideEffectXa_0X_V_out_sideEffectXsideEffectsXa_1XX_capXaX() {
            return this.g.withSideEffect("a", (Object)0).V(new Object[0]).out().sideEffect(t -> t.sideEffects("a", (Object)1)).cap("a", new String[0]);
        }

        @Override
        public Traversal<Vertex, String> get_g_withSideEffectXk_nameX_V_order_byXvalueMap_selectXkX_unfoldX_name() {
            return this.g.withSideEffect("key", (Object)"name").V(new Object[0]).order().by((Traversal)__.valueMap((String[])new String[0]).select((Traversal)__.select((String)"key")).unfold()).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_valuesXnameX_flatMapXsplitXaX() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).flatMap(s -> Stream.of(((String)s.get()).split("a")).iterator());
        }
    }
}

