/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.algorithm.generator;

import java.util.Random;
import org.apache.tinkerpop.gremlin.algorithm.generator.Distribution;

public class PowerLawDistribution
implements Distribution {
    private final double gamma;
    private final double multiplier;

    public PowerLawDistribution(double gamma) {
        this(gamma, 0.0);
    }

    private PowerLawDistribution(double gamma, double multiplier) {
        if (gamma <= 2.0) {
            throw new IllegalArgumentException("Beta must be bigger than 2: " + gamma);
        }
        if (multiplier < 0.0) {
            throw new IllegalArgumentException("Invalid multiplier value: " + multiplier);
        }
        this.gamma = gamma;
        this.multiplier = multiplier;
    }

    @Override
    public Distribution initialize(int invocations, int expectedTotal) {
        double multiplier = (double)expectedTotal / ((this.gamma - 1.0) / (this.gamma - 2.0) * (double)invocations) * 2.0;
        assert (multiplier > 0.0);
        return new PowerLawDistribution(this.gamma, multiplier);
    }

    @Override
    public int nextValue(Random random) {
        if (this.multiplier == 0.0) {
            throw new IllegalStateException("Distribution has not been initialized");
        }
        return PowerLawDistribution.getValue(random, this.multiplier, this.gamma);
    }

    @Override
    public int nextConditionalValue(Random random, int otherValue) {
        return this.nextValue(random);
    }

    public String toString() {
        return "PowerLawDistribution{gamma=" + this.gamma + ", multiplier=" + this.multiplier + "}";
    }

    public static int getValue(Random random, double multiplier, double beta) {
        return (int)Math.round(multiplier * (Math.pow(1.0 / (1.0 - random.nextDouble()), 1.0 / (beta - 1.0)) - 1.0));
    }
}

