/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.structure.io.gryo.VertexByteArrayInputStream;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class IoVertexTest
extends AbstractGremlinTest {
    @Parameterized.Parameter(value=0)
    public String ioType;
    @Parameterized.Parameter(value=1)
    public boolean assertViaDirectEquality;
    @Parameterized.Parameter(value=2)
    public boolean assertEdgesAtSameTimeAsVertex;
    @Parameterized.Parameter(value=3)
    public Function<Graph, GraphReader> readerMaker;
    @Parameterized.Parameter(value=4)
    public Function<Graph, GraphWriter> writerMaker;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"graphson-v1", false, false, g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).reader().create(), g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).writer().create()}, {"graphson-v1-embedded", true, false, g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).reader().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).mapper().typeInfo(TypeInfo.PARTIAL_TYPES).create()).create(), g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).writer().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V1_0))).mapper().typeInfo(TypeInfo.PARTIAL_TYPES).create()).create()}, {"graphson-v2", false, false, g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).reader().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).mapper().typeInfo(TypeInfo.NO_TYPES).create()).create(), g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).writer().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).mapper().typeInfo(TypeInfo.NO_TYPES).create()).create()}, {"graphson-v2-embedded", true, false, g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).reader().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).mapper().typeInfo(TypeInfo.PARTIAL_TYPES).create()).create(), g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).writer().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0))).mapper().typeInfo(TypeInfo.PARTIAL_TYPES).create()).create()}, {"graphson-v3", true, false, g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0))).reader().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0))).mapper().create()).create(), g -> ((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0))).writer().mapper((Mapper)((GraphSONIo)g.io(GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0))).mapper().create()).create()}, {"gryo-v1", true, true, g -> ((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V1_0))).reader().create(), g -> ((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V1_0))).writer().create()}, {"gryo-v3", true, true, g -> ((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V3_0))).reader().create(), g -> ((GryoIo)g.io(GryoIo.build((GryoVersion)GryoVersion.V3_0))).writer().create()});
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithBOTHEdges() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e1 = v2.addEdge("friends", v1, new Object[]{"weight", 0.5});
        Edge e2 = v1.addEdge("friends", v2, new Object[]{"weight", 1.0});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeVertex((OutputStream)os, v1, Direction.BOTH);
            AtomicBoolean calledVertex = new AtomicBoolean(false);
            AtomicBoolean calledEdge1 = new AtomicBoolean(false);
            AtomicBoolean calledEdge2 = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    if (this.assertViaDirectEquality) {
                        TestHelper.validateVertexEquality(v1, detachedVertex, this.assertEdgesAtSameTimeAsVertex);
                    } else {
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                        Assert.assertEquals((Object)"marko", (Object)detachedVertex.value("name"));
                    }
                    calledVertex.set(true);
                    return detachedVertex;
                }, attachable -> {
                    Predicate<Edge> matcher;
                    Edge detachedEdge = (Edge)attachable.get();
                    Predicate<Edge> predicate = matcher = this.assertViaDirectEquality ? e -> detachedEdge.id().equals(e.id()) : e -> ((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id().equals(e.id());
                    if (matcher.test(e1)) {
                        if (this.assertViaDirectEquality) {
                            TestHelper.validateEdgeEquality(e1, detachedEdge);
                        } else {
                            Assert.assertEquals((Object)e1.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                            Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                            Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                            Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                            Assert.assertEquals((Object)e1.label(), (Object)detachedEdge.label());
                            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                            Assert.assertEquals((double)0.5, (double)((Double)detachedEdge.value("weight")), (double)1.0E-6);
                        }
                        calledEdge1.set(true);
                    } else if (matcher.test(e2)) {
                        if (this.assertViaDirectEquality) {
                            TestHelper.validateEdgeEquality(e2, detachedEdge);
                        } else {
                            Assert.assertEquals((Object)e2.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                            Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                            Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                            Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                            Assert.assertEquals((Object)e2.label(), (Object)detachedEdge.label());
                            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                            Assert.assertEquals((double)1.0, (double)((Double)detachedEdge.value("weight")), (double)1.0E-6);
                        }
                        calledEdge2.set(true);
                    } else {
                        Assert.fail((String)"An edge id generated that does not exist");
                    }
                    return null;
                }, Direction.BOTH);
            }
            Assert.assertTrue((boolean)calledVertex.get());
            Assert.assertTrue((boolean)calledEdge1.get());
            Assert.assertTrue((boolean)calledEdge2.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithINEdges() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v2.addEdge("friends", v1, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeVertex((OutputStream)os, v1, Direction.IN);
            AtomicBoolean calledVertex = new AtomicBoolean(false);
            AtomicBoolean calledEdge = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    if (this.assertViaDirectEquality) {
                        TestHelper.validateVertexEquality(v1, detachedVertex, this.assertEdgesAtSameTimeAsVertex);
                    } else {
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                        Assert.assertEquals((Object)"marko", (Object)detachedVertex.value("name"));
                    }
                    calledVertex.set(true);
                    return detachedVertex;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    if (this.assertViaDirectEquality) {
                        TestHelper.validateEdgeEquality(e, detachedEdge);
                    } else {
                        Assert.assertEquals((Object)e.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                        Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                        Assert.assertEquals((Object)v2.label(), (Object)detachedEdge.inVertex().label());
                        Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                        Assert.assertEquals((double)0.5, (double)((Double)detachedEdge.value("weight")), (double)1.0E-6);
                    }
                    calledEdge.set(true);
                    return detachedEdge;
                }, Direction.IN);
            }
            Assert.assertTrue((boolean)calledVertex.get());
            Assert.assertTrue((boolean)calledEdge.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexWithOUTEdges() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", T.label, "person"});
        Vertex v2 = this.graph.addVertex(new Object[]{T.label, "person"});
        Edge e = v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeVertex((OutputStream)os, v1, Direction.OUT);
            AtomicBoolean calledVertex = new AtomicBoolean(false);
            AtomicBoolean calledEdge = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    if (this.assertViaDirectEquality) {
                        TestHelper.validateVertexEquality(v1, detachedVertex, this.assertEdgesAtSameTimeAsVertex);
                    } else {
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                        Assert.assertEquals((Object)"marko", (Object)detachedVertex.value("name"));
                    }
                    calledVertex.set(true);
                    return detachedVertex;
                }, attachable -> {
                    Edge detachedEdge = (Edge)attachable.get();
                    if (this.assertViaDirectEquality) {
                        TestHelper.validateEdgeEquality(e, detachedEdge);
                    } else {
                        Assert.assertEquals((Object)e.id(), (Object)((Edge)this.graph.edges(new Object[]{detachedEdge.id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.outVertex().id().toString()}).next()).id());
                        Assert.assertEquals((Object)v2.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedEdge.inVertex().id().toString()}).next()).id());
                        Assert.assertEquals((Object)v1.label(), (Object)detachedEdge.outVertex().label());
                        Assert.assertEquals((Object)e.label(), (Object)detachedEdge.label());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedEdge.properties(new String[0])));
                        Assert.assertEquals((double)0.5, (double)((Double)detachedEdge.value("weight")), (double)1.0E-6);
                    }
                    calledEdge.set(true);
                    return detachedEdge;
                }, Direction.OUT);
            }
            Assert.assertTrue((boolean)calledVertex.get());
            Assert.assertTrue((boolean)calledEdge.get());
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteVertexNoEdges() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        this.assertVertexToSerialize(v1, true);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedVertexNoEdges() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        this.assertVertexToSerialize((Vertex)DetachedFactory.detach((Vertex)v1, (boolean)true), true);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldReadWriteDetachedVertexAsReferenceNoEdges() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "acl", "rw"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        this.assertVertexToSerialize((Vertex)DetachedFactory.detach((Vertex)v1, (boolean)false), false);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
    public void shouldReadWriteVertexMultiPropsNoEdges() throws Exception {
        Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko", "name", "mark", "acl", "rw"});
        v1.property(VertexProperty.Cardinality.single, "propsSquared", (Object)123, new Object[]{"x", "a", "y", "b"});
        Vertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("friends", v2, new Object[]{"weight", 0.5});
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeVertex((OutputStream)os, v1);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    Assert.assertEquals((Object)v1.id(), (Object)(this.assertViaDirectEquality ? detachedVertex.id() : ((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id()));
                    Assert.assertEquals((Object)v1.label(), (Object)detachedVertex.label());
                    Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                    Assert.assertEquals((Object)"a", (Object)detachedVertex.property("propsSquared").value("x"));
                    Assert.assertEquals((Object)"b", (Object)detachedVertex.property("propsSquared").value("y"));
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[]{"name"})));
                    Assert.assertTrue((boolean)IteratorUtils.stream((Iterator)detachedVertex.properties(new String[]{"name"})).allMatch(p -> p.key().equals("name") && (p.value().equals("marko") || p.value().equals("mark"))));
                    Assert.assertEquals((Object)v1.value("acl"), (Object)detachedVertex.value("acl").toString());
                    called.set(true);
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWriteVerticesNoEdges() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeVertices((OutputStream)os, (Iterator)this.g.V(new Object[0]).has("age", P.gt((Object)30)));
            AtomicInteger called = new AtomicInteger(0);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                Iterator itty = reader.readVertices((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    called.incrementAndGet();
                    return detachedVertex;
                }, null, null);
                Assert.assertNotNull(itty.next());
                Assert.assertNotNull(itty.next());
                Assert.assertFalse((boolean)itty.hasNext());
            }
            Assert.assertEquals((long)2L, (long)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldReadWriteVerticesNoEdgesToGraphSONManual() throws Exception {
        Assume.assumeThat((Object)this.ioType, (Matcher)StringStartsWith.startsWith((String)"graphson"));
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeVertices((OutputStream)os, (Iterator)this.g.V(new Object[0]).has("age", P.gt((Object)30)));
            AtomicInteger called = new AtomicInteger(0);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(os.toByteArray())));){
                String line = br.readLine();
                reader.readVertex((InputStream)new ByteArrayInputStream(line.getBytes()), attachable -> {
                    called.incrementAndGet();
                    return (Vertex)Mockito.mock(Vertex.class);
                });
                line = br.readLine();
                reader.readVertex((InputStream)new ByteArrayInputStream(line.getBytes()), detachedVertex -> {
                    called.incrementAndGet();
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertEquals((long)2L, (long)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldReadWriteVerticesNoEdgesToGryoManual() throws Exception {
        Assume.assumeThat((Object)this.ioType, (Matcher)CoreMatchers.is((Object)"gryo"));
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeVertices((OutputStream)os, (Iterator)this.g.V(new Object[0]).has("age", P.gt((Object)30)));
            AtomicInteger called = new AtomicInteger(0);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (VertexByteArrayInputStream vbais = new VertexByteArrayInputStream((InputStream)new ByteArrayInputStream(os.toByteArray()));){
                byte[] y = vbais.readVertexBytes().toByteArray();
                reader.readVertex((InputStream)new ByteArrayInputStream(y), attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    called.incrementAndGet();
                    return detachedVertex;
                });
                byte[] z = vbais.readVertexBytes().toByteArray();
                reader.readVertex((InputStream)new ByteArrayInputStream(z), attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    called.incrementAndGet();
                    return detachedVertex;
                });
            }
            Assert.assertEquals((long)2L, (long)called.get());
        }
    }

    private void assertVertexToSerialize(Vertex toSerialize, boolean assertProperties) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            writer.writeVertex((OutputStream)os, toSerialize);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertex((InputStream)bais, attachable -> {
                    Vertex detachedVertex = (Vertex)attachable.get();
                    if (this.assertViaDirectEquality) {
                        TestHelper.validateVertexEquality(toSerialize, detachedVertex, false);
                    } else {
                        Assert.assertEquals((Object)toSerialize.id(), (Object)((Vertex)this.graph.vertices(new Object[]{detachedVertex.id().toString()}).next()).id());
                        Assert.assertEquals((Object)toSerialize.label(), (Object)detachedVertex.label());
                        if (assertProperties) {
                            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                            Assert.assertEquals((Object)toSerialize.value("name"), (Object)detachedVertex.value("name").toString());
                            Assert.assertEquals((Object)toSerialize.value("acl"), (Object)detachedVertex.value("acl").toString());
                        } else {
                            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
                        }
                    }
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)detachedVertex.edges(Direction.BOTH, new String[0])));
                    called.set(true);
                    return (Vertex)Mockito.mock(Vertex.class);
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }
}

