/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.List;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class GraphTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_VX1X_V_valuesXnameX(Object var1);

    public abstract Traversal<Vertex, String> get_g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name();

    public abstract Traversal<Vertex, Edge> get_g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX();

    public abstract Traversal<Vertex, String> get_g_V_outXknowsX_V_name();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_V_valuesXnameX() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_V_valuesXnameX(this.convertToVertexId(this.graph, "marko"));
        this.printTraversalForm(traversal);
        GraphTest.checkResults(Arrays.asList("marko", "vadas", "lop", "josh", "ripple", "peter"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name();
        this.printTraversalForm(traversal);
        GraphTest.checkResults(Arrays.asList("MY BABE", "HOOCHIE COOCHIE MAN"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Edge edge = (Edge)traversal.next();
            Assert.assertEquals((Object)"uses", (Object)edge.label());
            Assert.assertEquals((Object)"person", (Object)edge.outVertex().label());
            Assert.assertEquals((Object)"software", (Object)edge.inVertex().label());
            ++counter;
        }
        Assert.assertEquals((long)8L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outXknowsX_V_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_outXknowsX_V_name();
        this.printTraversalForm(traversal);
        GraphTest.checkResults(Arrays.asList("marko", "marko", "josh", "josh", "vadas", "vadas", "peter", "peter", "lop", "lop", "ripple", "ripple"), traversal);
    }

    public static class Traversals
    extends GraphTest {
        @Override
        public Traversal<Vertex, String> get_g_VX1X_V_valuesXnameX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).V(new Object[0]).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_outXknowsX_V_name() {
            return this.g.V(new Object[0]).out(new String[]{"knows"}).V(new Object[0]).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name() {
            return this.g.V(new Object[0]).has("artist", "name", (Object)"Garcia").in(new String[]{"sungBy"}).as("song", new String[0]).V(new Object[0]).has("artist", "name", (Object)"Willie_Dixon").in(new String[]{"writtenBy"}).where(P.eq((Object)"song")).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX() {
            List software = this.g.V(new Object[0]).hasLabel("software", new String[0]).toList();
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).as("p", new String[0]).V(new Object[]{software}).addE("uses").from("p");
        }
    }
}

