/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.javatuples.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoIntegrateTest
extends AbstractGremlinTest {
    private static final Logger logger = LoggerFactory.getLogger(IoIntegrateTest.class);

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
    public void shouldHaveSizeOfStarGraphLessThanDetached() throws Exception {
        int i;
        Random random = TestHelper.RANDOM;
        Vertex vertex = this.graph.addVertex("person");
        for (i = 0; i < 100; ++i) {
            vertex.property(VertexProperty.Cardinality.list, UUID.randomUUID().toString(), (Object)random.nextDouble(), new Object[]{"acl", random.nextBoolean() ? "public" : "private", "created", random.nextLong()});
        }
        for (i = 0; i < 50000; ++i) {
            vertex.addEdge("knows", this.graph.addVertex("person"), new Object[]{"since", random.nextLong(), "acl", random.nextBoolean() ? "public" : "private"});
            this.graph.addVertex("software").addEdge("createdBy", vertex, new Object[]{"date", random.nextLong()});
            this.graph.addVertex("group").addEdge("hasMember", vertex, new Object[0]);
        }
        Pair<StarGraph, Integer> pair = this.serializeDeserialize(StarGraph.of((Vertex)vertex));
        int starGraphSize = (Integer)pair.getValue1();
        TestHelper.validateEquality(vertex, ((StarGraph)pair.getValue0()).getStarVertex());
        pair = this.serializeDeserialize((StarGraph)pair.getValue0());
        Assert.assertEquals((long)starGraphSize, (long)((Integer)pair.getValue1()).intValue());
        starGraphSize = (Integer)pair.getValue1();
        TestHelper.validateEquality(vertex, ((StarGraph)pair.getValue0()).getStarVertex());
        pair = this.serializeDeserialize((StarGraph)pair.getValue0());
        Assert.assertEquals((long)starGraphSize, (long)((Integer)pair.getValue1()).intValue());
        starGraphSize = (Integer)pair.getValue1();
        TestHelper.validateEquality(vertex, ((StarGraph)pair.getValue0()).getStarVertex());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GryoWriter writer = ((GryoIo)this.graph.io(IoCore.gryo())).writer().create();
        writer.writeObject((OutputStream)outputStream, (Object)DetachedFactory.detach((Vertex)vertex, (boolean)true));
        vertex.edges(Direction.BOTH, new String[0]).forEachRemaining(e -> writer.writeObject((OutputStream)outputStream, (Object)DetachedFactory.detach((Edge)e, (boolean)true)));
        int detachedVertexSize = outputStream.size();
        Assert.assertTrue((starGraphSize < detachedVertexSize ? 1 : 0) != 0);
        logger.info("Size of star graph:        {}", (Object)starGraphSize);
        logger.info("Size of detached vertex:   {}", (Object)detachedVertexSize);
        logger.info("Size reduction:            {}", (Object)Float.valueOf((float)detachedVertexSize / (float)starGraphSize));
    }

    private Pair<StarGraph, Integer> serializeDeserialize(StarGraph starGraph) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ((GryoIo)this.graph.io(IoCore.gryo())).writer().create().writeObject((OutputStream)outputStream, (Object)starGraph);
            return Pair.with((Object)((StarGraph)((GryoIo)this.graph.io(IoCore.gryo())).reader().create().readObject((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), StarGraph.class)), (Object)outputStream.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

