/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class DedupTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_V_both_dedup_name();

    public abstract Traversal<Vertex, String> get_g_V_both_hasXlabel_softwareX_dedup_byXlangX_name();

    public abstract Traversal<Vertex, String> get_g_V_both_name_order_byXa_bX_dedup_value();

    public abstract Traversal<Vertex, String> get_g_V_both_both_name_dedup();

    public abstract Traversal<Vertex, Vertex> get_g_V_both_both_dedup();

    public abstract Traversal<Vertex, Vertex> get_g_V_both_both_dedup_byXlabelX();

    public abstract Traversal<Vertex, Map<String, List<Double>>> get_g_V_group_byXlabelX_byXbothE_weight_dedup_foldX();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX();

    public abstract Traversal<Vertex, Path> get_g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_dedupXa_bX_path();

    public abstract Traversal<Vertex, String> get_g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup();

    public abstract Traversal<Vertex, String> get_g_V_both_both_dedup_byXoutE_countX_name();

    public abstract Traversal<Vertex, String> get_g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold();

    public abstract Traversal<Vertex, Map<String, String>> get_g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold();

    public abstract Traversal<Vertex, Long> get_g_V_groupCount_selectXvaluesX_unfold_dedup();

    public abstract Traversal<Vertex, Collection<String>> get_g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup();

    public abstract Traversal<Vertex, Long> get_g_V_repeatXdedupX_timesX2X_count();

    public abstract Traversal<Vertex, String> get_g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX();

    public abstract Traversal<Vertex, Long> get_g_V_bothE_properties_dedup_count();

    public abstract Traversal<Vertex, Long> get_g_V_both_properties_dedup_count();

    public abstract Traversal<Vertex, Long> get_g_V_both_properties_properties_dedup_count();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold() {
        Traversal<Vertex, String> traversal = this.get_g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold();
        this.printTraversalForm(traversal);
        DedupTest.checkResults(Arrays.asList("marko", "josh", "peter"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold() {
        Traversal<Vertex, Map<String, String>> traversal = this.get_g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold();
        this.printTraversalForm(traversal);
        DedupTest.checkResults(this.makeMapList(2, "x", "lop", "y", "marko", "x", "lop", "y", "josh", "x", "lop", "y", "peter", "x", "vadas", "y", "marko", "x", "josh", "y", "marko", "x", "ripple", "y", "josh"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_dedup_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_dedup_name();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("marko"));
        Assert.assertTrue((boolean)names.contains("vadas"));
        Assert.assertTrue((boolean)names.contains("lop"));
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("ripple"));
        Assert.assertTrue((boolean)names.contains("peter"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_hasXlabel_softwareX_dedup_byXlangX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_hasXlabel_softwareX_dedup_byXlangX_name();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertTrue((names.contains("lop") || names.contains("ripple") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertEquals((Object)"lop", names.get(0));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_name_order_byXa_bX_dedup_value() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_name_order_byXa_bX_dedup_value();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertEquals((Object)"josh", names.get(0));
        Assert.assertEquals((Object)"lop", names.get(1));
        Assert.assertEquals((Object)"marko", names.get(2));
        Assert.assertEquals((Object)"peter", names.get(3));
        Assert.assertEquals((Object)"ripple", names.get(4));
        Assert.assertEquals((Object)"vadas", names.get(5));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_both_name_dedup() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_both_name_dedup();
        this.printTraversalForm(traversal);
        DedupTest.checkResults(Arrays.asList("marko", "vadas", "josh", "peter", "lop", "ripple"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_both_dedup() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_both_both_dedup();
        this.printTraversalForm(traversal);
        DedupTest.checkResults(Arrays.asList(this.convertToVertex(this.graph, "marko"), this.convertToVertex(this.graph, "vadas"), this.convertToVertex(this.graph, "josh"), this.convertToVertex(this.graph, "peter"), this.convertToVertex(this.graph, "lop"), this.convertToVertex(this.graph, "ripple")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_both_dedup_byXlabelX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_both_both_dedup_byXlabelX();
        this.printTraversalForm(traversal);
        List vertices = traversal.toList();
        Assert.assertEquals((long)2L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_group_byXlabelX_byXbothE_weight_dedup_foldX() {
        Traversal<Vertex, Map<String, List<Double>>> traversal = this.get_g_V_group_byXlabelX_byXbothE_weight_dedup_foldX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)3L, (long)((List)map.get("software")).size());
        Assert.assertEquals((long)4L, (long)((List)map.get("person")).size());
        Assert.assertTrue((boolean)((List)map.get("software")).contains(0.2));
        Assert.assertTrue((boolean)((List)map.get("software")).contains(0.4));
        Assert.assertTrue((boolean)((List)map.get("software")).contains(1.0));
        Assert.assertTrue((boolean)((List)map.get("person")).contains(0.2));
        Assert.assertTrue((boolean)((List)map.get("person")).contains(0.4));
        Assert.assertTrue((boolean)((List)map.get("person")).contains(0.5));
        Assert.assertTrue((boolean)((List)map.get("person")).contains(1.0));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX() {
        Traversal<Vertex, Map<String, Vertex>> traversal = this.get_g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX();
        this.printTraversalForm(traversal);
        int personPersonCounter = 0;
        int personSoftwareCounter = 0;
        int softwarePersonCounter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            if (((Vertex)map.get("a")).label().equals("person") && ((Vertex)map.get("b")).label().equals("person")) {
                ++personPersonCounter;
                continue;
            }
            if (((Vertex)map.get("a")).label().equals("person") && ((Vertex)map.get("b")).label().equals("software")) {
                ++personSoftwareCounter;
                continue;
            }
            if (((Vertex)map.get("a")).label().equals("software") && ((Vertex)map.get("b")).label().equals("person")) {
                ++softwarePersonCounter;
                continue;
            }
            Assert.fail((String)("Bad result type: " + map));
        }
        Assert.assertEquals((long)1L, (long)personPersonCounter);
        Assert.assertEquals((long)1L, (long)personSoftwareCounter);
        Assert.assertEquals((long)1L, (long)softwarePersonCounter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_dedupXa_bX_path() {
        Traversal<Vertex, Path> traversal = this.get_g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_dedupXa_bX_path();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<List<Vertex>> results = new HashSet<List<Vertex>>();
        while (traversal.hasNext()) {
            Path path = (Path)traversal.next();
            Assert.assertEquals((long)3L, (long)path.size());
            Assert.assertTrue((boolean)results.add(Arrays.asList((Vertex)path.get("a"), (Vertex)path.get("b"))));
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup() {
        Traversal<Vertex, String> traversal = this.get_g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)4L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("vadas"));
        Assert.assertTrue((boolean)names.contains("lop"));
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("ripple"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_both_dedup_byXoutE_countX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_both_both_dedup_byXoutE_countX_name();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)4L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("peter"));
        Assert.assertTrue((boolean)names.contains("marko"));
        Assert.assertEquals((long)4L, (long)new HashSet(names).size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_groupCount_selectXvaluesX_unfold_dedup() {
        Traversal<Vertex, Long> traversal = this.get_g_V_groupCount_selectXvaluesX_unfold_dedup();
        this.printTraversalForm(traversal);
        DedupTest.checkResults(Collections.singletonList(1L), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup() {
        Traversal<Vertex, Collection<String>> traversal = this.get_g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup();
        this.printTraversalForm(traversal);
        ArrayList vertices = new ArrayList((Collection)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)6L, (long)vertices.size());
        Assert.assertEquals((Object)"josh", vertices.get(0));
        Assert.assertEquals((Object)"lop", vertices.get(1));
        Assert.assertEquals((Object)"marko", vertices.get(2));
        Assert.assertEquals((Object)"peter", vertices.get(3));
        Assert.assertEquals((Object)"ripple", vertices.get(4));
        Assert.assertEquals((Object)"vadas", vertices.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_repeatXdedupX_timesX2X_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_repeatXdedupX_timesX2X_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)0L, (long)((Long)traversal.next()));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_bothE_properties_dedup_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_bothE_properties_dedup_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)4L, (long)((Long)traversal.next()));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_both_properties_dedup_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_both_properties_dedup_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)12L, (long)((Long)traversal.next()));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_V_both_properties_properties_dedup_count() {
        Traversal<Vertex, Long> traversal = this.get_g_V_both_properties_properties_dedup_count();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)21L, (long)((Long)traversal.next()));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    public static class Traversals
    extends DedupTest {
        @Override
        public Traversal<Vertex, String> get_g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold() {
            return this.g.V(new Object[0]).out(new String[0]).in(new String[0]).values(new String[]{"name"}).fold().dedup(Scope.local, new String[0]).unfold();
        }

        @Override
        public Traversal<Vertex, Map<String, String>> get_g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold() {
            return this.g.V(new Object[0]).out(new String[0]).as("x", new String[0]).in(new String[0]).as("y", new String[0]).select("x", "y", new String[0]).by("name").fold().dedup(Scope.local, new String[]{"x", "y"}).unfold();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_dedup_name() {
            return this.g.V(new Object[0]).both(new String[0]).dedup(new String[0]).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_hasXlabel_softwareX_dedup_byXlangX_name() {
            return this.g.V(new Object[0]).both(new String[0]).has(T.label, (Object)"software").dedup(new String[0]).by("lang").values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_name_order_byXa_bX_dedup_value() {
            return this.g.V(new Object[0]).both(new String[0]).properties(new String[]{"name"}).order().by((a, b) -> ((String)a.value()).compareTo((String)b.value())).dedup(new String[0]).value();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_both_name_dedup() {
            return this.g.V(new Object[0]).both(new String[0]).both(new String[0]).values(new String[]{"name"}).dedup(new String[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_both_both_dedup() {
            return this.g.V(new Object[0]).both(new String[0]).both(new String[0]).dedup(new String[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_both_both_dedup_byXlabelX() {
            return this.g.V(new Object[0]).both(new String[0]).both(new String[0]).dedup(new String[0]).by(T.label);
        }

        @Override
        public Traversal<Vertex, Map<String, List<Double>>> get_g_V_group_byXlabelX_byXbothE_weight_dedup_foldX() {
            return this.g.V(new Object[0]).group().by(T.label).by((Traversal)__.bothE((String[])new String[0]).values(new String[]{"weight"}).dedup(new String[0]).fold());
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX() {
            return this.g.V(new Object[0]).as("a", new String[0]).both(new String[0]).as("b", new String[0]).dedup(new String[]{"a", "b"}).by(T.label).select("a", "b", new String[0]);
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_dedupXa_bX_path() {
            return this.g.V(new Object[0]).as("a", new String[0]).out(new String[]{"created"}).as("b", new String[0]).in(new String[]{"created"}).as("c", new String[0]).dedup(new String[]{"a", "b"}).path();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup() {
            return this.g.V(new Object[0]).outE(new String[0]).as("e", new String[0]).inV().as("v", new String[0]).select("e").order().by("weight", (Comparator)Order.asc).select("v").values(new String[]{"name"}).dedup(new String[0]);
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_both_dedup_byXoutE_countX_name() {
            return this.g.V(new Object[0]).both(new String[0]).both(new String[0]).dedup(new String[0]).by((Traversal)__.outE((String[])new String[0]).count()).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_groupCount_selectXvaluesX_unfold_dedup() {
            return this.g.V(new Object[0]).groupCount().select(Column.values).unfold().dedup(new String[0]);
        }

        @Override
        public Traversal<Vertex, Collection<String>> get_g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup() {
            return this.g.V(new Object[0]).as("a", new String[0]).repeat((Traversal)__.both((String[])new String[0])).times(3).emit().values(new String[]{"name"}).as("b", new String[0]).group().by((Traversal)__.select((String)"a")).by((Traversal)__.select((String)"b").dedup(new String[0]).order().fold()).select(Column.values).unfold().dedup(new String[0]);
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_repeatXdedupX_timesX2X_count() {
            return this.g.V(new Object[0]).repeat((Traversal)__.dedup((String[])new String[0])).times(2).count();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX() {
            return this.g.V(new Object[0]).both(new String[0]).group().by().by((Traversal)__.out((String[])new String[0]).dedup(new String[0]).fold()).unfold().select(Column.values).unfold().out(new String[0]).order().by("name").limit(1L).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_bothE_properties_dedup_count() {
            return this.g.V(new Object[0]).bothE(new String[0]).properties(new String[0]).dedup(new String[0]).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_both_properties_dedup_count() {
            return this.g.V(new Object[0]).both(new String[0]).properties(new String[0]).dedup(new String[0]).count();
        }

        @Override
        public Traversal<Vertex, Long> get_g_V_both_properties_properties_dedup_count() {
            return this.g.V(new Object[0]).both(new String[0]).properties(new String[0]).properties(new String[0]).dedup(new String[0]).count();
        }
    }
}

