/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.awt.Color;
import java.sql.CallableStatement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.DefaultGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.DefaultImportCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.GremlinModule;
import org.apache.tinkerpop.gremlin.jsr223.GremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineSuite;
import org.apache.tinkerpop.gremlin.jsr223.ImportGremlinPlugin;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class GremlinEnabledScriptEngineTest {
    private static final GremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();

    @Test
    public void shouldEvalBytecode() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Graph graph = EmptyGraph.instance();
        GraphTraversalSource g = graph.traversal();
        GraphTraversal<Vertex, Long> t = GremlinEnabledScriptEngineTest.getTraversalWithLambda(g);
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("x", (Object)g);
        Traversal.Admin evald = scriptEngine.eval(t.asAdmin().getBytecode(), (Bindings)bindings, "x");
        GremlinEnabledScriptEngineTest.assertTraversals(t, (Traversal)evald);
        MatcherAssert.assertThat((Object)manager.getBindings().containsKey("gremlinscriptengine__g"), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBytecodeEvalWithAliasInBindings() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Graph graph = EmptyGraph.instance();
        GraphTraversalSource g = graph.traversal();
        GraphTraversal<Vertex, Long> t = GremlinEnabledScriptEngineTest.getTraversalWithLambda(g);
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("x", (Object)g);
        bindings.put("gremlinscriptengine__g", (Object)g);
        scriptEngine.eval(t.asAdmin().getBytecode(), (Bindings)bindings, "x");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBytecodeEvalWithAliasAsTraversalSource() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Graph graph = EmptyGraph.instance();
        GraphTraversalSource g = graph.traversal();
        GraphTraversal<Vertex, Long> t = GremlinEnabledScriptEngineTest.getTraversalWithLambda(g);
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("x", (Object)g);
        scriptEngine.eval(t.asAdmin().getBytecode(), (Bindings)bindings, "gremlinscriptengine__g");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBytecodeEvalWithMissingBinding() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Graph graph = EmptyGraph.instance();
        GraphTraversalSource g = graph.traversal();
        GraphTraversal<Vertex, Long> t = GremlinEnabledScriptEngineTest.getTraversalWithLambda(g);
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("z", (Object)g);
        scriptEngine.eval(t.asAdmin().getBytecode(), (Bindings)bindings, "x");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBytecodeEvalWithInvalidBinding() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Graph graph = EmptyGraph.instance();
        GraphTraversalSource g = graph.traversal();
        GraphTraversal<Vertex, Long> t = GremlinEnabledScriptEngineTest.getTraversalWithLambda(g);
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("z", (Object)g);
        bindings.put("x", (Object)"invalid-binding-for-x-given-x-should-be-traversal-source");
        scriptEngine.eval(t.asAdmin().getBytecode(), (Bindings)bindings, "x");
    }

    @Test
    public void shouldGetEngineByName() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Assert.assertEquals((Object)GremlinScriptEngineSuite.ENGINE_TO_TEST, (Object)scriptEngine.getFactory().getEngineName());
    }

    @Test
    public void shouldHaveCoreImportsInPlace() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        List<Class> classesToCheck = Arrays.asList(Vertex.class, Edge.class, Graph.class, VertexProperty.class);
        for (Class clazz : classesToCheck) {
            Assert.assertEquals((Object)clazz, (Object)scriptEngine.eval(clazz.getSimpleName()));
        }
    }

    @Test
    public void shouldSupportDeprecatedGremlinModules() throws Exception {
        DefaultGremlinScriptEngineManager mgr = new DefaultGremlinScriptEngineManager();
        mgr.addModule(new GremlinModule(){

            public String getName() {
                return "test.junk";
            }

            public Optional<Customizer[]> getCustomizers(String scriptEngineName) {
                return Optional.of(new Customizer[]{DefaultImportCustomizer.build().addClassImports(new Class[]{Color.class}).addClassImports(new Class[]{CallableStatement.class}).create()});
            }
        });
        GremlinScriptEngine scriptEngine = mgr.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        List<Class> classesToCheck = Arrays.asList(Color.class, CallableStatement.class);
        for (Class clazz : classesToCheck) {
            Assert.assertEquals((Object)clazz, (Object)scriptEngine.eval(clazz.getSimpleName()));
        }
    }

    @Test
    public void shouldReturnNoCustomizers() {
        DefaultGremlinScriptEngineManager mgr = new DefaultGremlinScriptEngineManager();
        mgr.addPlugin((GremlinPlugin)ImportGremlinPlugin.build().classImports(new Class[]{Color.class}).appliesTo(Collections.singletonList("fake-script-engine")).create());
        Assert.assertEquals((long)0L, (long)mgr.getCustomizers(GremlinScriptEngineSuite.ENGINE_TO_TEST).size());
    }

    private static GraphTraversal<Vertex, Long> getTraversalWithLambda(GraphTraversalSource g) {
        Assume.assumeThat((String)("This test is not enabled for this ScriptEngine: " + GremlinScriptEngineSuite.ENGINE_TO_TEST), (Object)GremlinScriptEngineSuite.ENGINE_TO_TEST, (Matcher)AnyOf.anyOf((Matcher)Is.is((Object)"gremlin-python"), (Matcher)Is.is((Object)"gremlin-jython"), (Matcher)Is.is((Object)"gremlin-groovy")));
        if (GremlinScriptEngineSuite.ENGINE_TO_TEST.equals("gremlin-groovy")) {
            return g.V(new Object[0]).out(new String[]{"created"}).map(Lambda.function((String)"{x -> x.get().values('name')}")).count();
        }
        if (GremlinScriptEngineSuite.ENGINE_TO_TEST.equals("gremlin-python") || GremlinScriptEngineSuite.ENGINE_TO_TEST.equals("gremlin-jython")) {
            return g.V(new Object[0]).out(new String[]{"created"}).map(Lambda.function((String)"x : x.get().values('name')")).count();
        }
        throw new RuntimeException("The " + GremlinScriptEngineSuite.ENGINE_TO_TEST + " ScriptEngine is not supported by this test");
    }

    private static void assertTraversals(GraphTraversal t, Traversal evald) {
        List steps = t.asAdmin().getSteps();
        for (int ix = 0; ix < steps.size(); ++ix) {
            Assert.assertEquals(((Step)steps.get(ix)).getClass(), evald.asAdmin().getSteps().get(ix).getClass());
        }
    }
}

