/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class DetachedVertexTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldIteratePropertiesOnDetached() {
        Vertex v = this.graph.addVertex(new Object[]{"name", "daniel", "favoriteColor", "red", "state", "happy"});
        DetachedVertex detached = DetachedFactory.detach((Vertex)v, (boolean)true);
        Assert.assertEquals((Object)"daniel", (Object)((VertexProperty)detached.properties(new String[]{"name"}).next()).value());
        detached.properties(new String[0]).forEachRemaining(p -> {
            if (p.key().equals("name")) {
                Assert.assertEquals((Object)"daniel", (Object)p.value());
            } else if (p.key().equals("favoriteColor")) {
                Assert.assertEquals((Object)"red", (Object)p.value());
            } else if (p.key().equals("state")) {
                Assert.assertEquals((Object)"happy", (Object)p.value());
            } else {
                Assert.fail((String)"Should be one of the expected keys");
            }
        });
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldHashAndEqualCorrectly() {
        Vertex v = this.graph.addVertex(new Object[0]);
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < 100; ++i) {
            set.add(DetachedFactory.detach((Vertex)v, (boolean)true));
            set.add(DetachedFactory.detach((Vertex)v, (boolean)false));
            set.add(v);
        }
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotConstructNewWithSomethingAlreadyDetached() {
        Vertex v = this.graph.addVertex(new Object[0]);
        DetachedVertex dv = DetachedFactory.detach((Vertex)v, (boolean)true);
        Assert.assertSame((Object)dv, (Object)DetachedFactory.detach((Vertex)dv, (boolean)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldConstructDetachedVertex() {
        Vertex v = this.graph.addVertex(new Object[]{"test", "123"});
        DetachedVertex detachedVertex = DetachedFactory.detach((Vertex)v, (boolean)true);
        Assert.assertEquals((Object)v.id(), (Object)detachedVertex.id());
        Assert.assertEquals((Object)v.label(), (Object)detachedVertex.label());
        Assert.assertEquals((Object)"123", (Object)detachedVertex.value("test"));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldConstructDetachedVertexAsReference() {
        Vertex v = this.graph.addVertex(new Object[]{"test", "123", "test", "321"});
        DetachedVertex detachedVertex = DetachedFactory.detach((Vertex)v, (boolean)false);
        Assert.assertEquals((Object)v.id(), (Object)detachedVertex.id());
        Assert.assertEquals((Object)v.label(), (Object)detachedVertex.label());
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)detachedVertex.properties(new String[0])));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldDetachVertexWithMultiPropertiesAndMetaProperties() {
        DetachedVertex v1 = DetachedFactory.detach((Vertex)this.convertToVertex(this.graph, "marko"), (boolean)true);
        Assert.assertEquals((Object)"person", (Object)v1.label());
        Assert.assertEquals((long)2L, (long)v1.keys().size());
        v1.properties(new String[]{"location"}).forEachRemaining(vp -> {
            Assert.assertTrue((boolean)(vp instanceof DetachedVertexProperty));
            if (vp.value().equals("san diego")) {
                Assert.assertEquals((long)1997L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2001L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("santa cruz")) {
                Assert.assertEquals((long)2001L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("brussels")) {
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else if (vp.value().equals("santa fe")) {
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)IteratorUtils.count((Iterator)vp.properties(new String[0]))));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvaluateToEqual() {
        Assert.assertTrue((boolean)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true).equals((Object)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true)));
        Assert.assertTrue((boolean)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true).equals(this.g.V(new Object[]{this.convertToVertexId("marko")}).next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveSameHashCode() {
        Assert.assertEquals((long)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true).hashCode(), (long)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true).hashCode());
        Assert.assertEquals((long)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true).hashCode(), (long)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).hashCode());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToGraph() {
        Vertex toDetach = (Vertex)this.g.V(new Object[]{this.convertToVertexId("josh")}).next();
        DetachedVertex detachedVertex = DetachedFactory.detach((Vertex)toDetach, (boolean)true);
        Vertex attached = (Vertex)detachedVertex.attach(Attachable.Method.get((Host)this.graph));
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedVertex));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToVertex() {
        Vertex toDetach = (Vertex)this.g.V(new Object[]{this.convertToVertexId("josh")}).next();
        DetachedVertex detachedVertex = DetachedFactory.detach((Vertex)toDetach, (boolean)true);
        Vertex attached = (Vertex)detachedVertex.attach(Attachable.Method.get((Host)toDetach));
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedVertex));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="IntegerValues")
    public void shouldNotEvaluateToEqualDifferentId() {
        DetachedVertex originalMarko = DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true);
        Vertex secondMarko = this.graph.addVertex(new Object[]{"name", "marko", "age", 29});
        Assert.assertFalse((boolean)DetachedFactory.detach((Vertex)secondMarko, (boolean)true).equals((Object)originalMarko));
    }

    @Test
    public void shouldConstructDetachedVertexFromParts() {
        HashMap<String, List<Map>> properties = new HashMap<String, List<Map>>();
        HashMap<String, Object> propX1 = new HashMap<String, Object>();
        propX1.put("value", "a");
        propX1.put("id", 123);
        propX1.put("label", "x");
        HashMap<String, Object> propX2 = new HashMap<String, Object>();
        propX2.put("value", "c");
        propX2.put("id", 124);
        propX2.put("label", "x");
        properties.put("x", Arrays.asList(propX1, propX2));
        HashMap<String, Object> propY1 = new HashMap<String, Object>();
        propY1.put("value", "b");
        propY1.put("id", 125);
        propY1.put("label", "y");
        HashMap<String, Object> propY2 = new HashMap<String, Object>();
        propY2.put("value", "d");
        propY2.put("id", 126);
        propY2.put("label", "y");
        properties.put("y", Arrays.asList(propY1, propY2));
        DetachedVertex dv = new DetachedVertex((Object)1, "test", properties);
        Assert.assertEquals((Object)1, (Object)dv.id());
        Assert.assertEquals((Object)"test", (Object)dv.label());
        List propertyX = IteratorUtils.list((Iterator)dv.properties(new String[]{"x"}));
        Assert.assertEquals((long)2L, (long)propertyX.size());
        Assert.assertTrue((boolean)propertyX.stream().allMatch(p -> !(!p.label().equals(p.key()) || !p.id().equals(123) && !p.id().equals(124) || !p.value().equals("a") && !p.value().equals("c") || p.properties(new String[0]).hasNext())));
    }

    @Test
    public void shouldConstructDetachedVertexFromPartsWithPropertiesOnProperties() {
        HashMap<String, List<Map>> properties = new HashMap<String, List<Map>>();
        HashMap<String, Object> propX1 = new HashMap<String, Object>();
        propX1.put("value", "a");
        propX1.put("id", 123);
        propX1.put("label", "x");
        propX1.put("properties", ElementHelper.asMap((Object[])new Object[]{"propX1a", "a", "propX11", 1, "same", 123.01, "extra", "something"}));
        HashMap<String, Object> propX2 = new HashMap<String, Object>();
        propX2.put("value", "c");
        propX2.put("id", 124);
        propX2.put("label", "x");
        properties.put("x", Arrays.asList(propX1, propX2));
        HashMap<String, Object> propY1 = new HashMap<String, Object>();
        propY1.put("value", "b");
        propY1.put("id", 125);
        propY1.put("label", "");
        HashMap<String, Object> propY2 = new HashMap<String, Object>();
        propY2.put("value", "d");
        propY2.put("id", 126);
        propY2.put("label", "y");
        properties.put("y", Arrays.asList(propY1, propY2));
        DetachedVertex dv = new DetachedVertex((Object)1, "test", properties);
        Assert.assertEquals((Object)1, (Object)dv.id());
        Assert.assertEquals((Object)"test", (Object)dv.label());
        List propertyX = IteratorUtils.list((Iterator)dv.properties(new String[]{"x"}));
        Assert.assertEquals((long)2L, (long)propertyX.size());
        Assert.assertTrue((boolean)propertyX.stream().allMatch(p -> !(!p.label().equals(p.key()) || !p.id().equals(123) && !p.id().equals(124) || !p.value().equals("a") && !p.value().equals("c"))));
        VertexProperty propertyOnProperty = propertyX.stream().filter(p -> p.properties(new String[0]).hasNext()).findAny().get();
        Assert.assertEquals((Object)"a", (Object)((Property)propertyOnProperty.properties(new String[]{"propX1a"}).next()).value());
        Assert.assertEquals((Object)1, (Object)((Property)propertyOnProperty.properties(new String[]{"propX11"}).next()).value());
        Assert.assertEquals((Object)123.01, (Object)((Property)propertyOnProperty.properties(new String[]{"same"}).next()).value());
        Assert.assertEquals((Object)"something", (Object)((Property)propertyOnProperty.properties(new String[]{"extra"}).next()).value());
        Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)propertyOnProperty.properties(new String[0])));
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotAllowAddEdge() {
        Vertex v = this.graph.addVertex(new Object[0]);
        DetachedVertex detachedVertex = DetachedFactory.detach((Vertex)v, (boolean)true);
        detachedVertex.addEdge("test", null, new Object[0]);
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotAllowSetProperty() {
        Vertex v = this.graph.addVertex(new Object[0]);
        DetachedVertex detachedVertex = DetachedFactory.detach((Vertex)v, (boolean)true);
        detachedVertex.property(VertexProperty.Cardinality.single, "test", (Object)"test", new Object[0]);
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotAllowRemove() {
        Vertex v = this.graph.addVertex(new Object[0]);
        DetachedVertex detachedVertex = DetachedFactory.detach((Vertex)v, (boolean)true);
        detachedVertex.remove();
    }

    @Test(expected=IllegalStateException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldNotBeAbleToCallPropertyIfThereAreMultipleProperties() {
        DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true).property("location");
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldBeAbleToCallPropertyIfThereIsASingleProperty() {
        DetachedVertex dv = DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true);
        Assert.assertEquals((Object)"marko", (Object)dv.property("name").value());
        Assert.assertEquals((Object)29, (Object)dv.property("age").value());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldCreateVertex() {
        DetachedVertex detachedVertex = new DetachedVertex((Object)23, "dog", Collections.emptyMap());
        detachedVertex.attach(Attachable.Method.create((Host)this.graph));
        Assert.assertEquals((long)7L, (long)IteratorUtils.count((Iterator)this.graph.vertices(new Object[0])));
        AtomicInteger dogTimes = new AtomicInteger(0);
        this.graph.vertices(new Object[0]).forEachRemaining(vertex -> {
            if (vertex.label().equals("dog")) {
                dogTimes.incrementAndGet();
            }
        });
        Assert.assertEquals((long)1L, (long)dogTimes.get());
    }
}

