/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class VertexTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_VXlistXv1_v2_v3XX_name(Vertex var1, Vertex var2, Vertex var3);

    public abstract Traversal<Vertex, String> get_g_VXlistX1_2_3XX_name(Object var1, Object var2, Object var3);

    public abstract Traversal<Vertex, Vertex> get_g_V();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX2X_in(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX4X_both(Object var1);

    public abstract Traversal<Edge, Edge> get_g_E();

    public abstract Traversal<Edge, Edge> get_g_EX11X(Object var1);

    public abstract Traversal<Vertex, Edge> get_g_VX1X_outE(Object var1);

    public abstract Traversal<Vertex, Edge> get_g_VX2X_inE(Object var1);

    public abstract Traversal<Vertex, Edge> get_g_VX4X_bothE(Object var1);

    public abstract Traversal<Vertex, Edge> get_g_VX4X_bothEXcreatedX(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_outE_inV(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX2X_inE_outV(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_outE_hasXweight_1X_outV();

    public abstract Traversal<Vertex, String> get_g_V_out_outE_inV_inE_inV_both_name();

    public abstract Traversal<Vertex, String> get_g_VX1X_outEXknowsX_bothV_name(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_outXknowsX(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_outXknows_createdX(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_outEXknowsX_inV(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_outEXknows_createdX_inV(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_out_out();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_out_out(Object var1);

    public abstract Traversal<Vertex, String> get_g_VX1X_out_name(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_outE_otherV(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX4X_bothE_otherV(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX4X_bothE_hasXweight_lt_1X_otherV(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_to_XOUT_knowsX(Object var1);

    public abstract Traversal<Vertex, String> get_g_VX1_2_3_4X_name(Object var1, Object var2, Object var3, Object var4);

    public abstract Traversal<Vertex, String> get_g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VXlistX1_2_3XX_name() {
        Traversal<Vertex, String> traversal = this.get_g_VXlistX1_2_3XX_name(this.convertToVertexId(this.graph, "marko"), this.convertToVertexId(this.graph, "vadas"), this.convertToVertexId(this.graph, "lop"));
        this.printTraversalForm(traversal);
        VertexTest.checkResults(Arrays.asList("marko", "vadas", "lop"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VXlistXv1_v2_v3XX_name() {
        Traversal<Vertex, String> traversal = this.get_g_VXlistXv1_v2_v3XX_name(this.convertToVertex(this.graph, "marko"), this.convertToVertex(this.graph, "vadas"), this.convertToVertex(this.graph, "lop"));
        this.printTraversalForm(traversal);
        VertexTest.checkResults(Arrays.asList("marko", "vadas", "lop"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Object> vertices = new HashSet<Object>();
        while (traversal.hasNext()) {
            ++counter;
            vertices.add(traversal.next());
        }
        Assert.assertEquals((long)6L, (long)vertices.size());
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out(this.convertToVertexId("marko"));
        this.assert_g_v1_out(traversal);
    }

    private void assert_g_v1_out(Traversal<Vertex, Vertex> traversal) {
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("vadas") || vertex.value("name").equals("josh") || vertex.value("name").equals("lop") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((long)3L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX2X_in() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX2X_in(this.convertToVertexId("vadas"));
        this.assert_g_v2_in(traversal);
    }

    private void assert_g_v2_in(Traversal<Vertex, Vertex> traversal) {
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertEquals((Object)((Vertex)traversal.next()).value("name"), (Object)"marko");
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX4X_both() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX4X_both(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("marko") || vertex.value("name").equals("ripple") || vertex.value("name").equals("lop") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((long)3L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E() {
        Traversal<Edge, Edge> traversal = this.get_g_E();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Object> edges = new HashSet<Object>();
        while (traversal.hasNext()) {
            ++counter;
            edges.add(traversal.next());
        }
        Assert.assertEquals((long)6L, (long)edges.size());
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_EX11X() {
        Object edgeId = this.convertToEdgeId("josh", "created", "lop");
        Traversal<Edge, Edge> traversal = this.get_g_EX11X(edgeId);
        this.assert_g_EX11X(edgeId, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_EX11AsStringX() {
        Object edgeId = this.convertToEdgeId("josh", "created", "lop");
        Traversal<Edge, Edge> traversal = this.get_g_EX11X(edgeId.toString());
        this.assert_g_EX11X(edgeId, traversal);
    }

    private void assert_g_EX11X(Object edgeId, Traversal<Edge, Edge> traversal) {
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Edge e = (Edge)traversal.next();
        Assert.assertEquals((Object)edgeId, (Object)e.id());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outE() {
        Traversal<Vertex, Edge> traversal = this.get_g_VX1X_outE(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Edge> edges = new HashSet<Edge>();
        while (traversal.hasNext()) {
            ++counter;
            Edge edge = (Edge)traversal.next();
            edges.add(edge);
            Assert.assertTrue((edge.label().equals("knows") || edge.label().equals("created") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((long)3L, (long)edges.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX2X_inE() {
        Traversal<Vertex, Edge> traversal = this.get_g_VX2X_inE(this.convertToVertexId("vadas"));
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertEquals((Object)((Edge)traversal.next()).label(), (Object)"knows");
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX4X_bothEXcreatedX() {
        Traversal<Vertex, Edge> traversal = this.get_g_VX4X_bothEXcreatedX(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Edge> edges = new HashSet<Edge>();
        while (traversal.hasNext()) {
            ++counter;
            Edge edge = (Edge)traversal.next();
            edges.add(edge);
            Assert.assertTrue((boolean)edge.label().equals("created"));
            Assert.assertEquals((Object)edge.outVertex().id(), (Object)this.convertToVertexId("josh"));
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertEquals((long)2L, (long)edges.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX4X_bothE() {
        Traversal<Vertex, Edge> traversal = this.get_g_VX4X_bothE(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Edge> edges = new HashSet<Edge>();
        while (traversal.hasNext()) {
            ++counter;
            Edge edge = (Edge)traversal.next();
            edges.add(edge);
            Assert.assertTrue((edge.label().equals("knows") || edge.label().equals("created") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((long)3L, (long)edges.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outE_inV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outE_inV(this.convertToVertexId("marko"));
        this.assert_g_v1_out(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX2X_inE_outV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX2X_inE_outV(this.convertToVertexId("vadas"));
        this.assert_g_v2_in(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outE_hasXweight_1X_outV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_outE_hasXweight_1X_outV();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashMap<Object, Integer> counts = new HashMap<Object, Integer>();
        while (traversal.hasNext()) {
            Object id = ((Vertex)traversal.next()).id();
            int previousCount = counts.getOrDefault(id, 0);
            counts.put(id, previousCount + 1);
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counts.size());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get(this.convertToVertexId("marko"))).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)counts.get(this.convertToVertexId("josh"))).intValue());
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_outE_inV_inE_inV_both_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_out_outE_inV_inE_inV_both_name();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        while (traversal.hasNext()) {
            String key = (String)traversal.next();
            int previousCount = counts.getOrDefault(key, 0);
            counts.put(key, previousCount + 1);
            ++counter;
        }
        Assert.assertEquals((long)3L, (long)counts.size());
        Assert.assertEquals((long)4L, (long)((Integer)counts.get("josh")).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("marko")).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)counts.get("peter")).intValue());
        Assert.assertEquals((long)10L, (long)counter);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outEXknowsX_bothV_name() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_outEXknowsX_bothV_name(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)4L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("marko"));
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("vadas"));
        names.remove("marko");
        Assert.assertEquals((long)3L, (long)names.size());
        names.remove("marko");
        Assert.assertEquals((long)2L, (long)names.size());
        names.remove("josh");
        Assert.assertEquals((long)1L, (long)names.size());
        names.remove("vadas");
        Assert.assertEquals((long)0L, (long)names.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outE_otherV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outE_otherV(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("vadas") || vertex.value("name").equals("josh") || vertex.value("name").equals("lop") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((long)3L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX4X_bothE_otherV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX4X_bothE_otherV(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        List vertices = traversal.toList();
        Assert.assertEquals((long)3L, (long)vertices.size());
        Assert.assertTrue((boolean)vertices.stream().anyMatch(v -> v.value("name").equals("marko")));
        Assert.assertTrue((boolean)vertices.stream().anyMatch(v -> v.value("name").equals("ripple")));
        Assert.assertTrue((boolean)vertices.stream().anyMatch(v -> v.value("name").equals("lop")));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX4X_bothE_hasXweight_lt_1X_otherV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX4X_bothE_hasXweight_lt_1X_otherV(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        List vertices = traversal.toList();
        Assert.assertEquals((long)1L, (long)vertices.size());
        Assert.assertEquals((Object)((Vertex)vertices.get(0)).value("name"), (Object)"lop");
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outXknowsX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outXknowsX(this.convertToVertexId("marko"));
        this.assert_g_v1_outXknowsX(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outXknowsAsStringIdX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outXknowsX(this.convertToVertexId("marko").toString());
        this.assert_g_v1_outXknowsX(traversal);
    }

    private void assert_g_v1_outXknowsX(Traversal<Vertex, Vertex> traversal) {
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("vadas") || vertex.value("name").equals("josh") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertEquals((long)2L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outXknows_createdX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outXknows_createdX(this.convertToVertexId("marko"));
        this.assert_g_v1_out(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outEXknowsX_inV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outEXknowsX_inV(this.convertToVertexId("marko"));
        this.assert_g_v1_outXknowsX(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outEXknows_createdX_inV() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_outEXknows_createdX_inV(this.convertToVertexId("marko"));
        this.assert_g_v1_out(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_out() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_out_out();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("lop") || vertex.value("name").equals("ripple") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertEquals((long)2L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_out_out() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_out_out(this.convertToVertexId("marko"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_name() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_out_name(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<String> names = new HashSet<String>();
        while (traversal.hasNext()) {
            ++counter;
            String name = (String)traversal.next();
            names.add(name);
            Assert.assertTrue((name.equals("vadas") || name.equals("josh") || name.equals("lop") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((long)3L, (long)names.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_to_XOUT_knowsX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_to_XOUT_knowsX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            String name = (String)vertex.value("name");
            Assert.assertTrue((name.equals("vadas") || name.equals("josh") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_VX1_2_3_4X_name() {
        Object vLop = this.convertToVertexId("lop");
        this.g.V(new Object[]{vLop}).drop().iterate();
        Traversal<Vertex, String> traversal = this.get_g_VX1_2_3_4X_name(this.convertToVertexId("marko"), this.convertToVertexId("vadas"), vLop, this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        VertexTest.checkResults(Arrays.asList("marko", "vadas", "josh"), traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name();
        this.printTraversalForm(traversal);
        VertexTest.checkResults(Arrays.asList("lop", "lop", "lop", "lop", "ripple", "ripple", "ripple", "ripple"), traversal);
    }

    public static class Traversals
    extends VertexTest {
        @Override
        public Traversal<Vertex, String> get_g_VXlistXv1_v2_v3XX_name(Vertex v1, Vertex v2, Vertex v3) {
            return this.g.V(new Object[]{Arrays.asList(v1, v2, v3)}).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_VXlistX1_2_3XX_name(Object v1Id, Object v2Id, Object v3Id) {
            return this.g.V(new Object[]{Arrays.asList(v1Id, v2Id, v3Id)}).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V() {
            return this.g.V(new Object[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX2X_in(Object v2Id) {
            return this.g.V(new Object[]{v2Id}).in(new String[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX4X_both(Object v4Id) {
            return this.g.V(new Object[]{v4Id}).both(new String[0]);
        }

        @Override
        public Traversal<Edge, Edge> get_g_E() {
            return this.g.E(new Object[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_VX1X_outE(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE(new String[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_VX2X_inE(Object v2Id) {
            return this.g.V(new Object[]{v2Id}).inE(new String[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_VX4X_bothE(Object v4Id) {
            return this.g.V(new Object[]{v4Id}).bothE(new String[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_VX4X_bothEXcreatedX(Object v4Id) {
            return this.g.V(new Object[]{v4Id}).bothE(new String[]{"created"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_outE_inV(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE(new String[0]).inV();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX2X_inE_outV(Object v2Id) {
            return this.g.V(new Object[]{v2Id}).inE(new String[0]).outV();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_outE_hasXweight_1X_outV() {
            return this.g.V(new Object[0]).outE(new String[0]).has("weight", (Object)1.0).outV();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_out_outE_inV_inE_inV_both_name() {
            return this.g.V(new Object[0]).out(new String[0]).outE(new String[0]).inV().inE(new String[0]).inV().both(new String[0]).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1X_outEXknowsX_bothV_name(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE(new String[]{"knows"}).bothV().values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_outXknowsX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[]{"knows"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_outXknows_createdX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[]{"knows", "created"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_outEXknowsX_inV(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE(new String[]{"knows"}).inV();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_outEXknows_createdX_inV(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE(new String[]{"knows", "created"}).inV();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_outE_otherV(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE(new String[0]).otherV();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX4X_bothE_otherV(Object v4Id) {
            return this.g.V(new Object[]{v4Id}).bothE(new String[0]).otherV();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX4X_bothE_hasXweight_lt_1X_otherV(Object v4Id) {
            return this.g.V(new Object[]{v4Id}).bothE(new String[0]).has("weight", P.lt((Object)1.0)).otherV();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_out_out() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_out_out(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).out(new String[0]).out(new String[0]);
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1X_out_name(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_to_XOUT_knowsX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).to(Direction.OUT, new String[]{"knows"});
        }

        @Override
        public Traversal<Vertex, String> get_g_VX1_2_3_4X_name(Object v1Id, Object v2Id, Object v3Id, Object v4Id) {
            return this.g.V(new Object[]{v1Id, v2Id, v3Id, v4Id}).values(new String[]{"name"});
        }

        @Override
        public Traversal<Edge, Edge> get_g_EX11X(Object e11Id) {
            return this.g.E(new Object[]{e11Id});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).V(new Object[0]).hasLabel("software", new String[0]).values(new String[]{"name"});
        }
    }
}

