/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.SingleGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration.RemoteStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ConnectiveStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ElementIdStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.RequirementsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SackStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SideEffectStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class TranslationStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final TraversalSource traversalSource;
    private final Translator translator;
    private static final Set<Class<? extends TraversalStrategy.DecorationStrategy>> POSTS = new HashSet<Class>(Arrays.asList(ConnectiveStrategy.class, ElementIdStrategy.class, EventStrategy.class, HaltedTraverserStrategy.class, PartitionStrategy.class, RequirementsStrategy.class, SackStrategy.class, SideEffectStrategy.class, SubgraphStrategy.class, RemoteStrategy.class));

    public TranslationStrategy(TraversalSource traversalSource, Translator translator) {
        this.traversalSource = traversalSource;
        this.translator = translator;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        Traversal.Admin translatedTraversal;
        Bytecode bytecode;
        if (!(traversal.getParent() instanceof EmptyStep)) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("is.testing", "false")).booleanValue() && (traversal.getBytecode().toString().contains("$") || traversal.getBytecode().toString().contains("HashSetSupplier"))) {
            throw new VerificationException("Test suite does not support lambdas", traversal);
        }
        Bytecode bytecode2 = bytecode = Boolean.valueOf(System.getProperty("is.testing", "false")) != false ? TranslationStrategy.insertBindingsForTesting(traversal.getBytecode()) : traversal.getBytecode();
        if (this.translator instanceof Translator.StepTranslator) {
            translatedTraversal = (Traversal.Admin)this.translator.translate(bytecode);
        } else if (this.translator instanceof Translator.ScriptTranslator) {
            try {
                GremlinScriptEngine scriptEngine = SingleGremlinScriptEngineManager.get((String)this.translator.getTargetLanguage());
                Bindings bindings = scriptEngine.createBindings();
                bindings.putAll(scriptEngine.getContext().getBindings(100));
                bindings.put(this.translator.getTraversalSource().toString(), (Object)this.traversalSource);
                translatedTraversal = scriptEngine.eval(bytecode, bindings);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        } else {
            throw new IllegalArgumentException("TranslationStrategy does not know how to process the provided translator type: " + this.translator.getClass().getSimpleName());
        }
        assert (!translatedTraversal.isLocked());
        assert (!traversal.isLocked());
        traversal.setSideEffects(translatedTraversal.getSideEffects());
        TraversalHelper.removeAllSteps(traversal);
        TraversalHelper.removeToTraversal((Step)translatedTraversal.getStartStep(), (Step)EmptyStep.instance(), traversal);
    }

    public Set<Class<? extends TraversalStrategy.DecorationStrategy>> applyPost() {
        return POSTS;
    }

    private static final Bytecode insertBindingsForTesting(Bytecode bytecode) {
        Bytecode newBytecode = new Bytecode();
        bytecode.getSourceInstructions().forEach(instruction -> newBytecode.addSource(instruction.getOperator(), instruction.getArguments()));
        for (Bytecode.Instruction instruction2 : bytecode.getStepInstructions()) {
            Object[] args = instruction2.getArguments();
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                newArgs[i] = args[i].equals("knows") ? new Bytecode.Binding("a", (Object)"knows") : (args[i].equals("created") ? new Bytecode.Binding("b", (Object)"created") : (args[i].equals(10) ? new Bytecode.Binding("c", (Object)10) : args[i]));
            }
            newBytecode.addStep(instruction2.getOperator(), newArgs);
        }
        return newBytecode;
    }
}

