/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class OrderTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_V_name_order();

    public abstract Traversal<Vertex, String> get_g_V_name_order_byXa1_b1X_byXb2_a2X();

    public abstract Traversal<Vertex, String> get_g_V_order_byXname_incrX_name();

    public abstract Traversal<Vertex, String> get_g_V_order_byXnameX_name();

    public abstract Traversal<Vertex, Double> get_g_V_outE_order_byXweight_decrX_weight();

    public abstract Traversal<Vertex, String> get_g_V_order_byXname_a1_b1X_byXname_b2_a2X_name();

    public abstract Traversal<Vertex, Map<String, Vertex>> get_g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX();

    public abstract Traversal<Vertex, Map<Integer, Integer>> get_g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_decrX_byXkeys_incrX(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_order_byXoutE_count__decrX();

    public abstract Traversal<Vertex, Map<String, List<Vertex>>> get_g_V_group_byXlabelX_byXnameX_byXorderXlocalX_byXdecrXX();

    public abstract Traversal<Vertex, List<Double>> get_g_V_localXbothE_weight_foldX_order_byXsumXlocalX_decrX();

    public abstract Traversal<Vertex, Map<String, Object>> get_g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_decrX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasLabelXpersonX_order_byXageX();

    public abstract Traversal<Vertex, List<Vertex>> get_g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXsong_name_OHBOYX_outXfollowedByX_outXfollowedByX_order_byXperformancesX_byXsongType_incrX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_name_order() {
        Traversal<Vertex, String> traversal = this.get_g_V_name_order();
        this.printTraversalForm(traversal);
        OrderTest.assertCommon(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_name_order_byXa1_b1X_byXb2_a2X() {
        Traversal<Vertex, String> traversal = this.get_g_V_name_order_byXa1_b1X_byXb2_a2X();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)names.size(), (long)6L);
        Assert.assertEquals((Object)"marko", names.get(0));
        Assert.assertEquals((Object)"vadas", names.get(1));
        Assert.assertEquals((Object)"peter", names.get(2));
        Assert.assertEquals((Object)"ripple", names.get(3));
        Assert.assertEquals((Object)"josh", names.get(4));
        Assert.assertEquals((Object)"lop", names.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_order_byXname_incrX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_order_byXname_incrX_name();
        this.printTraversalForm(traversal);
        OrderTest.assertCommon(traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_order_byXnameX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_order_byXnameX_name();
        this.printTraversalForm(traversal);
        OrderTest.assertCommon(traversal);
    }

    private static void assertCommon(Traversal<Vertex, String> traversal) {
        List names = traversal.toList();
        Assert.assertEquals((long)names.size(), (long)6L);
        Assert.assertEquals((Object)"josh", names.get(0));
        Assert.assertEquals((Object)"lop", names.get(1));
        Assert.assertEquals((Object)"marko", names.get(2));
        Assert.assertEquals((Object)"peter", names.get(3));
        Assert.assertEquals((Object)"ripple", names.get(4));
        Assert.assertEquals((Object)"vadas", names.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outE_order_byXweight_decrX_weight() {
        Traversal<Vertex, Double> traversal = this.get_g_V_outE_order_byXweight_decrX_weight();
        this.printTraversalForm(traversal);
        List weights = traversal.toList();
        Assert.assertEquals((long)6L, (long)weights.size());
        Assert.assertEquals((Object)1.0, weights.get(0));
        Assert.assertEquals((Object)1.0, weights.get(1));
        Assert.assertEquals((Object)0.5, weights.get(2));
        Assert.assertEquals((Object)0.4, weights.get(3));
        Assert.assertEquals((Object)0.4, weights.get(4));
        Assert.assertEquals((Object)0.2, weights.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_order_byXname_a1_b1X_byXname_b2_a2X_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_order_byXname_a1_b1X_byXname_b2_a2X_name();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)names.size(), (long)6L);
        Assert.assertEquals((Object)"marko", names.get(0));
        Assert.assertEquals((Object)"vadas", names.get(1));
        Assert.assertEquals((Object)"peter", names.get(2));
        Assert.assertEquals((Object)"ripple", names.get(3));
        Assert.assertEquals((Object)"josh", names.get(4));
        Assert.assertEquals((Object)"lop", names.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX() {
        Traversal<Vertex, Map<String, Vertex>> traversal = this.get_g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX();
        this.printTraversalForm(traversal);
        int counter = 0;
        int markoCounter = 0;
        int joshCounter = 0;
        int peterCounter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Map bindings = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)bindings.size());
            if (((Vertex)bindings.get("a")).id().equals(this.convertToVertexId("marko"))) {
                Assert.assertEquals((Object)this.convertToVertexId("lop"), (Object)((Vertex)bindings.get("b")).id());
                ++markoCounter;
                continue;
            }
            if (((Vertex)bindings.get("a")).id().equals(this.convertToVertexId("josh"))) {
                Assert.assertTrue((((Vertex)bindings.get("b")).id().equals(this.convertToVertexId("lop")) || ((Vertex)bindings.get("b")).id().equals(this.convertToVertexId("ripple")) ? 1 : 0) != 0);
                ++joshCounter;
                continue;
            }
            if (((Vertex)bindings.get("a")).id().equals(this.convertToVertexId("peter"))) {
                Assert.assertEquals((Object)this.convertToVertexId("lop"), (Object)((Vertex)bindings.get("b")).id());
                ++peterCounter;
                continue;
            }
            Assert.fail((String)"This state should not have been reachable");
        }
        Assert.assertEquals((long)4L, (long)(markoCounter + joshCounter + peterCounter));
        Assert.assertEquals((long)1L, (long)markoCounter);
        Assert.assertEquals((long)1L, (long)peterCounter);
        Assert.assertEquals((long)2L, (long)joshCounter);
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_decrX_byXkeys_incrX() {
        Traversal<Vertex, Map<Integer, Integer>> traversal = this.get_g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_decrX_byXkeys_incrX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)4L, (long)map.size());
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = iterator.next();
        Assert.assertEquals((long)3L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((long)87L, (long)((Integer)entry.getValue()).intValue());
        entry = iterator.next();
        Assert.assertEquals((long)2L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((long)58L, (long)((Integer)entry.getValue()).intValue());
        entry = iterator.next();
        Assert.assertEquals((long)1L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((long)29L, (long)((Integer)entry.getValue()).intValue());
        entry = iterator.next();
        Assert.assertEquals((long)4L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((long)29L, (long)((Integer)entry.getValue()).intValue());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_order_byXoutE_count__decrX() {
        Arrays.asList(this.get_g_V_order_byXoutE_count__decrX()).forEach(traversal -> {
            this.printTraversalForm((Traversal)traversal);
            List vertices = traversal.toList();
            Assert.assertEquals((long)vertices.size(), (long)6L);
            Assert.assertEquals((Object)"marko", (Object)((Vertex)vertices.get(0)).value("name"));
            Assert.assertEquals((Object)"josh", (Object)((Vertex)vertices.get(1)).value("name"));
            Assert.assertEquals((Object)"peter", (Object)((Vertex)vertices.get(2)).value("name"));
            Assert.assertTrue((((Vertex)vertices.get(3)).value("name").equals("vadas") || ((Vertex)vertices.get(3)).value("name").equals("ripple") || ((Vertex)vertices.get(3)).value("name").equals("lop") ? 1 : 0) != 0);
            Assert.assertTrue((((Vertex)vertices.get(4)).value("name").equals("vadas") || ((Vertex)vertices.get(4)).value("name").equals("ripple") || ((Vertex)vertices.get(4)).value("name").equals("lop") ? 1 : 0) != 0);
            Assert.assertTrue((((Vertex)vertices.get(5)).value("name").equals("vadas") || ((Vertex)vertices.get(5)).value("name").equals("ripple") || ((Vertex)vertices.get(5)).value("name").equals("lop") ? 1 : 0) != 0);
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_group_byXlabelX_byXnameX_byXorderXlocalX_byXdecrXX() {
        Traversal<Vertex, Map<String, List<Vertex>>> traversal = this.get_g_V_group_byXlabelX_byXnameX_byXorderXlocalX_byXdecrXX();
        this.printTraversalForm(traversal);
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        List list = (List)map.get("software");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"lop", list.get(1));
        Assert.assertEquals((Object)"ripple", list.get(0));
        list = (List)map.get("person");
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"josh", list.get(3));
        Assert.assertEquals((Object)"marko", list.get(2));
        Assert.assertEquals((Object)"peter", list.get(1));
        Assert.assertEquals((Object)"vadas", list.get(0));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_localXbothE_weight_foldX_order_byXsumXlocalX_decrX() {
        Traversal<Vertex, List<Double>> traversal = this.get_g_V_localXbothE_weight_foldX_order_byXsumXlocalX_decrX();
        List list = traversal.toList();
        Assert.assertEquals((long)((List)list.get(0)).size(), (long)3L);
        Assert.assertEquals((long)((List)list.get(1)).size(), (long)3L);
        Assert.assertEquals((long)((List)list.get(4)).size(), (long)1L);
        Assert.assertEquals((long)((List)list.get(5)).size(), (long)1L);
        Assert.assertEquals((double)2.4, (double)((List)list.get(0)).stream().reduce(0.0, (a, b) -> a + b), (double)0.01);
        Assert.assertEquals((double)1.9, (double)((List)list.get(1)).stream().reduce(0.0, (a, b) -> a + b), (double)0.01);
        Assert.assertEquals((double)1.0, (double)((List)list.get(2)).stream().reduce(0.0, (a, b) -> a + b), (double)0.01);
        Assert.assertEquals((double)1.0, (double)((List)list.get(3)).stream().reduce(0.0, (a, b) -> a + b), (double)0.01);
        Assert.assertEquals((double)0.5, (double)((List)list.get(4)).stream().reduce(0.0, (a, b) -> a + b), (double)0.01);
        Assert.assertEquals((double)0.2, (double)((List)list.get(5)).stream().reduce(0.0, (a, b) -> a + b), (double)0.01);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_decrX() {
        Traversal<Vertex, Map<String, Object>> traversal = this.get_g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_decrX();
        List list = traversal.toList();
        Assert.assertEquals((Object)this.convertToVertex(this.graph, "josh"), ((Map)list.get(0)).get("v"));
        Assert.assertEquals((double)2.4, (double)((Double)((Map)list.get(0)).get("s")), (double)0.1);
        Assert.assertEquals((Object)this.convertToVertex(this.graph, "marko"), ((Map)list.get(1)).get("v"));
        Assert.assertEquals((double)1.9, (double)((Double)((Map)list.get(1)).get("s")), (double)0.1);
        Assert.assertEquals((double)1.0, (double)((Double)((Map)list.get(2)).get("s")), (double)0.1);
        Assert.assertEquals((double)1.0, (double)((Double)((Map)list.get(3)).get("s")), (double)0.1);
        Assert.assertEquals((Object)this.convertToVertex(this.graph, "vadas"), ((Map)list.get(4)).get("v"));
        Assert.assertEquals((double)0.5, (double)((Double)((Map)list.get(4)).get("s")), (double)0.1);
        Assert.assertEquals((Object)this.convertToVertex(this.graph, "peter"), ((Map)list.get(5)).get("v"));
        Assert.assertEquals((double)0.2, (double)((Double)((Map)list.get(5)).get("s")), (double)0.1);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_order_byXageX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasLabelXpersonX_order_byXageX();
        this.printTraversalForm(traversal);
        OrderTest.checkResults(Arrays.asList(this.convertToVertex(this.graph, "vadas"), this.convertToVertex(this.graph, "marko"), this.convertToVertex(this.graph, "josh"), this.convertToVertex(this.graph, "peter")), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX() {
        Traversal<Vertex, List<Vertex>> traversal = this.get_g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX();
        this.printTraversalForm(traversal);
        List list = (List)traversal.next();
        Assert.assertEquals((Object)this.convertToVertex(this.graph, "vadas"), list.get(0));
        Assert.assertEquals((Object)this.convertToVertex(this.graph, "marko"), list.get(1));
        Assert.assertEquals((Object)this.convertToVertex(this.graph, "josh"), list.get(2));
        Assert.assertEquals((Object)this.convertToVertex(this.graph, "peter"), list.get(3));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void g_V_hasXsong_name_OHBOYX_outXfollowedByX_outXfollowedByX_order_byXperformancesX_byXsongType_incrX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXsong_name_OHBOYX_outXfollowedByX_outXfollowedByX_order_byXperformancesX_byXsongType_incrX();
        int counter = 0;
        String lastSongType = "a";
        int lastPerformances = Integer.MIN_VALUE;
        while (traversal.hasNext()) {
            Vertex vertex = (Vertex)traversal.next();
            String currentSongType = (String)vertex.value("songType");
            int currentPerformances = (Integer)vertex.value("performances");
            Assert.assertTrue((currentPerformances == lastPerformances || currentPerformances > lastPerformances ? 1 : 0) != 0);
            if (currentPerformances == lastPerformances) {
                Assert.assertTrue((currentSongType.equals(lastSongType) || currentSongType.compareTo(lastSongType) < 0 ? 1 : 0) != 0);
            }
            lastSongType = currentSongType;
            lastPerformances = currentPerformances;
            ++counter;
        }
        Assert.assertEquals((long)144L, (long)counter);
    }

    public static class Traversals
    extends OrderTest {
        @Override
        public Traversal<Vertex, String> get_g_V_name_order() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).order();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_name_order_byXa1_b1X_byXb2_a2X() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).order().by((a, b) -> a.substring(1, 2).compareTo(b.substring(1, 2))).by((a, b) -> b.substring(2, 3).compareTo(a.substring(2, 3)));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXname_incrX_name() {
            return this.g.V(new Object[0]).order().by("name", (Comparator)Order.incr).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXnameX_name() {
            return this.g.V(new Object[0]).order().by("name").values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_outE_order_byXweight_decrX_weight() {
            return this.g.V(new Object[0]).outE(new String[0]).order().by("weight", (Comparator)Order.decr).values(new String[]{"weight"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXname_a1_b1X_byXname_b2_a2X_name() {
            return this.g.V(new Object[0]).order().by("name", (a, b) -> a.substring(1, 2).compareTo(b.substring(1, 2))).by("name", (a, b) -> b.substring(2, 3).compareTo(a.substring(2, 3))).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Map<String, Vertex>> get_g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX() {
            return this.g.V(new Object[0]).as("a", new String[0]).out(new String[]{"created"}).as("b", new String[0]).order().by(Order.shuffle).select("a", "b", new String[0]);
        }

        @Override
        public Traversal<Vertex, Map<Integer, Integer>> get_g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_decrX_byXkeys_incrX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).hasLabel(new String[]{"person"}).map(v -> {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                map.put(1, (Integer)((Vertex)v.get()).value("age"));
                map.put(2, (Integer)((Vertex)v.get()).value("age") * 2);
                map.put(3, (Integer)((Vertex)v.get()).value("age") * 3);
                map.put(4, (Integer)((Vertex)v.get()).value("age"));
                return map;
            }).order(Scope.local).by(Column.values, (Comparator)Order.decr).by(Column.keys, (Comparator)Order.incr);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_order_byXoutE_count__decrX() {
            return this.g.V(new Object[0]).order().by((Traversal)__.outE((String[])new String[0]).count(), (Comparator)Order.decr);
        }

        @Override
        public Traversal<Vertex, Map<String, List<Vertex>>> get_g_V_group_byXlabelX_byXnameX_byXorderXlocalX_byXdecrXX() {
            return this.g.V(new Object[0]).group().by(T.label).by((Traversal)__.values((String[])new String[]{"name"}).order().by(Order.decr).fold());
        }

        @Override
        public Traversal<Vertex, List<Double>> get_g_V_localXbothE_weight_foldX_order_byXsumXlocalX_decrX() {
            return this.g.V(new Object[0]).local((Traversal)__.bothE((String[])new String[0]).values(new String[]{"weight"}).fold()).order().by((Traversal)__.sum((Scope)Scope.local), (Comparator)Order.decr);
        }

        @Override
        public Traversal<Vertex, Map<String, Object>> get_g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_decrX() {
            return this.g.V(new Object[0]).as("v", new String[0]).map((Traversal)__.bothE((String[])new String[0]).values(new String[]{"weight"}).fold()).sum(Scope.local).as("s", new String[0]).select("v", "s", new String[0]).order().by((Traversal)__.select((String)"s"), (Comparator)Order.decr);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasLabelXpersonX_order_byXageX() {
            return this.g.V(new Object[0]).hasLabel(new String[]{"person"}).order().by("age");
        }

        @Override
        public Traversal<Vertex, List<Vertex>> get_g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX() {
            return this.g.V(new Object[0]).hasLabel(new String[]{"person"}).fold().order(Scope.local).by("age");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXsong_name_OHBOYX_outXfollowedByX_outXfollowedByX_order_byXperformancesX_byXsongType_incrX() {
            return this.g.V(new Object[0]).has("song", "name", (Object)"OH BOY").out(new String[]{"followedBy"}).out(new String[]{"followedBy"}).order().by("performances").by("songType", (Comparator)Order.decr);
        }
    }
}

