/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class EdgeTest {

    @ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"labelCanNotBeNull", "labelCanNotBeEmpty", "labelCanNotBeAHiddenKey"})
    public static class BasicEdgeTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
        public void shouldValidateEquality() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e1 = v.addEdge("self", v, new Object[0]);
            Edge e2 = v.addEdge("self", v, new Object[0]);
            Assert.assertEquals((Object)e1, (Object)e1);
            Assert.assertEquals((Object)e2, (Object)e2);
            Assert.assertNotEquals((Object)e1, (Object)e2);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
        public void shouldValidateIdEquality() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e1 = v.addEdge("self", v, new Object[0]);
            Edge e2 = v.addEdge("self", v, new Object[0]);
            Assert.assertEquals((Object)e1.id(), (Object)e1.id());
            Assert.assertEquals((Object)e2.id(), (Object)e2.id());
            Assert.assertEquals((Object)e1.id().toString(), (Object)e1.id().toString());
            Assert.assertEquals((Object)e2.id().toString(), (Object)e2.id().toString());
            Assert.assertNotEquals((Object)e1.id(), (Object)e2.id());
            Assert.assertNotEquals((Object)e1.id().toString(), (Object)e2.id().toString());
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldHaveStandardStringRepresentation() {
            Vertex v1 = this.graph.addVertex(new Object[0]);
            Vertex v2 = this.graph.addVertex(new Object[0]);
            Edge e = v1.addEdge("friends", v2, new Object[0]);
            Assert.assertEquals((Object)StringFactory.edgeString((Edge)e), (Object)e.toString());
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldHaveExceptionConsistencyWhenUsingNullEdgeLabel() {
            Vertex v = this.graph.addVertex(new Object[0]);
            try {
                v.addEdge(null, v, new Object[0]);
                Assert.fail((String)"Call to Vertex.addEdge() should throw an exception when label is null");
            }
            catch (Exception ex) {
                BasicEdgeTest.validateException(Element.Exceptions.labelCanNotBeNull(), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldHaveExceptionConsistencyWhenUsingNullVertex() {
            Vertex v = this.graph.addVertex(new Object[0]);
            try {
                v.addEdge("tonothing", null, new Object[0]);
                Assert.fail((String)"Call to Vertex.addEdge() should throw an exception when vertex is null");
            }
            catch (Exception ex) {
                BasicEdgeTest.validateException(Graph.Exceptions.argumentCanNotBeNull((String)"vertex"), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldHaveExceptionConsistencyWhenUsingEmptyVertexLabel() {
            Vertex v = this.graph.addVertex(new Object[0]);
            try {
                v.addEdge("", v, new Object[0]);
                Assert.fail((String)"Call to Vertex.addEdge() should throw an exception when label is empty");
            }
            catch (Exception ex) {
                BasicEdgeTest.validateException(Element.Exceptions.labelCanNotBeEmpty(), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldHaveExceptionConsistencyWhenUsingSystemVertexLabel() {
            String label = Graph.Hidden.hide((String)"systemLabel");
            Vertex v = this.graph.addVertex(new Object[0]);
            try {
                v.addEdge(label, v, new Object[0]);
                Assert.fail((String)"Call to Vertex.addEdge() should throw an exception when label is a system key");
            }
            catch (Exception ex) {
                BasicEdgeTest.validateException(Element.Exceptions.labelCanNotBeAHiddenKey((String)label), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="StringValues")})
        public void shouldAutotypeStringProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[]{"string", "marko"});
            String name = (String)e.value("string");
            Assert.assertEquals((Object)name, (Object)"marko");
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="IntegerValues")})
        public void shouldAutotypeIntegerProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[]{"integer", 33});
            Integer age = (Integer)e.value("integer");
            Assert.assertEquals((Object)33, (Object)age);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="BooleanValues")})
        public void shouldAutotypeBooleanProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[]{"boolean", true});
            Boolean best = (Boolean)e.value("boolean");
            Assert.assertEquals((Object)best, (Object)true);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
        public void shouldAutotypeDoubleProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[]{"double", 0.1});
            Double best = (Double)e.value("double");
            Assert.assertEquals((Object)best, (Object)0.1);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="LongValues")})
        public void shouldAutotypeLongProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[]{"long", 1L});
            Long best = (Long)e.value("long");
            Assert.assertEquals((Object)best, (Object)1L);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues")})
        public void shouldAutotypeFloatProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[]{"float", Float.valueOf(0.1f)});
            Float best = (Float)e.value("float");
            Assert.assertEquals((Object)best, (Object)Float.valueOf(0.1f));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="StringValues")})
        public void shouldGetPropertyKeysOnEdge() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("friend", v, new Object[]{"name", "marko", "location", "desert", "status", "dope"});
            Set keys = e.keys();
            Assert.assertEquals((long)3L, (long)keys.size());
            Assert.assertTrue((boolean)keys.contains("name"));
            Assert.assertTrue((boolean)keys.contains("location"));
            Assert.assertTrue((boolean)keys.contains("status"));
            List m = IteratorUtils.list((Iterator)e.properties(new String[0]));
            Assert.assertEquals((long)3L, (long)m.size());
            Assert.assertTrue((boolean)m.stream().anyMatch(p -> p.key().equals("name")));
            Assert.assertTrue((boolean)m.stream().anyMatch(p -> p.key().equals("location")));
            Assert.assertTrue((boolean)m.stream().anyMatch(p -> p.key().equals("status")));
            Assert.assertEquals((Object)"marko", m.stream().filter(p -> p.key().equals("name")).map(Property::value).findAny().orElse(null));
            Assert.assertEquals((Object)"desert", m.stream().filter(p -> p.key().equals("location")).map(Property::value).findAny().orElse(null));
            Assert.assertEquals((Object)"dope", m.stream().filter(p -> p.key().equals("status")).map(Property::value).findAny().orElse(null));
            e.property("status").remove();
            keys = e.keys();
            Assert.assertEquals((long)2L, (long)keys.size());
            Assert.assertTrue((boolean)keys.contains("name"));
            Assert.assertTrue((boolean)keys.contains("location"));
            e.properties(new String[0]).forEachRemaining(Property::remove);
            keys = e.keys();
            Assert.assertEquals((long)0L, (long)keys.size());
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldNotGetConcurrentModificationException() {
            for (int i = 0; i < 25; ++i) {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("friend", v, new Object[0]);
            }
            this.tryCommit(this.graph, BasicEdgeTest.getAssertVertexEdgeCounts(25, 25));
            for (Edge e : this.g.E(new Object[0]).toList()) {
                e.remove();
                this.tryCommit(this.graph);
            }
            this.tryCommit(this.graph, BasicEdgeTest.getAssertVertexEdgeCounts(25, 0));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges")})
        public void shouldNotHaveAConcurrentModificationExceptionWhenIteratingAndRemovingAddingEdges() {
            Vertex v1 = this.graph.addVertex(new Object[]{"name", "marko"});
            Vertex v2 = this.graph.addVertex(new Object[]{"name", "puppy"});
            v1.addEdge("knows", v2, new Object[]{"since", 2010});
            v1.addEdge("pets", v2, new Object[0]);
            v1.addEdge("walks", v2, new Object[]{"location", "arroyo"});
            v2.addEdge("knows", v1, new Object[]{"since", 2010});
            Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)v1.edges(Direction.BOTH, new String[0])));
            Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)v2.edges(Direction.BOTH, new String[0])));
            v1.edges(Direction.BOTH, new String[0]).forEachRemaining(edge -> {
                v1.addEdge("livesWith", v2, new Object[0]);
                v1.addEdge("walks", v2, new Object[]{"location", "river"});
                edge.remove();
            });
            v1.edges(Direction.BOTH, new String[0]).forEachRemaining(Element::remove);
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v1.edges(Direction.BOTH, new String[0])));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v2.edges(Direction.BOTH, new String[0])));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldReturnEmptyIteratorIfNoProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[0]);
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)e.properties(new String[0])));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldReturnOutThenInOnVertexIterator() {
            Vertex a = this.graph.addVertex(new Object[0]);
            Vertex b = this.graph.addVertex(new Object[0]);
            Edge e = a.addEdge("knows", b, new Object[0]);
            Assert.assertEquals((Object)a, (Object)e.outVertex());
            Assert.assertEquals((Object)b, (Object)e.inVertex());
            Iterator iterator = e.vertices(Direction.BOTH);
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)a, iterator.next());
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)b, iterator.next());
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }
}

