/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.socket.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import org.apache.tinkerpop.gremlin.socket.server.SocketServerSettings;
import org.apache.tinkerpop.gremlin.socket.server.TestHandlers;
import org.apache.tinkerpop.gremlin.socket.server.TestWSGremlinInitializer;

public class TestChannelizers {

    public static class TestConnectionThrottlingInitializer
    extends TestHttpServerInitializer {
        int connectionCount = 0;
        private SocketServerSettings settings;

        public TestConnectionThrottlingInitializer(SocketServerSettings settings) {
            this.settings = settings;
        }

        @Override
        public void initChannel(SocketChannel ch) {
            super.initChannel(ch);
            ChannelPipeline pipeline = ch.pipeline();
            if (this.connectionCount < 1) {
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/gremlin", null, true)});
                pipeline.addLast(new ChannelHandler[]{new TestWSGremlinInitializer.ClientTestConfigurableHandler(this.settings)});
            } else {
                pipeline.addLast(new ChannelHandler[]{new TestHandlers.NoOpWebSocketServerHandler("/gremlin")});
            }
            ++this.connectionCount;
        }
    }

    public static class TestWSNoOpInitializer
    extends TestHttpServerInitializer {
        @Override
        public void initChannel(SocketChannel ch) {
            super.initChannel(ch);
            ch.pipeline().addLast(new ChannelHandler[]{new TestHandlers.NoOpWebSocketServerHandler("/gremlin")});
        }
    }

    public static abstract class TestWebSocketServerInitializer
    extends TestHttpServerInitializer {
        @Override
        public void initChannel(SocketChannel ch) {
            super.initChannel(ch);
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
            pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/gremlin", null, true)});
            this.postInit(ch.pipeline());
        }

        public abstract void postInit(ChannelPipeline var1);
    }

    public static abstract class TestHttpServerInitializer
    extends ChannelInitializer<SocketChannel> {
        protected static final String WEBSOCKET_PATH = "/gremlin";

        public void initChannel(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        }
    }
}

