/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.authz.AuthorizationException;
import org.apache.tinkerpop.gremlin.server.authz.Authorizer;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketAuthorizationHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketAuthorizationHandler.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    private AuthenticatedUser user;
    private final Authorizer authorizer;

    public WebSocketAuthorizationHandler(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)msg;
            try {
                this.user = (AuthenticatedUser)ctx.channel().attr(StateKey.AUTHENTICATED_USER).get();
                if (null == this.user) {
                    this.user = AuthenticatedUser.ANONYMOUS_USER;
                }
                switch (requestMessage.getOp()) {
                    case "bytecode": {
                        Bytecode bytecode = (Bytecode)requestMessage.getArgs().get("gremlin");
                        Map aliases = (Map)requestMessage.getArgs().get("aliases");
                        Bytecode restrictedBytecode = this.authorizer.authorize(this.user, bytecode, aliases);
                        RequestMessage restrictedMsg = RequestMessage.from((RequestMessage)requestMessage).addArg("gremlin", (Object)restrictedBytecode).addArg("aliases", (Object)aliases).create();
                        ctx.fireChannelRead((Object)restrictedMsg);
                        break;
                    }
                    case "eval": {
                        this.authorizer.authorize(this.user, requestMessage);
                        ctx.fireChannelRead((Object)requestMessage);
                        break;
                    }
                    default: {
                        throw new AuthorizationException("This AuthorizationHandler only handles requests with OPS_BYTECODE or OPS_EVAL.");
                    }
                }
            }
            catch (AuthorizationException ex) {
                String address = ctx.channel().remoteAddress().toString();
                if (address.startsWith("/") && address.length() > 1) {
                    address = address.substring(1);
                }
                auditLogger.info("User {} with address {} attempted an unauthorized request for {} operation: {}", new Object[]{this.user.getName(), address, requestMessage.getOp(), requestMessage.getArgs().get("gremlin")});
                this.interruptEvaluation(ctx, requestMessage, ex.getMessage());
            }
            catch (Exception ex) {
                logger.error("{} is not ready to handle requests - unknown error", (Object)this.authorizer.getClass().getSimpleName());
                this.interruptEvaluation(ctx, requestMessage, "Unknown error in gremlin-server");
            }
        } else {
            logger.warn("{} only processes RequestMessage instances - received {} - channel closing", (Object)((Object)((Object)this)).getClass().getSimpleName(), msg.getClass());
            ctx.close();
        }
    }

    private void interruptEvaluation(ChannelHandlerContext ctx, RequestMessage requestMessage, String errorMessage) {
        ResponseMessage error = ResponseMessage.build((RequestMessage)requestMessage).statusMessage("Failed to authorize: " + errorMessage).code(ResponseStatusCode.UNAUTHORIZED).create();
        ctx.writeAndFlush((Object)error);
    }
}

