/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.session.Session;
import org.apache.tinkerpop.gremlin.server.util.ExceptionHelper;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class GremlinResponseFrameEncoder
extends MessageToMessageEncoder<ResponseMessage> {
    private static final Logger logger = LoggerFactory.getLogger(GremlinResponseFrameEncoder.class);
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));

    protected void encode(ChannelHandlerContext ctx, ResponseMessage o, List<Object> objects) throws Exception {
        MessageSerializer serializer = (MessageSerializer)ctx.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)ctx.channel().attr(StateKey.USE_BINARY).get();
        Session session = (Session)ctx.channel().attr(StateKey.SESSION).get();
        try {
            if (!o.getStatus().getCode().isSuccess()) {
                errorMeter.mark();
            }
            if (useBinary) {
                Frame serialized = null == session || !o.getStatus().getCode().isSuccess() ? new Frame(serializer.serializeResponseAsBinary(o, ctx.alloc())) : new Frame(session.getExecutor().submit(() -> serializer.serializeResponseAsBinary(o, ctx.alloc())).get());
                objects.add(serialized);
            } else {
                MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
                Frame serialized = null == session || !o.getStatus().getCode().isSuccess() ? new Frame(textSerializer.serializeResponseAsString(o, ctx.alloc())) : new Frame(session.getExecutor().submit(() -> textSerializer.serializeResponseAsString(o, ctx.alloc())).get());
                objects.add(serialized);
            }
        }
        catch (Exception ex) {
            errorMeter.mark();
            logger.warn("The result [{}] in the request {} could not be serialized and returned.", new Object[]{o.getResult(), o.getRequestId(), ex});
            String errorMessage = String.format("Error during serialization: %s", ExceptionHelper.getMessageFromExceptionOrCause(ex));
            ResponseMessage error = ResponseMessage.build((UUID)o.getRequestId()).statusMessage(errorMessage).statusAttributeException((Throwable)ex).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).create();
            if (useBinary) {
                objects.add(serializer.serializeResponseAsBinary(error, ctx.alloc()));
            }
            MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
            objects.add(textSerializer.serializeResponseAsString(error, ctx.alloc()));
        }
    }
}

