/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.Channelizer;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.IteratorHandler;
import org.apache.tinkerpop.gremlin.server.handler.OpExecutorHandler;
import org.apache.tinkerpop.gremlin.server.handler.OpSelectorHandler;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelizer
extends ChannelInitializer<SocketChannel>
implements Channelizer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelizer.class);
    protected static final List<Settings.SerializerSettings> DEFAULT_SERIALIZERS = Arrays.asList(new Settings.SerializerSettings(GryoMessageSerializerV1d0.class.getName(), Collections.emptyMap()), new Settings.SerializerSettings(GryoMessageSerializerV1d0.class.getName(), (Map<String, Object>)new HashMap<String, Object>(){
        {
            this.put("serializeResultToString", true);
        }
    }), new Settings.SerializerSettings(GraphSONMessageSerializerV1d0.class.getName(), Collections.emptyMap()));
    protected Settings settings;
    protected GremlinExecutor gremlinExecutor;
    protected Optional<SslContext> sslContext;
    protected GraphManager graphManager;
    protected ExecutorService gremlinExecutorService;
    protected ScheduledExecutorService scheduledExecutorService;
    public static final String PIPELINE_AUTHENTICATOR = "authenticator";
    public static final String PIPELINE_REQUEST_HANDLER = "request-handler";
    public static final String PIPELINE_HTTP_RESPONSE_ENCODER = "http-response-encoder";
    protected static final String PIPELINE_SSL = "ssl";
    protected static final String PIPELINE_OP_SELECTOR = "op-selector";
    protected static final String PIPELINE_RESULT_ITERATOR_HANDLER = "result-iterator-handler";
    protected static final String PIPELINE_OP_EXECUTOR = "op-executor";
    protected static final String PIPELINE_HTTP_REQUEST_DECODER = "http-request-decoder";
    protected static final String GREMLIN_ENDPOINT = "/gremlin";
    protected final Map<String, MessageSerializer> serializers = new HashMap<String, MessageSerializer>();
    private IdleStateHandler idleStateHandler;
    private OpSelectorHandler opSelectorHandler;
    private OpExecutorHandler opExecutorHandler;
    private IteratorHandler iteratorHandler;
    protected Authenticator authenticator;

    public abstract void configure(ChannelPipeline var1);

    public void finalize(ChannelPipeline pipeline) {
    }

    @Override
    public void init(ServerGremlinExecutor<EventLoopGroup> serverGremlinExecutor) {
        this.settings = serverGremlinExecutor.getSettings();
        this.gremlinExecutor = serverGremlinExecutor.getGremlinExecutor();
        this.graphManager = serverGremlinExecutor.getGraphManager();
        this.gremlinExecutorService = serverGremlinExecutor.getGremlinExecutorService();
        this.scheduledExecutorService = serverGremlinExecutor.getScheduledExecutorService();
        this.configureSerializers();
        Optional<Object> optional = this.sslContext = this.settings.optionalSsl().isPresent() && this.settings.ssl.enabled ? Optional.ofNullable(this.createSSLContext(this.settings)) : Optional.empty();
        if (this.sslContext.isPresent()) {
            logger.info("SSL enabled");
        }
        this.authenticator = this.createAuthenticator(this.settings.authentication);
        this.opSelectorHandler = new OpSelectorHandler(this.settings, this.graphManager, this.gremlinExecutor, this.scheduledExecutorService, this);
        this.opExecutorHandler = new OpExecutorHandler(this.settings, this.graphManager, this.gremlinExecutor, this.scheduledExecutorService);
        this.iteratorHandler = new IteratorHandler(this.settings);
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        this.sslContext.ifPresent(sslContext -> pipeline.addLast(PIPELINE_SSL, (ChannelHandler)sslContext.newHandler(ch.alloc())));
        if (this.supportsIdleMonitor()) {
            int idleConnectionTimeout = (int)(this.settings.idleConnectionTimeout / 1000L);
            int keepAliveInterval = (int)(this.settings.keepAliveInterval / 1000L);
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(idleConnectionTimeout, keepAliveInterval, 0)});
        }
        this.configure(pipeline);
        pipeline.addLast(PIPELINE_OP_SELECTOR, (ChannelHandler)this.opSelectorHandler);
        pipeline.addLast(PIPELINE_RESULT_ITERATOR_HANDLER, (ChannelHandler)this.iteratorHandler);
        pipeline.addLast(PIPELINE_OP_EXECUTOR, (ChannelHandler)this.opExecutorHandler);
        this.finalize(pipeline);
    }

    protected AbstractAuthenticationHandler createAuthenticationHandler(Settings.AuthenticationSettings config) {
        try {
            Class<?> clazz = Class.forName(config.authenticationHandler);
            Class[] constructorArgs = new Class[]{Authenticator.class};
            return (AbstractAuthenticationHandler)((Object)clazz.getDeclaredConstructor(constructorArgs).newInstance(this.authenticator));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
            throw new IllegalStateException(String.format("Could not create/configure AuthenticationHandler %s", config.authenticationHandler), ex);
        }
    }

    private Authenticator createAuthenticator(Settings.AuthenticationSettings config) {
        String authenticatorClass = null;
        authenticatorClass = config.authenticator == null ? config.className : config.authenticator;
        try {
            Class<?> clazz = Class.forName(authenticatorClass);
            Authenticator authenticator = (Authenticator)clazz.newInstance();
            authenticator.setup(config.config);
            return authenticator;
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
            throw new IllegalStateException(String.format("Could not create/configure Authenticator %s", this.authenticator), ex);
        }
    }

    private void configureSerializers() {
        List<Settings.SerializerSettings> serializerSettings = null == this.settings.serializers || this.settings.serializers.isEmpty() ? DEFAULT_SERIALIZERS : this.settings.serializers;
        serializerSettings.stream().map(config -> {
            try {
                Class<?> clazz = Class.forName(config.className);
                if (!MessageSerializer.class.isAssignableFrom(clazz)) {
                    logger.warn("The {} serialization class does not implement {} - it will not be available.", (Object)config.className, (Object)MessageSerializer.class.getCanonicalName());
                    return Optional.empty();
                }
                if (clazz.getAnnotation(Deprecated.class) != null) {
                    logger.warn("The {} serialization class is deprecated.", (Object)config.className);
                }
                MessageSerializer serializer = (MessageSerializer)clazz.newInstance();
                HashMap<String, Graph> graphsDefinedAtStartup = new HashMap<String, Graph>();
                for (String graphName : this.settings.graphs.keySet()) {
                    graphsDefinedAtStartup.put(graphName, this.graphManager.getGraph(graphName));
                }
                if (config.config != null) {
                    if (config.config.containsKey("useMapperFromGraph")) {
                        logger.warn("{} utilizes the {} configuration setting which is deprecated - prefer use of {}", new Object[]{config.className, "useMapperFromGraph", "ioRegistries"});
                    }
                    serializer.configure(config.config, graphsDefinedAtStartup);
                }
                return Optional.ofNullable(serializer);
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn("Could not find configured serializer class - {} - it will not be available", (Object)config.className);
                return Optional.empty();
            }
            catch (Exception ex) {
                logger.warn("Could not instantiate configured serializer class - {} - it will not be available. {}", (Object)config.className, (Object)ex.getMessage());
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).flatMap(serializer -> Stream.of(serializer.mimeTypesSupported()).map(mimeType -> Pair.with((Object)mimeType, (Object)serializer))).forEach(pair -> {
            String mimeType = (String)pair.getValue0();
            MessageSerializer serializer = (MessageSerializer)pair.getValue1();
            if (this.serializers.containsKey(mimeType)) {
                logger.info("{} already has {} configured - it will not be replaced by {}.", new Object[]{mimeType, this.serializers.get(mimeType).getClass().getName(), serializer.getClass().getName()});
            } else {
                logger.info("Configured {} with {}", (Object)mimeType, (Object)((MessageSerializer)pair.getValue1()).getClass().getName());
                this.serializers.put(mimeType, serializer);
            }
        });
        if (this.serializers.size() == 0) {
            logger.error("No serializers were successfully configured - server will not start.");
            throw new RuntimeException("Serialization configuration error.");
        }
    }

    private SslContext createSSLContext(Settings settings) {
        SslContextBuilder builder;
        SslProvider provider;
        Settings.SslSettings sslSettings;
        block36: {
            sslSettings = settings.ssl;
            if (sslSettings.getSslContext().isPresent()) {
                logger.info("Using the SslContext override");
                return sslSettings.getSslContext().get();
            }
            provider = SslProvider.JDK;
            if (null != sslSettings.keyCertChainFile && null != sslSettings.keyFile) {
                logger.warn("Using deprecated SSL keyFile support");
                File keyCertChainFile = new File(sslSettings.keyCertChainFile);
                File keyFile = new File(sslSettings.keyFile);
                File trustCertChainFile = null == sslSettings.trustCertChainFile ? null : new File(sslSettings.trustCertChainFile);
                builder = SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)sslSettings.keyPassword).trustManager(trustCertChainFile);
            } else {
                try {
                    Throwable throwable;
                    FileInputStream in;
                    char[] password;
                    KeyStore keystore;
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    if (null != sslSettings.keyStore) {
                        String keyStoreType = null == sslSettings.keyStoreType ? KeyStore.getDefaultType() : sslSettings.keyStoreType;
                        keystore = KeyStore.getInstance(keyStoreType);
                        password = null == sslSettings.keyStorePassword ? null : sslSettings.keyStorePassword.toCharArray();
                        in = new FileInputStream(sslSettings.keyStore);
                        throwable = null;
                        try {
                            keystore.load(in, password);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStream)in).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((InputStream)in).close();
                                }
                            }
                        }
                    } else {
                        throw new IllegalStateException("keyStore must be configured when SSL is enabled.");
                    }
                    kmf.init(keystore, password);
                    builder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
                    if (null == sslSettings.trustStore) break block36;
                    String keystoreType = null == sslSettings.keyStoreType ? KeyStore.getDefaultType() : sslSettings.keyStoreType;
                    KeyStore truststore = KeyStore.getInstance(keystoreType);
                    password = null == sslSettings.trustStorePassword ? null : sslSettings.trustStorePassword.toCharArray();
                    in = new FileInputStream(sslSettings.trustStore);
                    throwable = null;
                    try {
                        truststore.load(in, password);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((InputStream)in).close();
                            }
                        }
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(truststore);
                    builder.trustManager(tmf);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    logger.error(e.getMessage());
                    throw new RuntimeException("There was an error enabling SSL.", e);
                }
            }
        }
        if (null != sslSettings.sslCipherSuites && !sslSettings.sslCipherSuites.isEmpty()) {
            builder.ciphers(sslSettings.sslCipherSuites);
        }
        if (null != sslSettings.sslEnabledProtocols && !sslSettings.sslEnabledProtocols.isEmpty()) {
            builder.protocols(sslSettings.sslEnabledProtocols.toArray(new String[0]));
        }
        if (null != sslSettings.needClientAuth && ClientAuth.OPTIONAL == sslSettings.needClientAuth) {
            logger.warn("needClientAuth = OPTIONAL is not a secure configuration. Setting to REQUIRE.");
            sslSettings.needClientAuth = ClientAuth.REQUIRE;
        }
        builder.clientAuth(sslSettings.needClientAuth).sslProvider(provider);
        try {
            return builder.build();
        }
        catch (SSLException ssle) {
            logger.error(ssle.getMessage());
            throw new RuntimeException("There was an error enabling SSL.", ssle);
        }
    }
}

